/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item.consumables;

import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MilkBottleItem
extends Item {
    public static final String ID = "milk_bottle";
    private static final int DRINK_DURATION = 32;

    public MilkBottleItem() {
        this(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)ID))));
    }

    public MilkBottleItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        if (level.isClientSide() || !(livingEntity instanceof Player)) {
            return itemStack;
        }
        Player player = (Player)livingEntity;
        player.removeAllEffects();
        level.playSound(null, player.getX(), player.getY(), player.getZ(), (Holder)SoundEvents.GENERIC_DRINK, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        return itemStack.isEmpty() ? new ItemStack((ItemLike)Items.AIR) : itemStack;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 32;
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemStack) {
        return ItemUseAnimation.DRINK;
    }

    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)interactionHand);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipConsumer, TooltipFlag tooltipFlag) {
        this.addTooltip(tooltipConsumer, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.milk_bottle"), ChatFormatting.GRAY);
    }

    public void addTooltip(Consumer<Component> tooltipConsumer, Component component, ChatFormatting formatting) {
        List lines = Minecraft.getInstance().font.getSplitter().splitLines((FormattedText)component, 200, Style.EMPTY);
        for (FormattedText line : lines) {
            tooltipConsumer.accept((Component)Component.literal((String)line.getString()).withStyle(formatting));
        }
    }
}

