/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.menu.slots;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureDataSupport;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import de.markusbordihn.easymobfarm.menu.MobFarmSlot;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class CapturedMobSlot
extends MobFarmSlot {
    public CapturedMobSlot(Container container, int index, int x, int y) {
        super(container, index, x, y);
    }

    public boolean mayPlace(ItemStack itemStack) {
        if (this.hasItem()) {
            return false;
        }
        if (MobCaptureDataSupport.isSupported(itemStack) || itemStack.getItem() instanceof MobCaptureCardItem) {
            return true;
        }
        log.debug("Item {} {} is not supported for captured mob slot.", (Object)itemStack, itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY));
        return false;
    }

    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public Component getTooltip() {
        return TextComponent.getTooltipText("captured_mob_slot");
    }
}

