/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_2487;
import net.minecraft.class_4844;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UUIDUtils {
    protected static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Pattern UUID_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");

    private UUIDUtils() {
    }

    public static UUID readUUID(class_2487 compoundTag, String key) {
        Optional uuidOptional = compoundTag.method_67491(key, class_4844.field_25122);
        return uuidOptional.orElse(null);
    }

    public static void writeUUID(class_2487 compoundTag, String key, UUID uuid) {
        compoundTag.method_67494(key, class_4844.field_25122, (Object)uuid);
    }

    public static UUID textToUUID(String text) {
        if (text != null && !text.isEmpty()) {
            try {
                int i;
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                byte[] hashBytes = digest.digest(text.getBytes());
                long mostSigBits = 0L;
                long leastSigBits = 0L;
                for (i = 0; i < 8; ++i) {
                    mostSigBits = mostSigBits << 8 | (long)(hashBytes[i] & 0xFF);
                }
                for (i = 8; i < 16; ++i) {
                    leastSigBits = leastSigBits << 8 | (long)(hashBytes[i] & 0xFF);
                }
                return new UUID(mostSigBits, leastSigBits);
            }
            catch (NoSuchAlgorithmException e) {
                log.error("Unable to create UUID from text: {}", (Object)text, (Object)e);
            }
        }
        return UUID.randomUUID();
    }

    public static UUID parseUUID(String text) {
        if (text == null || text.length() != 36) {
            return null;
        }
        if (!UUID_PATTERN.matcher(text).matches()) {
            return null;
        }
        try {
            return UUID.fromString(text);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

