/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.screen;

import de.markusbordihn.easymobfarm.client.renderer.manager.EntityScalingManager;
import de.markusbordihn.easymobfarm.client.renderer.manager.RendererManager;
import de.markusbordihn.easymobfarm.client.screen.ContainerScreen;
import de.markusbordihn.easymobfarm.client.screen.ScreenHelper;
import de.markusbordihn.easymobfarm.client.screen.components.Graphics;
import de.markusbordihn.easymobfarm.config.MobFarmBonusConfig;
import de.markusbordihn.easymobfarm.config.RequiresKilledByPlayerConfig;
import de.markusbordihn.easymobfarm.menu.MobFarmMenu;
import de.markusbordihn.easymobfarm.menu.MobFarmSlot;
import de.markusbordihn.easymobfarm.menu.slots.OutputSlot;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MobFarmScreen<T extends MobFarmMenu>
extends ContainerScreen<T> {
    private static final ResourceLocation TEXTURE_UI = ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"textures/gui/mob_farm.png");
    private static final ResourceLocation TEXTURE_UI_IDLE = ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"textures/gui/mob_farm_idle.png");
    private static final ResourceLocation TEXTURE_ELEMENTS = ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"textures/gui/mob_farm_elements.png");
    private static final String TOOLTIP_PREFIX = "tooltip.easy_mob_farm.farm.";
    protected float xMouse;
    protected float yMouse;
    protected Entity entity;
    protected int entityExperience;

    public MobFarmScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    protected void renderDefaultScreenBg(GuiGraphics guiGraphics, int leftPos, int topPos) {
        Graphics.blit(guiGraphics, this.menu.getMobFarmStatus() == 0 ? TEXTURE_UI_IDLE : TEXTURE_UI, leftPos, topPos, 0, 0, 256, 243);
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        this.xMouse = x;
        this.yMouse = y;
        this.renderBackground(guiGraphics, x, y, partialTicks);
        super.render(guiGraphics, x, y, partialTicks);
        this.renderLockedSlot(guiGraphics, x, y);
        this.renderEntityType(guiGraphics, x, y);
        this.renderMobFarmProgress(guiGraphics, x, y);
        this.renderTooltip(guiGraphics, x, y);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
    }

    private void renderMobFarmProgress(GuiGraphics guiGraphics, int x, int y) {
        int mobFarmProgress = ((MobFarmMenu)this.getMenu()).getMobFarmProgress();
        int currentWidth = mobFarmProgress * 32 / 6000;
        Graphics.blit(guiGraphics, TEXTURE_ELEMENTS, this.leftPos + 113, this.topPos + 78, 0, 36, currentWidth, 16);
    }

    private void renderEntityType(GuiGraphics guiGraphics, int x, int y) {
        BlockPos blockPos = ((MobFarmMenu)this.getMenu()).getMobFarmBlockPos();
        if (blockPos == null || blockPos.equals((Object)BlockPos.ZERO)) {
            return;
        }
        int mobFarmStatus = ((MobFarmMenu)this.getMenu()).getMobFarmStatus();
        if (mobFarmStatus == 0) {
            return;
        }
        this.entity = RendererManager.getEntity(blockPos);
        if (this.entity != null) {
            ScreenHelper.renderEntity(guiGraphics, this.leftPos + 72, this.topPos + 80, (float)(this.leftPos + 70) - this.xMouse, (float)(this.topPos + 40) - this.yMouse, EntityScalingManager.getUIScale(this.entity), this.entity);
        } else if (this.entityExperience > 0) {
            this.entityExperience = 0;
        }
    }

    private void renderLockedSlot(GuiGraphics guiGraphics, int x, int y) {
        for (Slot slot : this.menu.slots) {
            OutputSlot outputSlot;
            if (!(slot instanceof OutputSlot) || (outputSlot = (OutputSlot)slot).isActive()) continue;
            Graphics.blit(guiGraphics, TEXTURE_ELEMENTS, this.leftPos + slot.x - 1, this.topPos + slot.y - 1, 0, 18, 18, 18);
        }
    }

    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        for (Slot slot : this.menu.slots) {
            MobFarmSlot mobFarmSlot;
            if (!(slot instanceof MobFarmSlot) || (mobFarmSlot = (MobFarmSlot)slot).getTooltip() == null || !this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY) || slot.hasItem()) continue;
            this.renderSlotTooltip(guiGraphics, mobFarmSlot, mouseX, mouseY);
        }
        if (this.isHovering(24, 17, 10, 13, mouseX, mouseY)) {
            ArrayList<MutableComponent> infoText = new ArrayList<MutableComponent>(List.of());
            if (((MobFarmMenu)this.getMenu()).getMobFarmType() != null) {
                MutableComponent mutableComponent = TextComponent.getTranslatedTextRaw(TOOLTIP_PREFIX + ((MobFarmMenu)this.getMenu()).getMobFarmType().getId(), String.valueOf(((MobFarmMenu)this.getMenu()).getMobFarmTierLevel()));
                infoText.add(mutableComponent.withStyle(switch (((MobFarmMenu)this.getMenu()).getMobFarmTierLevel()) {
                    case 1 -> ChatFormatting.GREEN;
                    case 2 -> ChatFormatting.YELLOW;
                    case 3 -> ChatFormatting.RED;
                    default -> ChatFormatting.WHITE;
                }));
            }
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.tier", new Object[]{((MobFarmMenu)this.getMenu()).getMobFarmTierLevel()}));
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.status", (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.status_" + ((MobFarmMenu)this.getMenu()).getMobFarmStatus())));
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.progress", new Object[]{((MobFarmMenu)this.getMenu()).getMobFarmProgress(), 6000}));
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.progression_speed", new Object[]{((MobFarmMenu)this.getMenu()).getMobFarmProgressionSpeed(), ((MobFarmMenu)this.getMenu()).getMobFarmProgressionSpeedBonus()}));
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.output_slots", new Object[]{((MobFarmMenu)this.getMenu()).getMobFarmNumberOfOutputSlots()}));
            if (this.entity != null && ((MobFarmMenu)this.getMenu()).getMobFarmStatus() != 0) {
                int capturedMobExperience;
                infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.entity_type", new Object[]{this.entity.getType().toString()}));
                if (RequiresKilledByPlayerConfig.requiresKilledByPlayer(this.entity.getType())) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.killed_by_player").withStyle(ChatFormatting.RED));
                }
                if ((capturedMobExperience = ((MobFarmMenu)this.getMenu()).getCapturedMobExperience()) >= 3) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.experience", new Object[]{capturedMobExperience}).withStyle(ChatFormatting.GREEN));
                } else if (capturedMobExperience > 0) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.low_experience", new Object[]{capturedMobExperience}).withStyle(ChatFormatting.YELLOW));
                } else if (capturedMobExperience == 0) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.no_experience").withStyle(ChatFormatting.RED));
                }
                ItemStack bonusLootDrop = MobFarmBonusConfig.getBonusDropEntry(((MobFarmMenu)this.getMenu()).getMobFarmType(), ((MobFarmMenu)this.getMenu()).getMobFarmTierLevel(), this.entity.getType());
                if (!bonusLootDrop.isEmpty()) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.bonus_drop", new Object[]{bonusLootDrop.getDisplayName()}).withStyle(ChatFormatting.GREEN));
                } else {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.no_bonus_drop").withStyle(ChatFormatting.GRAY));
                }
            }
            guiGraphics.renderComponentTooltip(this.font, infoText, mouseX, mouseY);
        }
    }

    private void renderSlotTooltip(GuiGraphics guiGraphics, MobFarmSlot mobFarmSlot, int mouseX, int mouseY) {
        Component component = mobFarmSlot.getTooltip();
        if (component == null) {
            return;
        }
        List wrappedText = this.font.split((FormattedText)component, 150);
        guiGraphics.renderTooltip(this.font, wrappedText, mouseX, mouseY);
    }
}

