/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.config;

import de.markusbordihn.easymobfarm.config.Config;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Rarity;

public class MobCaptureCardRarityConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "mob_capture_card_rarity.cfg";
    public static final String CONFIG_FILE_HEADER = " Mob Capture Card Rarity Configuration\n\n This configuration file allows you to define the rarity for the Mob Capture Cards.\n\n The format is as follows:\n - <entity_name> = Rarity\n\n Example:\n - minecraft:zombie = COMMON\n\n Supported rarities are:\n  - COMMON\n  - UNCOMMON\n  - RARE\n  - EPIC\n\n";
    private static final HashMap<String, Rarity> mobCaptureCardRarity = new HashMap();
    private static final HashMap<String, Rarity> defaultRarity = new HashMap();

    public static void registerConfig() {
        MobCaptureCardRarityConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        MobCaptureCardRarityConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        Rarity propertyValue;
        File configFile = MobCaptureCardRarityConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = MobCaptureCardRarityConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        for (Map.Entry<String, Rarity> entry : defaultRarity.entrySet()) {
            String propertyKey = entry.getKey();
            propertyValue = entry.getValue();
            if (properties.containsKey(propertyKey)) continue;
            properties.setProperty(propertyKey, propertyValue.name());
        }
        Set<String> propertyKeys = properties.stringPropertyNames();
        for (String propertyKey : propertyKeys) {
            propertyValue = MobCaptureCardRarityConfig.parseConfigValue(properties, propertyKey, Rarity.COMMON);
            mobCaptureCardRarity.put(propertyKey.trim().toLowerCase(Locale.ROOT), propertyValue);
        }
        MobCaptureCardRarityConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static boolean hasRarity(EntityType<?> entityType) {
        return MobCaptureCardRarityConfig.hasRarity(BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString());
    }

    public static boolean hasRarity(String entityName) {
        return mobCaptureCardRarity.containsKey(entityName.trim().toLowerCase(Locale.ROOT));
    }

    public static Rarity getRarity(EntityType<?> entityType) {
        return MobCaptureCardRarityConfig.getRarity(BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString());
    }

    public static Rarity getRarity(String entityName) {
        return mobCaptureCardRarity.getOrDefault(entityName.trim().toLowerCase(Locale.ROOT), Rarity.COMMON);
    }

    static {
        defaultRarity.put("minecraft:bat", Rarity.COMMON);
        defaultRarity.put("minecraft:cat", Rarity.COMMON);
        defaultRarity.put("minecraft:chicken", Rarity.COMMON);
        defaultRarity.put("minecraft:cow", Rarity.COMMON);
        defaultRarity.put("minecraft:creeper", Rarity.COMMON);
        defaultRarity.put("minecraft:drowned", Rarity.COMMON);
        defaultRarity.put("minecraft:horse", Rarity.COMMON);
        defaultRarity.put("minecraft:pig", Rarity.COMMON);
        defaultRarity.put("minecraft:pillager", Rarity.COMMON);
        defaultRarity.put("minecraft:sheep", Rarity.COMMON);
        defaultRarity.put("minecraft:skeleton", Rarity.COMMON);
        defaultRarity.put("minecraft:spider", Rarity.COMMON);
        defaultRarity.put("minecraft:squid", Rarity.COMMON);
        defaultRarity.put("minecraft:villager", Rarity.COMMON);
        defaultRarity.put("minecraft:witch", Rarity.COMMON);
        defaultRarity.put("minecraft:wolf", Rarity.COMMON);
        defaultRarity.put("minecraft:zombie", Rarity.COMMON);
        defaultRarity.put("minecraft:cave_spider", Rarity.UNCOMMON);
        defaultRarity.put("minecraft:enderman", Rarity.UNCOMMON);
        defaultRarity.put("minecraft:evoker", Rarity.UNCOMMON);
        defaultRarity.put("minecraft:fox", Rarity.UNCOMMON);
        defaultRarity.put("minecraft:husk", Rarity.UNCOMMON);
        defaultRarity.put("minecraft:llama", Rarity.UNCOMMON);
        defaultRarity.put("minecraft:panda", Rarity.UNCOMMON);
        defaultRarity.put("minecraft:polar_bear", Rarity.UNCOMMON);
        defaultRarity.put("minecraft:slime", Rarity.UNCOMMON);
        defaultRarity.put("minecraft:stray", Rarity.UNCOMMON);
        defaultRarity.put("minecraft:zombified_piglin", Rarity.UNCOMMON);
        defaultRarity.put("minecraft:zombified_villager", Rarity.UNCOMMON);
        defaultRarity.put("minecraft:blaze", Rarity.RARE);
        defaultRarity.put("minecraft:ghast", Rarity.RARE);
        defaultRarity.put("minecraft:guardian", Rarity.RARE);
        defaultRarity.put("minecraft:magma_cube", Rarity.RARE);
        defaultRarity.put("minecraft:phantom", Rarity.RARE);
        defaultRarity.put("minecraft:ravager", Rarity.RARE);
        defaultRarity.put("minecraft:shulker", Rarity.RARE);
        defaultRarity.put("minecraft:strider", Rarity.RARE);
        defaultRarity.put("minecraft:vindicator", Rarity.RARE);
        defaultRarity.put("minecraft:elder_guardian", Rarity.EPIC);
        defaultRarity.put("minecraft:ender_dragon", Rarity.EPIC);
        defaultRarity.put("minecraft:illusioner", Rarity.EPIC);
        defaultRarity.put("minecraft:piglin_brute", Rarity.EPIC);
        defaultRarity.put("minecraft:warden", Rarity.EPIC);
        defaultRarity.put("minecraft:wither", Rarity.EPIC);
        defaultRarity.put("minecraft:wither_skeleton", Rarity.EPIC);
    }
}

