/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.experience;

import java.lang.reflect.Method;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;

public interface ExperienceManagerInterface {
    default public int getExperienceReward(ServerLevel serverLevel, LivingEntity livingEntity) {
        try {
            if (livingEntity instanceof Animal) {
                Animal animal = (Animal)livingEntity;
                return animal.getExperienceReward(serverLevel, null);
            }
            if (livingEntity instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                return mob.getExperienceReward(serverLevel, null);
            }
            return livingEntity.getExperienceReward(serverLevel, null);
        }
        catch (Exception e) {
            return 0;
        }
    }

    default public int getExperienceReward(LivingEntity livingEntity) {
        return 0;
    }

    default public boolean shouldDropExperience(LivingEntity livingEntity) {
        try {
            return livingEntity.shouldDropExperience();
        }
        catch (Exception e) {
            return false;
        }
    }

    default public Method findMethodInHierarchy(Class<?> clazz, String methodName) {
        while (clazz != null) {
            try {
                return clazz.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }
}

