/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import de.markusbordihn.easymobfarm.config.MobCatcherConfig;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModRecipeManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[Recipe Manager]";
    private static final String MOB_CAPTURE_PREFIX = "mob_catcher/";

    private ModRecipeManager() {
    }

    public static void register(MinecraftServer minecraftServer) {
        log.info("{} Mod Recipe Manager ...", (Object)"Register Easy Mob Farm");
        ArrayList recipes = new ArrayList(minecraftServer.getRecipeManager().getRecipes());
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.ENDURING_CAPTURE_NET_ENABLED, "enduring_capture_net");
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.IRONBOUND_CONTAINMENT_CAGE_ENABLED, "ironbound_containment_cage");
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.MYSTIC_BINDING_CRYSTAL_ENABLED, "mystic_binding_crystal");
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.VOID_BINDING_CHAIN_ENABLED, "void_binding_chain");
        if (minecraftServer.getRecipeManager().getRecipes().size() != recipes.size()) {
            log.info("Updating recipes with adjusted recipes ...");
            minecraftServer.getRecipeManager().replaceRecipes(recipes);
            for (ServerPlayer player : minecraftServer.getPlayerList().getPlayers()) {
                log.info("{} Sync recipe to player {} ...", (Object)LOG_PREFIX, (Object)player.getName().getString());
                player.connection.send((Packet)new ClientboundUpdateRecipesPacket(minecraftServer.getRecipeManager().getRecipes()));
            }
            minecraftServer.getRecipeManager().getRecipes().forEach(recipeHolder -> log.debug("{} Loaded recipe: {}", (Object)LOG_PREFIX, (Object)recipeHolder.id()));
        }
    }

    private static boolean removeRecipeIfDisabled(Collection<RecipeHolder<?>> recipes, boolean isEnabled, String itemId) {
        if (isEnabled) {
            return false;
        }
        String recipePath = MOB_CAPTURE_PREFIX + itemId;
        boolean removed = recipes.removeIf(recipeHolder -> recipeHolder.id().getNamespace().equals("easy_mob_farm") && recipeHolder.id().getPath().equals(recipePath));
        if (removed) {
            log.info("{} Removed {} recipe ...", (Object)LOG_PREFIX, (Object)recipePath);
        } else {
            log.error("{} Failed to deactivate recipe {} !", (Object)LOG_PREFIX, (Object)recipePath);
        }
        return removed;
    }
}

