/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.event;

import de.markusbordihn.easymobfarm.client.model.ModelManager;
import de.markusbordihn.easymobfarm.client.model.ModelManagerInterface;
import de.markusbordihn.easymobfarm.client.model.UnbakedMobCaptureCardModel;
import de.markusbordihn.easymobfarm.config.MobCaptureCardModelsConfig;
import java.util.Set;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelEventHandler {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    private ModelEventHandler() {
    }

    public static void registerModelEventHandler() {
        ModelLoadingRegistry.INSTANCE.registerModelProvider((resourceManager, consumer) -> {
            log.info("Registering card models ...");
            Set.of(UnbakedMobCaptureCardModel.MODEL, ModelManagerInterface.DEFAULT_MODEL, ModelManagerInterface.DEFAULT_UNCOMMON_MODEL, ModelManagerInterface.DEFAULT_RARE_MODEL, ModelManagerInterface.DEFAULT_EPIC_MODEL, ModelManagerInterface.DEFAULT_FISH_MODEL).forEach(resourceLocation -> {
                if (resourceLocation instanceof class_1091) {
                    class_1091 modelResourceLocation = (class_1091)resourceLocation;
                    resourceLocation = ModelManager.getRegistrationModelResourceLocation(modelResourceLocation);
                }
                log.info("Registering default model {} ...", resourceLocation);
                consumer.accept(resourceLocation);
            });
            MobCaptureCardModelsConfig.getMobCaptureCardModels().forEach(entityName -> {
                class_1091 modelResourceLocation = MobCaptureCardModelsConfig.getModelResourceLocation(entityName);
                if (modelResourceLocation == null) {
                    log.error("Skipping model for entity {} because of invalid resource locations.", entityName);
                    return;
                }
                log.info("Registering custom model {} for {} ...", (Object)modelResourceLocation, entityName);
                consumer.accept(modelResourceLocation);
            });
        });
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(resourceManager -> (location, context) -> {
            if (location.method_12836().equals("easy_mob_farm")) {
                log.debug("Found unbaked model: {} ({})", (Object)location, (Object)location.method_12832());
                if (location.method_12832().equals("item/mob_capture_card")) {
                    log.info("Adjusting baked model for {} ...", (Object)location);
                    class_1100 unbakedModel = context.loadModel(UnbakedMobCaptureCardModel.MODEL);
                    if (unbakedModel == null) {
                        log.error("Unable to load unbaked model for resource location {} from {}", (Object)location, (Object)UnbakedMobCaptureCardModel.MODEL);
                        return null;
                    }
                    log.info("Baking unbaked model for {} ...", (Object)location);
                    return new UnbakedMobCaptureCardModel(unbakedModel);
                }
            }
            return null;
        });
    }
}

