/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1451;
import net.minecraft.class_1589;
import net.minecraft.class_1621;
import net.minecraft.class_1646;
import net.minecraft.class_2487;

public class MobVariantData {
    public static final String VARIANT_TAG = "Variant";
    public static final String LARGE_VARIANT = "large";
    public static final String MEDIUM_VARIANT = "medium";
    public static final String SMALL_VARIANT = "small";
    public static final String TINY_VARIANT = "tiny";
    private static final Map<Integer, String> CAT_VARIANT_MAP = new HashMap<Integer, String>();

    private MobVariantData() {
    }

    public static String getVariant(class_1299<?> entityType) {
        return null;
    }

    public static String getVariant(class_1309 livingEntity) {
        if (livingEntity instanceof class_1451) {
            class_1451 cat = (class_1451)livingEntity;
            return CAT_VARIANT_MAP.get(cat.method_6571());
        }
        if (livingEntity instanceof class_1646) {
            class_1646 villager = (class_1646)livingEntity;
            return villager.method_7231().method_16924().method_35202();
        }
        if (livingEntity instanceof class_1589) {
            class_1589 magmaCube = (class_1589)livingEntity;
            return MobVariantData.getSizeVariant(magmaCube.method_7152());
        }
        if (livingEntity instanceof class_1621) {
            class_1621 slime = (class_1621)livingEntity;
            return MobVariantData.getSizeVariant(slime.method_7152());
        }
        return null;
    }

    public static String getVariant(class_2487 compoundTag) {
        if (compoundTag == null) {
            return null;
        }
        if (compoundTag.method_10545(VARIANT_TAG)) {
            return compoundTag.method_10558(VARIANT_TAG);
        }
        if (compoundTag.method_10545(VARIANT_TAG.toLowerCase(Locale.ROOT))) {
            return compoundTag.method_10558(VARIANT_TAG.toLowerCase(Locale.ROOT));
        }
        return null;
    }

    public static String getSizeVariant(float size) {
        if (size <= 1.0f) {
            return TINY_VARIANT;
        }
        if (size <= 2.0f) {
            return SMALL_VARIANT;
        }
        if (size < 4.0f) {
            return MEDIUM_VARIANT;
        }
        if (size >= 4.0f) {
            return LARGE_VARIANT;
        }
        return "";
    }

    public static int getCatVariant(String variant) {
        for (Map.Entry<Integer, String> entry : CAT_VARIANT_MAP.entrySet()) {
            if (!entry.getValue().equals(variant)) continue;
            return entry.getKey();
        }
        return 0;
    }

    static {
        CAT_VARIANT_MAP.put(0, "tabby");
        CAT_VARIANT_MAP.put(1, "black");
        CAT_VARIANT_MAP.put(2, "red");
        CAT_VARIANT_MAP.put(3, "siamese");
        CAT_VARIANT_MAP.put(4, "british_shorthair");
        CAT_VARIANT_MAP.put(5, "calico");
        CAT_VARIANT_MAP.put(6, "persian");
        CAT_VARIANT_MAP.put(7, "ragdoll");
        CAT_VARIANT_MAP.put(8, "white");
        CAT_VARIANT_MAP.put(9, "jellie");
        CAT_VARIANT_MAP.put(10, "all_black");
    }
}

