/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.loot;

import de.markusbordihn.easymobfarm.compat.CompatConstants;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.experience.ExperienceManager;
import de.markusbordihn.easymobfarm.item.upgrade.EnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.EggCollectorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.ExperienceEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.HoneyExtractorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.HoneyHarvesterFrameEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.LootEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.LuckEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.MilkExtractorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.PollenTrapEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.SheepEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.SwordEnhancementItem;
import de.markusbordihn.easymobfarm.server.player.FakePlayer;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1430;
import net.minecraft.class_1472;
import net.minecraft.class_1528;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4466;
import net.minecraft.class_47;
import net.minecraft.class_52;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Random random = new Random();
    private static FakePlayer fakePlayer;

    private LootManager() {
    }

    public static class_2371<class_1799> getEntityLoot(MobCaptureData mobCaptureData, List<EnhancementItem> enhancements, class_1937 level) {
        class_1299<?> entityType = mobCaptureData.entityType();
        if (entityType == null) {
            log.error("Unable to get entity type from Mob Capture data: {}", (Object)mobCaptureData);
            return class_2371.method_10211();
        }
        class_1297 entity = entityType.method_5883(level);
        if (entity == null) {
            log.error("Unable to create entity {}!", entityType);
            return class_2371.method_10211();
        }
        entity.method_5651(mobCaptureData.data());
        if (entity instanceof class_1472) {
            class_1472 sheepEntity = (class_1472)entity;
            sheepEntity.method_6635(false);
            if (mobCaptureData.hasColor()) {
                sheepEntity.method_6631(mobCaptureData.color());
            }
        }
        class_2371<class_1799> drops = LootManager.getEntityLoot(entity, enhancements, level);
        entity.method_31472();
        return drops;
    }

    public static class_2371<class_1799> getEntityLoot(class_1297 entity, List<EnhancementItem> enhancements, class_1937 level) {
        class_1309 livingEntity;
        class_2371 drops;
        block9: {
            block8: {
                drops = class_2371.method_10211();
                if (!(entity instanceof class_1309)) break block8;
                livingEntity = (class_1309)entity;
                if (level instanceof class_3218) break block9;
            }
            return drops;
        }
        class_3218 serverLevel = (class_3218)level;
        FakePlayer fakePlayer = LootManager.getFakePlayer(serverLevel, entity.method_24515());
        class_47.class_48 lootContextBuilder = LootManager.createLootContextBuilder(serverLevel, livingEntity);
        class_2960 lootTableLocation = LootManager.getLootTableLocation(livingEntity, enhancements);
        float additionalLuck = 0.0f;
        int additionalRolls = 0;
        for (EnhancementItem enhancement : enhancements) {
            if (enhancement instanceof SwordEnhancementItem) {
                LootManager.setSwordEnhancementParameters(lootContextBuilder, fakePlayer);
                additionalLuck += 0.5f;
            }
            if (enhancement instanceof LootEnhancementItem) {
                ++additionalRolls;
            }
            if (!(enhancement instanceof LuckEnhancementItem)) continue;
            additionalLuck += 1.0f;
        }
        if (additionalLuck > 0.0f) {
            lootContextBuilder.method_303(additionalLuck);
        }
        class_47 lootContext = lootContextBuilder.method_309(class_173.field_1173);
        class_52 lootTable = serverLevel.method_8503().method_3857().method_367(lootTableLocation);
        for (int i = 0; i <= additionalRolls; ++i) {
            lootTable.method_319(lootContext).stream().filter(itemStack -> !itemStack.method_7960()).forEach(arg_0 -> drops.add(arg_0));
            LootManager.handleSpecialEntityDrops(livingEntity, (class_2371<class_1799>)drops);
        }
        LootManager.handlePostEnhancements(enhancements, livingEntity, fakePlayer, (class_2371<class_1799>)drops);
        return drops;
    }

    public static class_2371<class_1799> getLuckyLoot(MobCaptureData mobCaptureData, class_2338 blockPos, class_1937 Level2) {
        class_2371 drops = class_2371.method_10211();
        if (!(Level2 instanceof class_3218)) {
            return drops;
        }
        class_3218 serverLevel = (class_3218)Level2;
        class_2960 lootTableLocation = new class_2960("minecraft", switch (mobCaptureData.rarity()) {
            default -> throw new IncompatibleClassChangeError();
            case class_1814.field_8906 -> "chests/simple_dungeon";
            case class_1814.field_8907 -> "chests/village/village_toolsmith";
            case class_1814.field_8903 -> "chests/stronghold_library";
            case class_1814.field_8904 -> "chests/end_city_treasure";
        });
        FakePlayer fakePlayer = LootManager.getFakePlayer(serverLevel, blockPos);
        class_52 lootTable = serverLevel.method_8503().method_3857().method_367(lootTableLocation);
        class_47.class_48 lootContextBuilder = LootManager.createLootChestContextBuilder(serverLevel, (class_1309)fakePlayer);
        lootContextBuilder.method_303(switch (mobCaptureData.rarity()) {
            default -> throw new IncompatibleClassChangeError();
            case class_1814.field_8906 -> 0.0f;
            case class_1814.field_8907 -> 0.5f;
            case class_1814.field_8903 -> 1.0f;
            case class_1814.field_8904 -> 1.5f;
        });
        class_47 lootContext = lootContextBuilder.method_309(class_173.field_1179);
        lootTable.method_319(lootContext).stream().filter(itemStack -> !itemStack.method_7960()).forEach(arg_0 -> drops.add(arg_0));
        return drops;
    }

    private static void handleSpecialEntityDrops(class_1309 livingEntity, class_2371<class_1799> drops) {
        if (livingEntity instanceof class_1528) {
            if (random.nextInt(2) == 0) {
                drops.add((Object)new class_1799((class_1935)class_1802.field_8137));
            }
            if (random.nextInt(2) == 0) {
                drops.add((Object)new class_1799((class_1935)class_1802.field_17515));
            }
        }
    }

    private static class_47.class_48 createLootContextBuilder(class_3218 serverLevel, class_1309 livingEntity) {
        return new class_47.class_48(serverLevel).method_311(random).method_312(class_181.field_1231, (Object)class_1282.field_5869).method_312(class_181.field_24424, (Object)livingEntity.method_19538()).method_312(class_181.field_1226, (Object)livingEntity);
    }

    private static class_47.class_48 createLootChestContextBuilder(class_3218 serverLevel, class_1309 livingEntity) {
        return new class_47.class_48(serverLevel).method_311(random).method_312(class_181.field_24424, (Object)livingEntity.method_19538()).method_312(class_181.field_1226, (Object)livingEntity);
    }

    private static class_2960 getLootTableLocation(class_1309 livingEntity, List<EnhancementItem> enhancements) {
        class_2960 lootTableLocation = livingEntity.method_5864().method_16351();
        for (EnhancementItem enhancement : enhancements) {
            if (!(enhancement instanceof SheepEnhancementItem) || !(livingEntity instanceof class_1472)) continue;
            class_1472 sheep = (class_1472)livingEntity;
            class_1767 color = sheep.method_6633();
            lootTableLocation = new class_2960("minecraft", "entities/sheep/" + color.method_7792());
        }
        return lootTableLocation;
    }

    private static void setSwordEnhancementParameters(class_47.class_48 lootContextBuilder, FakePlayer fakePlayer) {
        lootContextBuilder.method_312(class_181.field_1233, (Object)fakePlayer).method_312(class_181.field_1230, (Object)fakePlayer).method_312(class_181.field_1227, (Object)fakePlayer);
    }

    private static void handlePostEnhancements(List<EnhancementItem> enhancements, class_1309 livingEntity, FakePlayer fakePlayer, class_2371<class_1799> drops) {
        for (EnhancementItem enhancement : enhancements) {
            ExperienceEnhancementItem experienceEnhancementItem;
            if (enhancement instanceof ExperienceEnhancementItem && random.nextInt((experienceEnhancementItem = (ExperienceEnhancementItem)enhancement).experienceDropChance()) == 0 && ExperienceManager.shouldDropExperience(livingEntity)) {
                int experience = ExperienceManager.getExperienceReward(livingEntity, (class_1657)fakePlayer);
                if (experience >= experienceEnhancementItem.minExperienceForDrop()) {
                    drops.add((Object)new class_1799((class_1935)class_1802.field_8287));
                } else {
                    log.debug("Experience drop of {} is below minimum threshold of {} for {}", (Object)experience, (Object)experienceEnhancementItem.minExperienceForDrop(), (Object)livingEntity);
                }
            }
            if (livingEntity instanceof class_4466) {
                if (enhancement instanceof HoneyHarvesterFrameEnhancementItem && random.nextInt(4) == 0) {
                    drops.add((Object)new class_1799((class_1935)class_1802.field_20414));
                } else if (enhancement instanceof HoneyExtractorEnhancementItem && random.nextInt(10) == 0) {
                    drops.add((Object)new class_1799((class_1935)class_1802.field_20417));
                } else if (enhancement instanceof PollenTrapEnhancementItem && random.nextInt(5) == 0) {
                    if (random.nextFloat() < 0.3f) {
                        drops.add((Object)LootManager.getRandomFlower());
                    } else {
                        drops.add((Object)LootManager.getRandomDye());
                    }
                }
            }
            if (livingEntity instanceof class_1430 && enhancement instanceof MilkExtractorEnhancementItem && random.nextInt(2) == 0) {
                class_1792 milkBottle = CompatConstants.MOD_FARMERS_DELIGHT_LOADED ? (class_1792)class_2378.field_11142.method_10223(new class_2960("farmersdelight:milk_bottle")) : (class_1792)class_2378.field_11142.method_10223(new class_2960("easy_mob_farm:milk_bottle"));
                drops.add((Object)new class_1799((class_1935)milkBottle));
            }
            if (!(livingEntity instanceof class_1428) || !(enhancement instanceof EggCollectorEnhancementItem) || random.nextInt(2) != 0) continue;
            drops.add((Object)new class_1799((class_1935)class_1802.field_8803));
        }
    }

    private static FakePlayer getFakePlayer(class_3218 level, class_2338 blockPos) {
        if (FakePlayer.isInvalidFakePlayer(fakePlayer)) {
            fakePlayer = new FakePlayer(level, blockPos);
            return fakePlayer;
        }
        return fakePlayer.updatePosition(level, blockPos);
    }

    private static class_1799 getRandomFlower() {
        List<class_1792> flowers = List.of(class_1802.field_8491, class_1802.field_8880, class_1802.field_17499, class_1802.field_17500, class_1802.field_17501, class_1802.field_17502, class_1802.field_17509, class_1802.field_17510, class_1802.field_17511, class_1802.field_17512, class_1802.field_17513, class_1802.field_17514);
        return new class_1799((class_1935)flowers.get(new Random().nextInt(flowers.size())));
    }

    private static class_1799 getRandomDye() {
        List<class_1792> dyes = List.of(class_1802.field_8192, class_1802.field_8264, class_1802.field_8345, class_1802.field_8492, class_1802.field_8330, class_1802.field_8446, class_1802.field_8226);
        return new class_1799((class_1935)dyes.get(new Random().nextInt(dyes.size())));
    }
}

