/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1091;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobCaptureCardResourceManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[Mob Capture Card Resource Manager] ";
    private static final Map<Integer, String> MOB_CAPTURE_CARD_MODELS = new HashMap<Integer, String>();

    private MobCaptureCardResourceManager() {
    }

    public static void loadMobCaptureCardData(class_3300 resourceManager) {
        class_2960 mobCaptureCardLocation = new class_2960("easy_mob_farm", "models/item/mob_capture_card/mob_capture_cards.json");
        MOB_CAPTURE_CARD_MODELS.clear();
        resourceManager.method_29213().forEach(packResources -> {
            if (packResources.method_14411(class_3264.field_14188, mobCaptureCardLocation)) {
                MobCaptureCardResourceManager.processMobCaptureCardData(packResources, mobCaptureCardLocation);
            } else {
                log.debug("{} Skipping pack {} because it does not contain {}", (Object)LOG_PREFIX, (Object)packResources.method_14409(), (Object)mobCaptureCardLocation);
            }
        });
    }

    public static void processMobCaptureCardData(class_3262 packResources, class_2960 mobCaptureCardLocation) {
        try {
            InputStream inputStream = packResources.method_14405(class_3264.field_14188, mobCaptureCardLocation);
            InputStreamReader reader = new InputStreamReader(inputStream);
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonArray captureCards = jsonObject.getAsJsonArray("mob_capture_cards");
            captureCards.forEach(element -> {
                JsonObject card = element.getAsJsonObject();
                int cardId = card.get("card_id").getAsInt();
                String modelPath = card.get("model").getAsString();
                if (cardId <= 0 || modelPath == null || modelPath.isEmpty()) {
                    log.error("{} Failed to load custom capture card with id {} and model {}", (Object)LOG_PREFIX, (Object)cardId, (Object)modelPath);
                    return;
                }
                log.debug("{} Added custom mob capture card with id {} and model {}", (Object)LOG_PREFIX, (Object)cardId, (Object)modelPath);
                MOB_CAPTURE_CARD_MODELS.put(cardId, modelPath);
            });
            reader.close();
        }
        catch (Exception e) {
            log.error("{} Failed to load custom capture cards for {}", (Object)LOG_PREFIX, (Object)packResources.method_14409(), (Object)e);
        }
    }

    public static boolean isSupportedCardId(int cardID) {
        return MOB_CAPTURE_CARD_MODELS.containsKey(cardID);
    }

    public static String getModelForCustomModelData(int cardID) {
        return MOB_CAPTURE_CARD_MODELS.getOrDefault(cardID, "easy_mob_farm:item/mob_capture_card/default");
    }

    public static class_2960 getResourceLocationForCardId(int cardID) {
        return new class_2960(MobCaptureCardResourceManager.getModelForCustomModelData(cardID));
    }

    public static class_1091 getModelResourceLocationForCardId(int cardID) {
        String modelPath = MobCaptureCardResourceManager.getModelForCustomModelData(cardID);
        if (modelPath.contains(":item/")) {
            modelPath = modelPath.replace(":item/", ":");
        }
        return new class_1091(modelPath, "inventory");
    }

    public static Collection<String> getCustomModelPaths() {
        return MOB_CAPTURE_CARD_MODELS.values();
    }
}

