/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.tabs;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.config.MobCaptureCardModelsConfig;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomMobCaptureCards {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    private CustomMobCaptureCards() {
    }

    public static Set<class_1799> getCustomMobCaptureCards(class_1935 mobCaptureCardItem) {
        if (!(mobCaptureCardItem instanceof MobCaptureCardItem)) {
            return Collections.emptySet();
        }
        LinkedHashSet<class_1799> result = new LinkedHashSet<class_1799>();
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Common Card", class_1299.field_6131, class_1814.field_8906)));
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Uncommon Card", class_1299.field_6131, class_1814.field_8907)));
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Rare Card", class_1299.field_6131, class_1814.field_8903)));
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Epic Card", class_1299.field_6131, class_1814.field_8904)));
        MobCaptureCardModelsConfig.getMobCaptureCardModels().forEach(modelKey -> {
            Object[] modelKeyData = MobCaptureCardModelsConfig.extractEntityKeyData(modelKey);
            if (modelKeyData[0] == null) {
                return;
            }
            String entityName = (String)modelKeyData[0];
            if (entityName.isEmpty()) {
                return;
            }
            Optional entityType = class_2378.field_11145.method_17966(new class_2960(entityName));
            if (entityType.isEmpty()) {
                if (entityName.startsWith("minecraft:")) {
                    log.error("Unknown entity type {} for mob capture card!", (Object)entityName);
                } else {
                    log.warn("Unknown entity type {} for mob capture card!", (Object)entityName);
                }
                return;
            }
            class_1799 itemStack = MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, (class_1299)entityType.get(), (String)modelKeyData[1], (class_1767)modelKeyData[2]);
            if (itemStack != null) {
                result.add(itemStack);
            }
        });
        return result;
    }
}

