/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easymobfarm.client.renderer.manager.EntityScalingManager;
import de.markusbordihn.easymobfarm.client.renderer.manager.RendererManager;
import de.markusbordihn.easymobfarm.client.screen.ContainerScreen;
import de.markusbordihn.easymobfarm.client.screen.ScreenHelper;
import de.markusbordihn.easymobfarm.client.screen.components.Graphics;
import de.markusbordihn.easymobfarm.config.MobFarmBonusConfig;
import de.markusbordihn.easymobfarm.config.RequiresKilledByPlayerConfig;
import de.markusbordihn.easymobfarm.menu.MobFarmMenu;
import de.markusbordihn.easymobfarm.menu.MobFarmSlot;
import de.markusbordihn.easymobfarm.menu.slots.OutputSlot;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MobFarmScreen<T extends MobFarmMenu>
extends ContainerScreen<T> {
    private static final ResourceLocation TEXTURE_UI = new ResourceLocation("easy_mob_farm", "textures/gui/mob_farm.png");
    private static final ResourceLocation TEXTURE_UI_IDLE = new ResourceLocation("easy_mob_farm", "textures/gui/mob_farm_idle.png");
    private static final ResourceLocation TEXTURE_ELEMENTS = new ResourceLocation("easy_mob_farm", "textures/gui/mob_farm_elements.png");
    private static final String TOOLTIP_PREFIX = "tooltip.easy_mob_farm.farm.";
    protected float xMouse;
    protected float yMouse;
    protected Entity entity;
    protected int entityExperience;

    public MobFarmScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    protected void renderDefaultScreenBg(PoseStack poseStack, int leftPos, int topPos) {
        Graphics.blit(poseStack, this.menu.getMobFarmStatus() == 0 ? TEXTURE_UI_IDLE : TEXTURE_UI, leftPos, topPos, 0, 0, 256, 243);
    }

    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        this.xMouse = x;
        this.yMouse = y;
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, x, y, partialTicks);
        this.renderLockedSlot(poseStack, x, y);
        this.renderEntityType(poseStack, x, y);
        this.renderMobFarmProgress(poseStack, x, y);
        this.m_7025_(poseStack, x, y);
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
    }

    private void renderMobFarmProgress(PoseStack poseStack, int x, int y) {
        int mobFarmProgress = ((MobFarmMenu)this.m_6262_()).getMobFarmProgress();
        int currentWidth = mobFarmProgress * 32 / 6000;
        Graphics.blit(poseStack, TEXTURE_ELEMENTS, this.f_97735_ + 113, this.f_97736_ + 78, 0, 36, currentWidth, 16);
    }

    private void renderEntityType(PoseStack poseStack, int x, int y) {
        BlockPos blockPos = ((MobFarmMenu)this.m_6262_()).getMobFarmBlockPos();
        if (blockPos == null || blockPos.equals((Object)BlockPos.f_121853_)) {
            return;
        }
        int mobFarmStatus = ((MobFarmMenu)this.m_6262_()).getMobFarmStatus();
        if (mobFarmStatus == 0) {
            return;
        }
        this.entity = RendererManager.getEntity(blockPos);
        if (this.entity != null) {
            ScreenHelper.renderEntity(this.f_97735_ + 72, this.f_97736_ + 80, (float)(this.f_97735_ + 70) - this.xMouse, (float)(this.f_97736_ + 40) - this.yMouse, EntityScalingManager.getUIScale(this.entity), this.entity);
        } else if (this.entityExperience > 0) {
            this.entityExperience = 0;
        }
    }

    private void renderLockedSlot(PoseStack poseStack, int x, int y) {
        for (Slot slot : this.menu.f_38839_) {
            OutputSlot outputSlot;
            if (!(slot instanceof OutputSlot) || (outputSlot = (OutputSlot)slot).m_6659_()) continue;
            Graphics.blit(poseStack, TEXTURE_ELEMENTS, this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, 0, 18, 18, 18);
        }
    }

    public void m_7025_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7025_(poseStack, mouseX, mouseY);
        for (Slot slot : this.menu.f_38839_) {
            MobFarmSlot mobFarmSlot;
            if (!(slot instanceof MobFarmSlot) || (mobFarmSlot = (MobFarmSlot)slot).getTooltip() == null || !this.m_6774_(slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY) || slot.m_6657_()) continue;
            this.renderSlotTooltip(poseStack, mobFarmSlot, mouseX, mouseY);
        }
        if (this.m_6774_(24, 17, 10, 13, mouseX, mouseY)) {
            ArrayList<MutableComponent> infoText = new ArrayList<MutableComponent>(List.of());
            if (((MobFarmMenu)this.m_6262_()).getMobFarmType() != null) {
                MutableComponent mutableComponent = TextComponent.getTranslatedTextRaw(TOOLTIP_PREFIX + ((MobFarmMenu)this.m_6262_()).getMobFarmType().getId(), String.valueOf(((MobFarmMenu)this.m_6262_()).getMobFarmTierLevel()));
                infoText.add(mutableComponent.m_130940_(switch (((MobFarmMenu)this.m_6262_()).getMobFarmTierLevel()) {
                    case 1 -> ChatFormatting.GREEN;
                    case 2 -> ChatFormatting.YELLOW;
                    case 3 -> ChatFormatting.RED;
                    default -> ChatFormatting.WHITE;
                }));
            }
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.tier", new Object[]{((MobFarmMenu)this.m_6262_()).getMobFarmTierLevel()}));
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.status", (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.status_" + ((MobFarmMenu)this.m_6262_()).getMobFarmStatus())));
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.progress", new Object[]{((MobFarmMenu)this.m_6262_()).getMobFarmProgress(), 6000}));
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.progression_speed", new Object[]{((MobFarmMenu)this.m_6262_()).getMobFarmProgressionSpeed(), ((MobFarmMenu)this.m_6262_()).getMobFarmProgressionSpeedBonus()}));
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.output_slots", new Object[]{((MobFarmMenu)this.m_6262_()).getMobFarmNumberOfOutputSlots()}));
            if (this.entity != null && ((MobFarmMenu)this.m_6262_()).getMobFarmStatus() != 0) {
                int capturedMobExperience;
                infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.entity_type", new Object[]{this.entity.m_6095_()}));
                if (RequiresKilledByPlayerConfig.requiresKilledByPlayer(this.entity.m_6095_())) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.killed_by_player").m_130940_(ChatFormatting.RED));
                }
                if ((capturedMobExperience = ((MobFarmMenu)this.m_6262_()).getCapturedMobExperience()) >= 3) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.experience", new Object[]{capturedMobExperience}).m_130940_(ChatFormatting.GREEN));
                } else if (capturedMobExperience > 0) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.low_experience", new Object[]{capturedMobExperience}).m_130940_(ChatFormatting.YELLOW));
                } else if (capturedMobExperience == 0) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.no_experience").m_130940_(ChatFormatting.RED));
                }
                ItemStack bonusLootDrop = MobFarmBonusConfig.getBonusDropEntry(((MobFarmMenu)this.m_6262_()).getMobFarmType(), ((MobFarmMenu)this.m_6262_()).getMobFarmTierLevel(), this.entity.m_6095_());
                if (!bonusLootDrop.m_41619_()) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.bonus_drop", new Object[]{bonusLootDrop.m_41611_()}).m_130940_(ChatFormatting.GREEN));
                } else {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.no_bonus_drop").m_130940_(ChatFormatting.GRAY));
                }
            }
            this.m_96597_(poseStack, infoText, mouseX, mouseY);
        }
    }

    private void renderSlotTooltip(PoseStack poseStack, MobFarmSlot mobFarmSlot, int mouseX, int mouseY) {
        Component component = mobFarmSlot.getTooltip();
        if (component == null) {
            return;
        }
        List wrappedText = this.f_96547_.m_92923_((FormattedText)component, 150);
        this.m_96617_(poseStack, wrappedText, mouseX, mouseY);
    }
}

