/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.inventory;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobVariantData;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardIngredientItem;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CraftingHandler {
    private CraftingHandler() {
    }

    public static void handleCraftingMenu(CraftingMenu craftingMenu, CraftingContainer craftingContainer) {
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack ingredientItemStack;
            MobCaptureData mobCaptureData;
            ItemStack itemStack = craftingContainer.m_8020_(i);
            if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof MobCaptureCardItem) || (mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack)) == null || mobCaptureData.entityType() != EntityType.f_217012_) continue;
            FrogVariant frogVariant = MobVariantData.getFrogVariant(mobCaptureData.variant());
            Item ingredientItem = null;
            if (frogVariant == FrogVariant.f_218187_) {
                ingredientItem = (Item)Registry.f_122827_.m_7745_(new ResourceLocation("easy_mob_farm", "mob_capture_card_ingredient_frog_cold"));
            } else if (frogVariant == FrogVariant.f_218186_) {
                ingredientItem = (Item)Registry.f_122827_.m_7745_(new ResourceLocation("easy_mob_farm", "mob_capture_card_ingredient_frog_warm"));
            } else if (frogVariant == FrogVariant.f_218185_) {
                ingredientItem = (Item)Registry.f_122827_.m_7745_(new ResourceLocation("easy_mob_farm", "mob_capture_card_ingredient_frog_temperate"));
            }
            if (ingredientItem == null || (ingredientItemStack = MobCaptureCardIngredientItem.saveOriginalItemStack(itemStack, new ItemStack((ItemLike)ingredientItem))).m_41619_()) continue;
            craftingContainer.m_6836_(i, ingredientItemStack);
            craftingMenu.m_6199_((Container)craftingContainer);
        }
    }

    public static void handlePlayerInventory(ServerPlayer serverPlayer) {
        NonNullList inventory = serverPlayer.m_150109_().f_35974_;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack originalItemStack;
            ItemStack itemStack = (ItemStack)inventory.get(i);
            if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof MobCaptureCardIngredientItem) || (originalItemStack = MobCaptureCardIngredientItem.restoreOriginalItemStack(itemStack, new ItemStack((ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation("easy_mob_farm", "mob_capture_card"))))).m_41619_()) continue;
            inventory.set(i, originalItemStack);
            serverPlayer.m_150109_().m_6596_();
        }
    }
}

