/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobCaptureCardResourceManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[Mob Capture Card Resource Manager] ";
    private static final Map<Integer, String> MOB_CAPTURE_CARD_MODELS = new HashMap<Integer, String>();

    private MobCaptureCardResourceManager() {
    }

    public static void loadMobCaptureCardData(ResourceManager resourceManager) {
        ResourceLocation mobCaptureCardLocation = new ResourceLocation("easy_mob_farm", "models/item/mob_capture_card/mob_capture_cards.json");
        MOB_CAPTURE_CARD_MODELS.clear();
        resourceManager.m_7536_().forEach(packResources -> {
            if (packResources.m_7211_(PackType.CLIENT_RESOURCES, mobCaptureCardLocation)) {
                MobCaptureCardResourceManager.processMobCaptureCardData(packResources, mobCaptureCardLocation);
            } else {
                log.debug("{} Skipping pack {} because it does not contain {}", (Object)LOG_PREFIX, (Object)packResources.m_8017_(), (Object)mobCaptureCardLocation);
            }
        });
    }

    public static void processMobCaptureCardData(PackResources packResources, ResourceLocation mobCaptureCardLocation) {
        try {
            InputStream inputStream = packResources.m_8031_(PackType.CLIENT_RESOURCES, mobCaptureCardLocation);
            InputStreamReader reader = new InputStreamReader(inputStream);
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonArray captureCards = jsonObject.getAsJsonArray("mob_capture_cards");
            captureCards.forEach(element -> {
                JsonObject card = element.getAsJsonObject();
                int cardId = card.get("card_id").getAsInt();
                String modelPath = card.get("model").getAsString();
                if (cardId <= 0 || modelPath == null || modelPath.isEmpty()) {
                    log.error("{} Failed to load custom capture card with id {} and model {}", (Object)LOG_PREFIX, (Object)cardId, (Object)modelPath);
                    return;
                }
                log.debug("{} Added custom mob capture card with id {} and model {}", (Object)LOG_PREFIX, (Object)cardId, (Object)modelPath);
                MOB_CAPTURE_CARD_MODELS.put(cardId, modelPath);
            });
            reader.close();
        }
        catch (Exception e) {
            log.error("{} Failed to load custom capture cards for {}", (Object)LOG_PREFIX, (Object)packResources.m_8017_(), (Object)e);
        }
    }

    public static boolean isSupportedCardId(int cardID) {
        return MOB_CAPTURE_CARD_MODELS.containsKey(cardID);
    }

    public static String getModelForCustomModelData(int cardID) {
        return MOB_CAPTURE_CARD_MODELS.getOrDefault(cardID, "easy_mob_farm:item/mob_capture_card/default");
    }

    public static ResourceLocation getResourceLocationForCardId(int cardID) {
        return new ResourceLocation(MobCaptureCardResourceManager.getModelForCustomModelData(cardID));
    }

    public static ModelResourceLocation getModelResourceLocationForCardId(int cardID) {
        String modelPath = MobCaptureCardResourceManager.getModelForCustomModelData(cardID);
        if (modelPath.contains(":item/")) {
            modelPath = modelPath.replace(":item/", ":");
        }
        return new ModelResourceLocation(modelPath, "inventory");
    }

    public static Collection<String> getCustomModelPaths() {
        return MOB_CAPTURE_CARD_MODELS.values();
    }
}

