/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.server;

import de.markusbordihn.easymobfarm.inventory.CraftingHandler;
import de.markusbordihn.easymobfarm.server.ServerEvents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ServerEventHandler {
    private static final int PLAYER_INVENTORY_TICKS = 20;
    private static int playerInventoryTicker = 0;

    private ServerEventHandler() {
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        ServerEvents.handleServerStartedEvent(event.getServer());
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        ServerEvents.handleServerStartingEvent(event.getServer());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AbstractContainerMenu abstractContainerMenu = serverPlayer.f_36096_;
            if (abstractContainerMenu instanceof CraftingMenu) {
                CraftingMenu craftingMenu = (CraftingMenu)abstractContainerMenu;
                CraftingHandler.handleCraftingMenu(craftingMenu, craftingMenu.f_39348_);
            }
            if (playerInventoryTicker++ > 20) {
                CraftingHandler.handlePlayerInventory(serverPlayer);
                playerInventoryTicker = 0;
            }
        }
    }
}

