/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block.entity;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.config.MobFarmBonusConfig;
import de.markusbordihn.easymobfarm.config.MobFarmConfig;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureDataSupport;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmContainerData;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmSlot;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmSlots;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import de.markusbordihn.easymobfarm.experience.ExperienceManager;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import de.markusbordihn.easymobfarm.item.upgrade.EnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.FilterItem;
import de.markusbordihn.easymobfarm.item.upgrade.SlotUpgradeItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.SpeedEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.filter.NoFlowersFilterItem;
import de.markusbordihn.easymobfarm.item.upgrade.filter.NoMeatFilterItem;
import de.markusbordihn.easymobfarm.loot.LootManager;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import de.markusbordihn.easymobfarm.tags.ModItemTags;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmBlockEntity
extends class_2624
implements class_1278 {
    public static final String ID = "mob_farm_entity";
    public static final int DEFAULT_FARM_PROCESSING_TIME = 6000;
    public static final int DEFAULT_PROCESSING_TICKS = 20;
    public static final int DEFAULT_RECHECK_TICKS = 200;
    public static final String TIER_LEVEL_TAG = "TierLevel";
    public static final String FARM_TYPE_TAG = "FarmType";
    public static final String OWNER_TAG = "Owner";
    public static final String CAPTURED_MOB_EXPERIENCE_TAG = "CapturedMobExperience";
    protected static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final int[] RESULT_SLOTS = MobFarmSlots.RESULT_SLOTS.stream().mapToInt(MobFarmSlot::index).toArray();
    private static final Random random = new Random();
    private final class_3913 data;
    private final int processingDelay;
    protected class_2371<class_1799> items = class_2371.method_10213((int)52, (Object)class_1799.field_8037);
    private MobFarmType mobFarmType;
    private int farmTierLevel;
    private UUID owner;
    private int numberOfOutputSlots = 6;
    private int farmProgress = 0;
    private int farmProgressionSpeed = 20;
    private int farmStatus = 0;
    private int capturedMobExperience = -1;
    private class_7225.class_7874 provider;

    public MobFarmBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        this(blockEntityType, blockPos, blockState, MobFarmBlock.getTierLevel(blockState), MobFarmBlock.getFarmType(blockState));
    }

    public MobFarmBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState, int farmTierLevel, MobFarmType mobFarmType) {
        super(blockEntityType, blockPos, blockState);
        this.data = new MobFarmContainerData(this);
        this.setFarmTierLevel(farmTierLevel);
        this.mobFarmType = mobFarmType;
        this.processingDelay = Math.min(Math.max(Math.abs(blockPos.method_10263() * 31 + blockPos.method_10260() * 17) % 20 + new Random().nextInt(5), 0), 19);
        this.method_5431();
    }

    public static void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, MobFarmBlockEntity blockEntity) {
        if (!blockEntity.hasCapturedMob() || blockEntity.farmStatus == 401) {
            if (blockEntity.farmStatus != 0) {
                blockEntity.farmStatus = 0;
            }
            return;
        }
        if (blockEntity.farmStatus == 400) {
            if (level.method_8510() % 200L == 0L && blockEntity.canProcessingResults()) {
                log.debug("Mob farm block entity at {} is no longer full and can process results again", (Object)blockEntity.method_11016());
                blockEntity.farmStatus = 0;
            } else {
                return;
            }
        }
        if (level.method_8510() % 20L != (long)blockEntity.processingDelay) {
            return;
        }
        if (blockEntity.farmProgress < 6000) {
            if (blockEntity.farmProgress % 200 == 0) {
                log.debug("Mob farm block entity at {} with farm progress {} / {}", (Object)blockPos, (Object)blockEntity.farmProgress, (Object)6000);
            }
            int farmProgressionSpeed = MobFarmBlockEntity.getEffectiveFarmProgressionSpeed(blockEntity);
            blockEntity.farmProgress = Math.min(blockEntity.farmProgress + farmProgressionSpeed, 6000);
            blockEntity.farmStatus = 200;
            return;
        }
        if (MobFarmConfig.processingRequiresOwnerToBeOnline && blockEntity.hasOwner() && level.method_18470(blockEntity.getOwner()) == null) {
            return;
        }
        if (blockEntity.canProcessingResults()) {
            blockEntity.processingResults();
        } else {
            log.warn("Mob farm block entity at {} is full and can't process results", (Object)blockEntity.method_11016());
            blockEntity.farmStatus = 400;
        }
        blockEntity.farmProgress = 0;
    }

    private static int getEffectiveFarmProgressionSpeed(MobFarmBlockEntity blockEntity) {
        return blockEntity.getFarmProgressionSpeed() + blockEntity.getFarmProgressionSpeedBonus();
    }

    public int getFarmProgressionSpeed() {
        return this.farmProgressionSpeed;
    }

    public int getFarmProgressionSpeedBonus() {
        int farmProgressionSpeedBonus = 0;
        for (EnhancementItem enhancementItem : this.getEnchantmentItems()) {
            if (!(enhancementItem instanceof SpeedEnhancementItem)) continue;
            SpeedEnhancementItem speedEnhancementItem = (SpeedEnhancementItem)enhancementItem;
            farmProgressionSpeedBonus += speedEnhancementItem.getUpgradeSpeed();
        }
        return farmProgressionSpeedBonus;
    }

    public List<EnhancementItem> getEnchantmentItems() {
        ArrayList<EnhancementItem> enchantmentItems = new ArrayList<EnhancementItem>();
        for (MobFarmSlot upgradeSlot : MobFarmSlots.ENHANCEMENT_ITEM_SLOTS) {
            class_1792 class_17922;
            class_1799 itemStack = this.method_5438(upgradeSlot.index());
            if (itemStack.method_7960() || !((class_17922 = itemStack.method_7909()) instanceof EnhancementItem)) continue;
            EnhancementItem enhancementItem = (EnhancementItem)class_17922;
            enchantmentItems.add(enhancementItem);
        }
        return enchantmentItems;
    }

    public Set<FilterItem> getFilterItems() {
        HashSet<FilterItem> filterItems = new HashSet<FilterItem>();
        for (MobFarmSlot filterSlot : MobFarmSlots.FILTER_ITEM_SLOTS) {
            class_1792 class_17922;
            class_1799 itemStack = this.method_5438(filterSlot.index());
            if (itemStack.method_7960() || !((class_17922 = itemStack.method_7909()) instanceof FilterItem)) continue;
            FilterItem filterItem = (FilterItem)class_17922;
            filterItems.add(filterItem);
        }
        return filterItems;
    }

    public Set<SlotUpgradeItem> getSlotUpgradeItems() {
        HashSet<SlotUpgradeItem> slotUpgradeItems = new HashSet<SlotUpgradeItem>();
        for (MobFarmSlot upgradeSlot : MobFarmSlots.SLOT_UPGRADE_ITEM_SLOTS) {
            class_1792 class_17922;
            class_1799 itemStack = this.method_5438(upgradeSlot.index());
            if (itemStack.method_7960() || !((class_17922 = itemStack.method_7909()) instanceof SlotUpgradeItem)) continue;
            SlotUpgradeItem slotUpgradeItem = (SlotUpgradeItem)class_17922;
            slotUpgradeItems.add(slotUpgradeItem);
        }
        return slotUpgradeItems;
    }

    public boolean canProcessingResults() {
        int startSlotIndex;
        for (int slotIndex = startSlotIndex = MobFarmSlots.RESULT_SLOTS.get(0).index(); slotIndex < startSlotIndex + this.numberOfOutputSlots; ++slotIndex) {
            if (!this.method_5438(slotIndex).method_7960() && this.method_5438(slotIndex).method_7947() >= this.method_5438(slotIndex).method_7914()) continue;
            return true;
        }
        return false;
    }

    private boolean processingLuckyDrops(MobCaptureData mobCaptureData, class_2371<class_1799> lootDrops) {
        class_2371<class_1799> luckyDrop;
        if (this.getFarmType() != MobFarmType.LUCKY_DROP_FARM) {
            return false;
        }
        int luckRoll = random.nextInt(100);
        if (luckRoll > MobFarmConfig.luckyDropFarmLuckPercentage) {
            log.debug("Bad lucky drop for {} (tier: {}) block entity at {} with captured mob {}", (Object)this.getFarmType(), (Object)this.getFarmTierLevel(), (Object)this.method_11016(), mobCaptureData.entityType());
            this.spawnEntity(mobCaptureData.entityType(), this.field_11863, this.method_11016().method_10084());
            this.method_5434(MobFarmSlot.CAPTURED_MOB.index(), 1);
            this.farmStatus = 0;
            return true;
        }
        log.debug("Lucky drop for {} (tier: {}) block entity at {} with captured mob {}", (Object)this.getFarmType(), (Object)this.getFarmTierLevel(), (Object)this.method_11016(), mobCaptureData.entityType());
        if (random.nextInt(2) == 0 && !(luckyDrop = LootManager.getLuckyLoot(mobCaptureData, this.method_11016(), this.field_11863)).isEmpty()) {
            log.debug("Adding lucky loot drop {} for {} (tier: {}) block entity at {} with captured mob {}", luckyDrop, (Object)this.getFarmType(), (Object)this.getFarmTierLevel(), (Object)this.method_11016(), mobCaptureData.entityType());
            lootDrops.addAll(luckyDrop);
        }
        return false;
    }

    public void processingResults() {
        MobCaptureData mobCaptureData = this.getMobCaptureData();
        if (mobCaptureData == null) {
            return;
        }
        this.farmStatus = 102;
        class_2371<class_1799> lootDrops = LootManager.getEntityLoot(mobCaptureData, this.getEnchantmentItems(), this.field_11863);
        if (this.processingLuckyDrops(mobCaptureData, lootDrops)) {
            return;
        }
        class_1799 bonusLootDrop = MobFarmBonusConfig.getBonusDrop(this.getFarmType(), this.getFarmTierLevel(), mobCaptureData.entityType());
        if (!bonusLootDrop.method_7960()) {
            log.debug("Adding bonus loot drop {} for {} (tier: {}) block entity at {} with captured mob {}", (Object)bonusLootDrop, (Object)this.getFarmType(), (Object)this.getFarmTierLevel(), (Object)this.method_11016(), mobCaptureData.entityType());
            lootDrops.add((Object)bonusLootDrop.method_7972());
        }
        this.handleLootDrops(lootDrops);
        this.farmStatus = 0;
    }

    private void handleLootDrops(class_2371<class_1799> lootDrops) {
        if (lootDrops == null || lootDrops.isEmpty()) {
            return;
        }
        log.debug("Processing loot drops for mob farm block entity at {} with {} loot drops", (Object)this.method_11016(), lootDrops);
        for (class_1799 lootDrop : lootDrops) {
            if (lootDrop.method_7960()) continue;
            for (FilterItem filterItem : this.getFilterItems()) {
                if (filterItem instanceof NoMeatFilterItem && lootDrop.method_31573(ModItemTags.MEAT)) {
                    lootDrop.method_7939(0);
                }
                if (!(filterItem instanceof NoFlowersFilterItem) || !lootDrop.method_31573(ModItemTags.FLOWERS)) continue;
                lootDrop.method_7939(0);
            }
            for (MobFarmSlot filterSlot : MobFarmSlots.FILTER_ITEM_SLOTS) {
                class_1799 filterItem = this.method_5438(filterSlot.index());
                if (filterItem.method_7960() || !filterItem.method_31574(lootDrop.method_7909())) continue;
                log.debug("Filter slot {} matches loot drop {}", (Object)filterSlot, (Object)lootDrop);
                lootDrop.method_7939(0);
                break;
            }
            this.storeItemInOutputSlot(lootDrop);
        }
    }

    private void storeItemInOutputSlot(class_1799 itemStack) {
        int startSlotIndex;
        for (int slotIndex = startSlotIndex = MobFarmSlots.RESULT_SLOTS.get(0).index(); slotIndex < startSlotIndex + this.numberOfOutputSlots; ++slotIndex) {
            class_1799 outputSlot = this.method_5438(slotIndex);
            if (outputSlot.method_7960()) {
                this.setItemInSlot(slotIndex, itemStack);
                break;
            }
            if (!this.canGrowOutputSlot(outputSlot, itemStack)) continue;
            this.growOutputSlot(outputSlot, itemStack);
            if (itemStack.method_7960()) break;
        }
    }

    private void setItemInSlot(int slotIndex, class_1799 itemStack) {
        this.method_5447(slotIndex, itemStack);
    }

    private boolean canGrowOutputSlot(class_1799 outputSlot, class_1799 itemStack) {
        return outputSlot.method_31574(itemStack.method_7909()) && outputSlot.method_7947() < outputSlot.method_7914();
    }

    private void growOutputSlot(class_1799 outputSlot, class_1799 itemStack) {
        int amountToGrow = Math.min(itemStack.method_7947(), outputSlot.method_7914() - outputSlot.method_7947());
        outputSlot.method_7933(amountToGrow);
        itemStack.method_7934(amountToGrow);
    }

    public MobCaptureData getMobCaptureData() {
        return MobCaptureManager.getMobCaptureData(this.getItem(MobFarmSlot.CAPTURED_MOB), this.field_11863);
    }

    public boolean hasCapturedMob() {
        return !this.getItem(MobFarmSlot.CAPTURED_MOB).method_7960();
    }

    public class_1799 takeItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = this.method_5438(index);
        this.method_5447(index, class_1799.field_8037);
        return itemStack;
    }

    public void giveMobCaptureItem(class_1657 player, class_1268 hand) {
        class_1799 capturedMob = this.getCapturedMob();
        if (capturedMob.method_7960()) {
            return;
        }
        this.givePlayerItem(MobFarmSlot.CAPTURED_MOB.index(), player.method_37908(), player, hand, player.method_24515());
    }

    public void givePlayerItem(int index, class_1937 level, class_1657 player, class_1268 hand, class_2338 blockPos) {
        class_1799 itemStack = this.takeItem(index);
        if (itemStack.method_7960() || itemStack.method_7963() && itemStack.method_7919() >= itemStack.method_7936()) {
            return;
        }
        class_1799 handItemStack = player.method_5998(hand);
        if (handItemStack.method_7960()) {
            player.method_6122(hand, itemStack);
        } else if (!player.method_31548().method_7394(itemStack) && level != null) {
            level.method_8649((class_1297)new class_1542(level, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, itemStack));
        }
        this.syncChanges();
    }

    private boolean isInvalidHandItem(class_1799 handItemStack) {
        return handItemStack.method_7960() || handItemStack.method_7963() && handItemStack.method_7919() >= handItemStack.method_7936();
    }

    public boolean takeMobCaptureItem(class_1657 player, class_1268 hand) {
        class_1799 handItemStack = player.method_5998(hand);
        if (this.isInvalidHandItem(handItemStack)) {
            return false;
        }
        if ((MobCaptureDataSupport.isSupported(handItemStack) || handItemStack.method_7909() instanceof MobCaptureCardItem) && this.getItem(MobFarmSlot.CAPTURED_MOB).method_7960()) {
            return this.takePlayerItem(MobFarmSlot.CAPTURED_MOB.index(), player, hand);
        }
        return false;
    }

    public boolean takeEnhancementItem(class_1657 player, class_1268 hand) {
        class_1799 handItemStack = player.method_5998(hand);
        if (this.isInvalidHandItem(handItemStack)) {
            return false;
        }
        class_1792 handItem = handItemStack.method_7909();
        if (handItem instanceof EnhancementItem) {
            for (MobFarmSlot upgradeSlot : MobFarmSlots.ENHANCEMENT_ITEM_SLOTS) {
                class_1799 itemStack = this.method_5438(upgradeSlot.index());
                if (!itemStack.method_7960()) continue;
                return this.takePlayerItem(upgradeSlot.index(), player, hand);
            }
        }
        return false;
    }

    public boolean takeSlotUpgradeItem(class_1657 player, class_1268 hand) {
        class_1799 handItemStack = player.method_5998(hand);
        if (this.isInvalidHandItem(handItemStack)) {
            return false;
        }
        class_1792 handItem = handItemStack.method_7909();
        if (handItem instanceof SlotUpgradeItem) {
            for (MobFarmSlot upgradeSlot : MobFarmSlots.SLOT_UPGRADE_ITEM_SLOTS) {
                class_1799 itemStack = this.method_5438(upgradeSlot.index());
                if (!itemStack.method_7960()) continue;
                return this.takePlayerItem(upgradeSlot.index(), player, hand);
            }
        }
        return false;
    }

    public boolean takeFilterItem(class_1657 player, class_1268 hand) {
        class_1799 handItemStack = player.method_5998(hand);
        if (this.isInvalidHandItem(handItemStack)) {
            return false;
        }
        class_1792 handItem = handItemStack.method_7909();
        if (handItem instanceof FilterItem) {
            for (MobFarmSlot filterSlot : MobFarmSlots.FILTER_ITEM_SLOTS) {
                class_1799 itemStack = this.method_5438(filterSlot.index());
                if (itemStack.method_31574(handItemStack.method_7909())) {
                    return false;
                }
                if (!itemStack.method_7960()) continue;
                return this.takePlayerItem(filterSlot.index(), player, hand);
            }
        }
        return false;
    }

    public boolean takePlayerItem(int index, class_1657 player, class_1268 hand) {
        class_1799 handItemStack = player.method_5998(hand);
        if (handItemStack.method_7960() || handItemStack.method_7963() && handItemStack.method_7919() >= handItemStack.method_7936()) {
            return false;
        }
        class_1799 itemStack = handItemStack.method_7972();
        itemStack.method_7939(1);
        this.method_5447(index, itemStack);
        if (!player.method_7337()) {
            handItemStack.method_7934(1);
        }
        this.syncChanges();
        return true;
    }

    public int getNumberOfOutputSlots() {
        return this.numberOfOutputSlots;
    }

    public void setNumberOfOutputSlots(int numberOfOutputSlots) {
        this.numberOfOutputSlots = numberOfOutputSlots;
    }

    public int getFarmProgress() {
        return this.farmProgress;
    }

    public void setFarmProgress(int farmProgress) {
        this.farmProgress = farmProgress;
    }

    public int getFarmStatus() {
        return this.farmStatus;
    }

    public void setFarmStatus(int farmStatus) {
        this.farmStatus = farmStatus;
    }

    public int getFarmTierLevel() {
        return this.farmTierLevel;
    }

    public void setFarmTierLevel(int farmTierLevel) {
        if (this.data.method_17390(6) == farmTierLevel) {
            return;
        }
        this.farmProgressionSpeed = 20;
        this.farmProgressionSpeed += MobFarmConfig.getFarmTierProgressionUpgradeSpeed(farmTierLevel);
        log.debug("Set mob farm tier level to {}", (Object)farmTierLevel);
        this.farmTierLevel = farmTierLevel;
    }

    public MobFarmType getFarmType() {
        return this.mobFarmType;
    }

    public class_1799 getCapturedMob() {
        return this.getItem(MobFarmSlot.CAPTURED_MOB);
    }

    public int getCapturedMobExperience() {
        return this.capturedMobExperience;
    }

    public class_1799 getItem(MobFarmSlot mobFarmSlot) {
        return (class_1799)this.items.get(mobFarmSlot.index());
    }

    public void syncChanges() {
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(class_1657 player) {
        log.debug("Set owner for mob farm block entity to {}", (Object)player);
        this.owner = player.method_5667();
        this.method_5431();
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.equals(new UUID(0L, 0L));
    }

    public class_3913 getContainerData() {
        return this.data;
    }

    public void dropInventoryContents() {
        if (this.field_11863.field_9236 || this.items.isEmpty()) {
            return;
        }
        for (class_1799 stack : this.items) {
            if (stack.method_7960()) continue;
            class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (class_1799)stack);
        }
    }

    private void spawnEntity(class_1299<?> entityType, class_1937 level, class_2338 position) {
        if (entityType == null || level == null || position == null) {
            return;
        }
        class_1297 entity = entityType.method_5883(level, class_3730.field_16467);
        if (entity != null) {
            log.debug("Spawn entity {} at position {} for mob farm block entity at {}", (Object)entity, (Object)position, (Object)this.method_11016());
            entity.method_5814((double)position.method_10263() + 0.5, (double)(position.method_10264() + 1), (double)position.method_10260() + 0.5);
            level.method_8649(entity);
        }
    }

    private void setsMobCaptureItem(class_1799 itemStack) {
        class_1937 class_19372;
        class_1309 livingEntity;
        log.debug("Sets mob capture item {} in mob farm block entity at {}", (Object)itemStack, (Object)this.method_11016());
        MobCaptureData mobCaptureData = this.getMobCaptureData();
        class_1299<?> entityType = mobCaptureData != null ? mobCaptureData.entityType() : null;
        class_1309 class_13092 = livingEntity = entityType != null ? (class_1309)entityType.method_5883(this.field_11863, class_3730.field_16467) : null;
        if (livingEntity != null && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.capturedMobExperience = ExperienceManager.getExperienceReward(livingEntity, serverLevel);
        } else {
            this.capturedMobExperience = 0;
        }
    }

    private void removedMobCaptureItem(class_1799 itemStack) {
        log.debug("Removed mob capture item {} from mob farm block entity at {}", (Object)itemStack, (Object)this.method_11016());
        this.capturedMobExperience = -1;
    }

    protected class_2561 method_17823() {
        return TextComponent.getTranslatedTextRaw("container.easy_mob_farm.mob_farm");
    }

    protected class_1703 method_5465(int windowId, class_1661 inventory) {
        return null;
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.items) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int index) {
        return (class_1799)this.items.get(index);
    }

    public class_1799 method_5434(int index, int count) {
        class_1799 itemStack = class_1262.method_5430(this.items, (int)index, (int)count);
        if (index == MobFarmSlot.CAPTURED_MOB.index() && !itemStack.method_7960()) {
            this.removedMobCaptureItem(itemStack);
            this.syncChanges();
        }
        return itemStack;
    }

    public class_1799 method_5441(int index) {
        class_1799 itemStack = class_1262.method_5428(this.items, (int)index);
        if (index == MobFarmSlot.CAPTURED_MOB.index() && !itemStack.method_7960()) {
            this.removedMobCaptureItem(itemStack);
        }
        return itemStack;
    }

    public void method_5447(int index, class_1799 itemStack) {
        this.items.set(index, (Object)itemStack);
        if (itemStack.method_7947() > this.method_5444()) {
            itemStack.method_7939(this.method_5444());
        }
        if (index == MobFarmSlot.CAPTURED_MOB.index() && !itemStack.method_7960()) {
            this.setsMobCaptureItem(itemStack.method_7972());
        }
        this.syncChanges();
    }

    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> items) {
        this.items = items;
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = super.method_16887(provider);
        class_1262.method_5426((class_2487)tag, this.items, (class_7225.class_7874)provider);
        return tag;
    }

    public class_2622 getUpdatePacket() {
        if (this.provider != null) {
            class_2487 tag = new class_2487();
            this.method_11007(tag, this.provider);
        }
        return class_2622.method_38585((class_2586)this);
    }

    public boolean method_5443(class_1657 player) {
        return player.method_5805();
    }

    public void method_5448() {
        this.items.clear();
    }

    public int[] method_5494(class_2350 direction) {
        if (direction == class_2350.field_11033 || direction == class_2350.field_11043 || direction == class_2350.field_11034 || direction == class_2350.field_11035 || direction == class_2350.field_11039) {
            return RESULT_SLOTS;
        }
        if (direction == class_2350.field_11036) {
            return new int[0];
        }
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 itemStack, class_2350 direction) {
        return direction == class_2350.field_11036;
    }

    public boolean method_5493(int slot, class_1799 itemStack, class_2350 direction) {
        if (direction == class_2350.field_11036) {
            return false;
        }
        for (int resultSlot : RESULT_SLOTS) {
            if (slot != resultSlot) continue;
            return true;
        }
        return false;
    }

    public void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.items.clear();
        class_1262.method_5429((class_2487)compoundTag, this.items, (class_7225.class_7874)provider);
        if (compoundTag.method_10545(TIER_LEVEL_TAG)) {
            this.setFarmTierLevel(compoundTag.method_10550(TIER_LEVEL_TAG));
        }
        if (compoundTag.method_10545(FARM_TYPE_TAG)) {
            this.mobFarmType = MobFarmType.valueOf(compoundTag.method_10558(FARM_TYPE_TAG));
        }
        if (compoundTag.method_10545(CAPTURED_MOB_EXPERIENCE_TAG) && compoundTag.method_10550(CAPTURED_MOB_EXPERIENCE_TAG) >= 0) {
            this.capturedMobExperience = compoundTag.method_10550(CAPTURED_MOB_EXPERIENCE_TAG);
        }
        if (compoundTag.method_10545(OWNER_TAG)) {
            this.owner = compoundTag.method_25926(OWNER_TAG);
        }
        this.provider = provider;
    }

    public void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        class_1262.method_5426((class_2487)compoundTag, this.items, (class_7225.class_7874)provider);
        compoundTag.method_10569(TIER_LEVEL_TAG, this.farmTierLevel);
        compoundTag.method_10582(FARM_TYPE_TAG, this.mobFarmType.name());
        if (this.capturedMobExperience >= 0) {
            compoundTag.method_10569(CAPTURED_MOB_EXPERIENCE_TAG, this.capturedMobExperience);
        }
        if (this.owner != null) {
            compoundTag.method_25927(OWNER_TAG, this.owner);
        }
    }
}

