/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.screen;

import de.markusbordihn.easymobfarm.client.renderer.manager.EntityScalingManager;
import de.markusbordihn.easymobfarm.client.renderer.manager.RendererManager;
import de.markusbordihn.easymobfarm.client.screen.ContainerScreen;
import de.markusbordihn.easymobfarm.client.screen.ScreenHelper;
import de.markusbordihn.easymobfarm.client.screen.components.Graphics;
import de.markusbordihn.easymobfarm.config.MobFarmBonusConfig;
import de.markusbordihn.easymobfarm.config.RequiresKilledByPlayerConfig;
import de.markusbordihn.easymobfarm.menu.MobFarmMenu;
import de.markusbordihn.easymobfarm.menu.MobFarmSlot;
import de.markusbordihn.easymobfarm.menu.slots.OutputSlot;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class MobFarmScreen<T extends MobFarmMenu>
extends ContainerScreen<T> {
    private static final class_2960 TEXTURE_UI = class_2960.method_60655((String)"easy_mob_farm", (String)"textures/gui/mob_farm.png");
    private static final class_2960 TEXTURE_UI_IDLE = class_2960.method_60655((String)"easy_mob_farm", (String)"textures/gui/mob_farm_idle.png");
    private static final class_2960 TEXTURE_ELEMENTS = class_2960.method_60655((String)"easy_mob_farm", (String)"textures/gui/mob_farm_elements.png");
    private static final String TOOLTIP_PREFIX = "tooltip.easy_mob_farm.farm.";
    protected float xMouse;
    protected float yMouse;
    protected class_1297 entity;
    protected int entityExperience;

    public MobFarmScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    @Override
    protected void renderDefaultScreenBg(class_332 guiGraphics, int leftPos, int topPos) {
        Graphics.blit(guiGraphics, this.menu.getMobFarmStatus() == 0 ? TEXTURE_UI_IDLE : TEXTURE_UI, leftPos, topPos, 0, 0, 256, 243);
    }

    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        this.xMouse = x;
        this.yMouse = y;
        this.method_25420(guiGraphics, x, y, partialTicks);
        super.method_25394(guiGraphics, x, y, partialTicks);
        this.renderLockedSlot(guiGraphics, x, y);
        this.renderEntityType(guiGraphics, x, y);
        this.renderMobFarmProgress(guiGraphics, x, y);
        this.method_2380(guiGraphics, x, y);
    }

    protected void method_2388(class_332 guiGraphics, int x, int y) {
    }

    private void renderMobFarmProgress(class_332 guiGraphics, int x, int y) {
        int mobFarmProgress = ((MobFarmMenu)this.method_17577()).getMobFarmProgress();
        int currentWidth = mobFarmProgress * 32 / 6000;
        Graphics.blit(guiGraphics, TEXTURE_ELEMENTS, this.field_2776 + 113, this.field_2800 + 78, 0, 36, currentWidth, 16);
    }

    private void renderEntityType(class_332 guiGraphics, int x, int y) {
        class_2338 blockPos = ((MobFarmMenu)this.method_17577()).getMobFarmBlockPos();
        if (blockPos == null || blockPos.equals((Object)class_2338.field_10980)) {
            return;
        }
        int mobFarmStatus = ((MobFarmMenu)this.method_17577()).getMobFarmStatus();
        if (mobFarmStatus == 0) {
            return;
        }
        this.entity = RendererManager.getEntity(blockPos);
        if (this.entity != null) {
            ScreenHelper.renderEntity(guiGraphics, this.field_2776 + 72, this.field_2800 + 80, (float)(this.field_2776 + 70) - this.xMouse, (float)(this.field_2800 + 40) - this.yMouse, EntityScalingManager.getUIScale(this.entity), this.entity);
        } else if (this.entityExperience > 0) {
            this.entityExperience = 0;
        }
    }

    private void renderLockedSlot(class_332 guiGraphics, int x, int y) {
        for (class_1735 slot : this.menu.field_7761) {
            OutputSlot outputSlot;
            if (!(slot instanceof OutputSlot) || (outputSlot = (OutputSlot)slot).method_7682()) continue;
            Graphics.blit(guiGraphics, TEXTURE_ELEMENTS, this.field_2776 + slot.field_7873 - 1, this.field_2800 + slot.field_7872 - 1, 0, 18, 18, 18);
        }
    }

    public void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        for (class_1735 slot : this.menu.field_7761) {
            MobFarmSlot mobFarmSlot;
            if (!(slot instanceof MobFarmSlot) || (mobFarmSlot = (MobFarmSlot)slot).getTooltip() == null || !this.method_2378(slot.field_7873, slot.field_7872, 16, 16, mouseX, mouseY) || slot.method_7681()) continue;
            this.renderSlotTooltip(guiGraphics, mobFarmSlot, mouseX, mouseY);
        }
        if (this.method_2378(24, 17, 10, 13, mouseX, mouseY)) {
            ArrayList<class_5250> infoText = new ArrayList<class_5250>(List.of());
            if (((MobFarmMenu)this.method_17577()).getMobFarmType() != null) {
                class_5250 class_52502 = TextComponent.getTranslatedTextRaw(TOOLTIP_PREFIX + ((MobFarmMenu)this.method_17577()).getMobFarmType().getId(), String.valueOf(((MobFarmMenu)this.method_17577()).getMobFarmTierLevel()));
                infoText.add(class_52502.method_27692(switch (((MobFarmMenu)this.method_17577()).getMobFarmTierLevel()) {
                    case 1 -> class_124.field_1060;
                    case 2 -> class_124.field_1054;
                    case 3 -> class_124.field_1061;
                    default -> class_124.field_1068;
                }));
            }
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.tier", new Object[]{((MobFarmMenu)this.method_17577()).getMobFarmTierLevel()}));
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.status", (class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.status_" + ((MobFarmMenu)this.method_17577()).getMobFarmStatus())));
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.progress", new Object[]{((MobFarmMenu)this.method_17577()).getMobFarmProgress(), 6000}));
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.progression_speed", new Object[]{((MobFarmMenu)this.method_17577()).getMobFarmProgressionSpeed(), ((MobFarmMenu)this.method_17577()).getMobFarmProgressionSpeedBonus()}));
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.output_slots", new Object[]{((MobFarmMenu)this.method_17577()).getMobFarmNumberOfOutputSlots()}));
            if (this.entity != null && ((MobFarmMenu)this.method_17577()).getMobFarmStatus() != 0) {
                int capturedMobExperience;
                infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.entity_type", new Object[]{this.entity.method_5864().toString()}));
                if (RequiresKilledByPlayerConfig.requiresKilledByPlayer(this.entity.method_5864())) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.killed_by_player").method_27692(class_124.field_1061));
                }
                if ((capturedMobExperience = ((MobFarmMenu)this.method_17577()).getCapturedMobExperience()) >= 3) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.experience", new Object[]{capturedMobExperience}).method_27692(class_124.field_1060));
                } else if (capturedMobExperience > 0) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.low_experience", new Object[]{capturedMobExperience}).method_27692(class_124.field_1054));
                } else if (capturedMobExperience == 0) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.no_experience").method_27692(class_124.field_1061));
                }
                class_1799 bonusLootDrop = MobFarmBonusConfig.getBonusDropEntry(((MobFarmMenu)this.method_17577()).getMobFarmType(), ((MobFarmMenu)this.method_17577()).getMobFarmTierLevel(), this.entity.method_5864());
                if (!bonusLootDrop.method_7960()) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.bonus_drop", new Object[]{bonusLootDrop.method_7954()}).method_27692(class_124.field_1060));
                } else {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.no_bonus_drop").method_27692(class_124.field_1080));
                }
            }
            guiGraphics.method_51434(this.field_22793, infoText, mouseX, mouseY);
        }
    }

    private void renderSlotTooltip(class_332 guiGraphics, MobFarmSlot mobFarmSlot, int mouseX, int mouseY) {
        class_2561 component = mobFarmSlot.getTooltip();
        if (component == null) {
            return;
        }
        List wrappedText = this.field_22793.method_1728((class_5348)component, 150);
        guiGraphics.method_51447(this.field_22793, wrappedText, mouseX, mouseY);
    }
}

