/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item.mobcapturecard;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.capture.MobCaptureManagerClient;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobColor;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class MobCaptureCardItem
extends class_1792 {
    public static final String ID = "mob_capture_card";
    public static final class_2960 RESOURCE_LOCATION = class_2960.method_60655((String)"easy_mob_farm", (String)"mob_capture_card");
    public static final String TOOLTIP_PREFIX = "tooltip.easy_mob_farm.mob_capture_card.";
    private class_1937 level;

    public MobCaptureCardItem() {
        this(new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"easy_mob_farm", (String)ID))));
    }

    public MobCaptureCardItem(class_1792.class_1793 properties) {
        super(properties.method_24359());
    }

    public static MobCaptureCardItem getMobCaptureCardItem() {
        Object t;
        Optional holder = class_7923.field_41178.method_17966(RESOURCE_LOCATION);
        if (holder.isPresent() && (t = holder.get()) instanceof MobCaptureCardItem) {
            MobCaptureCardItem mobCaptureCardItem = (MobCaptureCardItem)((Object)t);
            return mobCaptureCardItem;
        }
        return null;
    }

    private static String getVariantName(String variant) {
        if (variant == null || variant.isEmpty()) {
            return "";
        }
        return Arrays.stream(variant.split("_")).map(word -> word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" "));
    }

    private static class_2561 getTranslatedEntityName(MobCaptureData mobCaptureData) {
        if (mobCaptureData == null || mobCaptureData.name() == null) {
            return TextComponent.getText("Unknown");
        }
        return TextComponent.getTranslatedTextRaw(mobCaptureData.name());
    }

    public static class_1814 getRarity(class_1799 itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack, null);
        return mobCaptureData != null ? mobCaptureData.rarity() : class_1814.field_8906;
    }

    public static MobColor getEntityColor(class_1799 itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack, null);
        return mobCaptureData != null ? mobCaptureData.color() : MobColor.NONE;
    }

    public static String getEntityType(class_1799 itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack, null);
        return mobCaptureData != null ? mobCaptureData.type() : "";
    }

    public static String getEntityVariant(class_1799 itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack, null);
        return mobCaptureData != null ? mobCaptureData.variant() : "";
    }

    public class_1269 method_7884(class_1838 context) {
        this.level = context.method_8045();
        return super.method_7884(context);
    }

    public void method_54465(class_1799 itemStack, class_1937 level, class_1657 player) {
        this.level = level;
        super.method_54465(itemStack, level, player);
    }

    public void method_33261(class_1542 itemEntity) {
        this.level = itemEntity.method_37908();
        super.method_33261(itemEntity);
    }

    public void method_7888(class_1799 itemStack, class_1937 level, class_1297 entity, int slot, boolean selected) {
        if (entity instanceof class_1657 && this.level == null) {
            this.level = level;
        }
        super.method_7888(itemStack, level, entity, slot, selected);
    }

    public boolean method_7885(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player) {
        this.level = level;
        return false;
    }

    public class_2561 method_7864(class_1799 itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack, this.level);
        if (mobCaptureData == null) {
            return super.method_7864(itemStack);
        }
        Object key = "tooltip.easy_mob_farm.mob_capture_card.card_name";
        Object[] args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData)};
        if (mobCaptureData.hasVariant() && !mobCaptureData.name().equalsIgnoreCase(mobCaptureData.variant())) {
            if (mobCaptureData.hasColor()) {
                key = (String)key + "_variant_color";
                args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData), MobCaptureCardItem.getVariantName(mobCaptureData.variant()), mobCaptureData.color().getName()};
            } else {
                key = (String)key + "_variant";
                args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData), MobCaptureCardItem.getVariantName(mobCaptureData.variant())};
            }
        } else if (mobCaptureData.hasColor()) {
            key = (String)key + "_color";
            args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData), mobCaptureData.color().getName()};
        }
        return TextComponent.getTranslatedTextRaw((String)key, args).method_27693(" ").method_10852((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card").method_27692(class_124.field_1080));
    }

    public boolean method_7886(class_1799 itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack, null);
        return mobCaptureData != null && mobCaptureData.isFoil();
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 flag) {
        MobCaptureData mobCaptureData = MobCaptureManagerClient.getMobCaptureData(itemStack);
        if (mobCaptureData == null) {
            tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.empty"));
            return;
        }
        tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.name", MobCaptureCardItem.getTranslatedEntityName(mobCaptureData)));
        if (flag.method_8035()) {
            tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.description_id", mobCaptureData.name()));
            tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.type", mobCaptureData.type()));
        }
        if (mobCaptureData.hasVariant()) {
            tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.variant", mobCaptureData.variant()));
        }
        if (mobCaptureData.hasColor()) {
            tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.color", mobCaptureData.color().getName()));
        }
        class_124 rarityColor = switch (mobCaptureData.rarity()) {
            case class_1814.field_8907 -> class_124.field_1060;
            case class_1814.field_8903 -> class_124.field_1078;
            case class_1814.field_8904 -> class_124.field_1064;
            default -> class_124.field_1080;
        };
        tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.rarity", mobCaptureData.rarity().name()).method_27692(rarityColor));
        tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.id", String.valueOf(mobCaptureData.getCardId())));
    }
}

