/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.mobfarm;

import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum MobFarmTierLevel implements StringRepresentable
{
    TIER_0(0),
    TIER_1(1),
    TIER_2(2),
    TIER_3(3);

    public static final StringRepresentable.EnumCodec<MobFarmTierLevel> CODEC;
    private static final IntFunction<MobFarmTierLevel> BY_ID;
    public static final StreamCodec<ByteBuf, MobFarmTierLevel> STREAM_CODEC;
    private final int tierLevel;
    private final String name;

    private MobFarmTierLevel(int tierLevel) {
        this.tierLevel = tierLevel;
        this.name = this.name().toLowerCase(Locale.ROOT);
    }

    public static MobFarmTierLevel getTierLevel(int tierLevel) {
        for (MobFarmTierLevel mobFarmTierLevel : MobFarmTierLevel.values()) {
            if (mobFarmTierLevel.tierLevel != tierLevel) continue;
            return mobFarmTierLevel;
        }
        return TIER_0;
    }

    public int getTierLevel() {
        return this.tierLevel;
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(MobFarmTierLevel::values);
        BY_ID = ByIdMap.continuous(MobFarmTierLevel::getTierLevel, (Object[])MobFarmTierLevel.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, MobFarmTierLevel::getTierLevel);
    }
}

