/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.debug;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public final class DebugManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[Debug Manager]";
    private static boolean isDevelopmentEnvironment = false;

    private DebugManager() {
    }

    public static void setLogLevel(Logger logger, Level logLevel) {
        LoggerConfig loggerConfig;
        if (logLevel == null || logLevel == logger.getLevel()) {
            return;
        }
        String loggerName = logger.getName();
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        LoggerConfig specificConfig = loggerConfig = config.getLoggerConfig(loggerName);
        if (!loggerConfig.getName().equals(loggerName)) {
            log.info("{} Add new logger config for {} with level {} ...", (Object)LOG_PREFIX, (Object)loggerName, (Object)logLevel);
            specificConfig = new LoggerConfig(loggerName, logLevel, true);
            specificConfig.setParent(loggerConfig);
            config.addLogger(loggerName, specificConfig);
        } else {
            log.info("{} Changing log level for {} from {} to {}", (Object)LOG_PREFIX, (Object)loggerName, (Object)logger.getLevel(), (Object)logLevel);
        }
        specificConfig.setLevel(logLevel);
        context.updateLoggers();
    }

    public static void enableDebugLevel(boolean enable) {
        DebugManager.enableDebugLevel("Easy Mob Farm", enable);
    }

    public static void enableDebugLevel(String loggerName, boolean enable) {
        Logger logger = LogManager.getLogger((String)loggerName);
        if (enable) {
            DebugManager.setLogLevel(logger, Level.DEBUG);
        } else {
            DebugManager.setLogLevel(logger, Level.INFO);
        }
    }

    public static Level getLogLevel(String loggerName) {
        Logger logger = LogManager.getLogger((String)loggerName);
        return logger.getLevel();
    }

    public static boolean isDebugLevel(String loggerName) {
        Level level = DebugManager.getLogLevel(loggerName);
        return level == Level.DEBUG || level == Level.TRACE || level == Level.ALL;
    }

    public static void checkForDebugLogging(String loggerName) {
        if (DebugManager.isDebugLevel(loggerName)) {
            Logger logger = LogManager.getLogger((String)loggerName);
            String logLevelName = logger.getLevel().name();
            logger.warn("{} Detected debug log level for {} with {}!", (Object)LOG_PREFIX, (Object)loggerName, (Object)logLevelName);
            if (DebugManager.isDevelopmentEnvironment()) {
                logger.info("{} Detected DEV environment, will not change log level for {}!", (Object)LOG_PREFIX, (Object)loggerName);
            } else {
                logger.warn("{} Adjusting log level for {} from {} to {}, for performance reasons!", (Object)LOG_PREFIX, (Object)loggerName, (Object)logLevelName, (Object)Level.INFO);
                DebugManager.enableDebugLevel(loggerName, false);
            }
        }
    }

    public static boolean isDevelopmentEnvironment() {
        return isDevelopmentEnvironment;
    }

    public static void setDevelopmentEnvironment(boolean isDevelopmentEnvironment) {
        DebugManager.isDevelopmentEnvironment = isDevelopmentEnvironment;
    }

    public static boolean isDebugMode() {
        return DebugManager.isDevelopmentEnvironment() || DebugManager.isDebugLevel("Easy Mob Farm");
    }
}

