/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.markusbordihn.easymobfarm.compat.CompatConstants;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Rarity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobCaptureCardResourceManager
extends SimpleJsonResourceReloadListener {
    public static final ResourceLocation RESOURCE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"mob_capture_card_resource_loader");
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String LOG_PREFIX = "[Mob Capture Card Resource Manager]";
    private static final String SEARCH_PATH = "easy_mob_farm/mob_capture_card";
    private static final String MODEL_TAG = "model";
    private static final String RARITY_TAG = "rarity";
    private static final String REQUIRES_ANIMATION_TICK_TAG = "requires_animation_tick";
    private static final String REQUIRES_KILLED_BY_PLAYER_TAG = "requires_killed_by_player";
    private static final String SCALE_TAG = "scale";
    private static final String COLORS_TAG = "colors";
    private static final String VARIANTS_TAG = "variants";
    private static final ResourceLocation FROG_RESOURCE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"frog");

    public MobCaptureCardResourceManager() {
        super(GSON, SEARCH_PATH);
    }

    private static void addAdditionalVariants(ResourceLocation entity, Map<String, MobCaptureCardDefinition.Variant> variants) {
        if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED && FROG_RESOURCE_LOCATION.equals((Object)entity)) {
            MobCaptureCardResourceManager.addAdditionalFrogVariants(variants);
        }
    }

    private static void addAdditionalFrogVariants(Map<String, MobCaptureCardDefinition.Variant> variants) {
        for (DyeColor color : DyeColor.values()) {
            String variantName = color.getName();
            ResourceLocation model = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("item/easy_mob_farm/mob_capture_card/frog_" + variantName));
            variants.put(variantName, new MobCaptureCardDefinition.Variant(model, new HashMap<String, MobCaptureCardDefinition.Color>()));
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        log.info("{} Loading definitions ... from {}", (Object)LOG_PREFIX, (Object)SEARCH_PATH);
        MobCaptureCardDefinitionManager.clear();
        objectMap.forEach((location, element) -> {
            try {
                JsonObject json = GsonHelper.convertToJsonObject((JsonElement)element, (String)"mob_capture_card");
                log.debug("{} Parsing definition: {}", (Object)LOG_PREFIX, location);
                ResourceLocation entity = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"entity"));
                ResourceLocation model = json.has(MODEL_TAG) ? ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)MODEL_TAG)) : null;
                Rarity rarity = Rarity.valueOf((String)GsonHelper.getAsString((JsonObject)json, (String)RARITY_TAG, (String)"common").toUpperCase(Locale.ROOT));
                float scale = GsonHelper.getAsFloat((JsonObject)json, (String)SCALE_TAG, (float)1.0f);
                boolean requiresKilledByPlayer = GsonHelper.getAsBoolean((JsonObject)json, (String)REQUIRES_KILLED_BY_PLAYER_TAG, (boolean)false);
                boolean requiresAnimationTick = GsonHelper.getAsBoolean((JsonObject)json, (String)REQUIRES_ANIMATION_TICK_TAG, (boolean)false);
                Map<String, MobCaptureCardDefinition.Color> colors = this.parseColors(json);
                Map<String, MobCaptureCardDefinition.Variant> variants = this.parseVariants(json);
                MobCaptureCardResourceManager.addAdditionalVariants(entity, variants);
                MobCaptureCardDefinition definition = new MobCaptureCardDefinition(entity, model, rarity, scale, requiresKilledByPlayer, requiresAnimationTick, variants, colors);
                MobCaptureCardDefinitionManager.addDefinition(entity, definition);
            }
            catch (Exception e) {
                log.error("{} Failed to parse mob_capture_card definition: {} \u2192 {}", (Object)LOG_PREFIX, location, (Object)e.getMessage());
            }
        });
    }

    private Map<String, MobCaptureCardDefinition.Color> parseColors(JsonObject json) {
        HashMap<String, MobCaptureCardDefinition.Color> colors = new HashMap<String, MobCaptureCardDefinition.Color>();
        if (!json.has(COLORS_TAG)) {
            return colors;
        }
        JsonObject colorsJson = GsonHelper.getAsJsonObject((JsonObject)json, (String)COLORS_TAG);
        colorsJson.entrySet().forEach(entry -> {
            String color = (String)entry.getKey();
            ResourceLocation colorModel = json.has(MODEL_TAG) ? ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)((JsonElement)entry.getValue()).getAsJsonObject(), (String)MODEL_TAG)) : null;
            colors.put(color, new MobCaptureCardDefinition.Color(colorModel));
        });
        return colors;
    }

    private Map<String, MobCaptureCardDefinition.Variant> parseVariants(JsonObject json) {
        HashMap<String, MobCaptureCardDefinition.Variant> variants = new HashMap<String, MobCaptureCardDefinition.Variant>();
        if (!json.has(VARIANTS_TAG)) {
            return variants;
        }
        JsonObject variantsJson = GsonHelper.getAsJsonObject((JsonObject)json, (String)VARIANTS_TAG);
        variantsJson.entrySet().forEach(entry -> {
            String variant = (String)entry.getKey();
            JsonObject variantObj = ((JsonElement)entry.getValue()).getAsJsonObject();
            ResourceLocation variantModel = json.has(MODEL_TAG) ? ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)variantObj, (String)MODEL_TAG, null)) : null;
            HashMap<String, MobCaptureCardDefinition.Color> variantColors = new HashMap<String, MobCaptureCardDefinition.Color>();
            if (variantObj.has(COLORS_TAG)) {
                JsonObject variantColorsJson = GsonHelper.getAsJsonObject((JsonObject)variantObj, (String)COLORS_TAG);
                variantColorsJson.entrySet().forEach(colorEntry -> {
                    String color = (String)colorEntry.getKey();
                    ResourceLocation colorModel = json.has(MODEL_TAG) ? ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)((JsonElement)colorEntry.getValue()).getAsJsonObject(), (String)MODEL_TAG)) : null;
                    variantColors.put(color, new MobCaptureCardDefinition.Color(colorModel));
                });
            }
            variants.put(variant, new MobCaptureCardDefinition.Variant(variantModel, variantColors));
        });
        return variants;
    }
}

