/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.client.renderer.manager.EntityScalingManager;
import de.markusbordihn.easymobfarm.client.renderer.manager.RendererManager;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Phantom;

public class MobFarmBlockEntityRenderer<T extends MobFarmBlockEntity>
implements BlockEntityRenderer<T> {
    public MobFarmBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        FlyingAnimal flyingAnimal;
        if (!((MobFarmBlockEntity)((Object)blockEntity)).hasCapturedMob()) {
            RendererManager.removeEntity(blockEntity);
            return;
        }
        Entity entity = RendererManager.getOrCreateEntity(blockEntity);
        if (entity == null) {
            return;
        }
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer entityRenderer = entityRenderDispatcher.getRenderer(entity);
        LivingEntityRenderState livingEntityRenderState = (LivingEntityRenderState)entityRenderer.createRenderState(entity, 0.0f);
        entity.tickCount = (int)blockEntity.getLevel().getGameTime();
        MobFarmType mobFarmType = ((MobFarmBlockEntity)((Object)blockEntity)).getFarmType();
        poseStack.pushPose();
        if (mobFarmType != null) {
            if (mobFarmType == MobFarmType.LUCKY_DROP_FARM) {
                poseStack.translate(0.5, 0.19, 0.5);
            } else {
                poseStack.translate(0.5, 0.08, 0.5);
            }
        } else {
            poseStack.translate(0.5, 0.08, 0.5);
        }
        float entityScaling = EntityScalingManager.getEntityScale(entity);
        if (mobFarmType != null && mobFarmType == MobFarmType.LUCKY_DROP_FARM) {
            entityScaling *= 0.75f;
        }
        poseStack.scale(entityScaling, entityScaling, entityScaling);
        float rotationDegrees = switch ((Direction)blockEntity.getBlockState().getValue(MobFarmBlock.FACING)) {
            case Direction.NORTH -> 180.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> -90.0f;
            case Direction.EAST -> 90.0f;
            default -> 0.0f;
        };
        poseStack.mulPose(Axis.YP.rotationDegrees(rotationDegrees));
        if (entity instanceof AbstractSchoolingFish) {
            poseStack.translate(-0.1, 0.5, 0.1);
            poseStack.mulPose(Axis.XP.rotationDegrees(2.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        } else if (entity instanceof Bee) {
            poseStack.translate(0.0, 0.5, 0.0);
        } else if (entity instanceof Squid) {
            poseStack.translate(0.0, 1.3, 0.0);
        } else if (entity instanceof Phantom) {
            poseStack.translate(0.0, 0.5, 0.0);
        } else if (entity instanceof FlyingMob || entity instanceof FlyingAnimal && (flyingAnimal = (FlyingAnimal)entity).isFlying() || entity instanceof Guardian) {
            poseStack.translate(0.0, 0.3 / (double)entityScaling, 0.0);
        }
        entityRenderer.render((EntityRenderState)livingEntityRenderState, poseStack, buffer, combinedLight);
        poseStack.popPose();
    }
}

