/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.renderer.manager;

import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Sheep;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RendererManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Map<BlockPos, Entity> entityMap = new HashMap<BlockPos, Entity>();

    private RendererManager() {
    }

    public static Entity getOrCreateEntity(MobFarmBlockEntity mobFarmBlockEntity) {
        if (mobFarmBlockEntity == null) {
            return null;
        }
        BlockPos blockPos = mobFarmBlockEntity.getBlockPos();
        if (!mobFarmBlockEntity.hasCapturedMob()) {
            entityMap.remove(blockPos);
            return null;
        }
        if (entityMap.containsKey(blockPos)) {
            return entityMap.get(blockPos);
        }
        Entity entity = RendererManager.createEntity(mobFarmBlockEntity);
        if (entity == null) {
            return null;
        }
        return entityMap.put(blockPos, entity);
    }

    public static Entity getEntity(BlockPos blockPos) {
        return entityMap.get(blockPos);
    }

    public static void removeEntity(MobFarmBlockEntity mobFarmBlockEntity) {
        RendererManager.removeEntity(mobFarmBlockEntity.getBlockPos());
    }

    public static void removeEntity(BlockPos blockPos) {
        entityMap.remove(blockPos);
    }

    private static Entity createEntity(MobFarmBlockEntity mobFarmBlockEntity) {
        if (mobFarmBlockEntity == null || mobFarmBlockEntity.getLevel() == null) {
            log.error("Unable to create entity for Mob Farm Block Entity {}", (Object)mobFarmBlockEntity);
            return null;
        }
        MobCaptureData mobCaptureData = mobFarmBlockEntity.getMobCaptureData();
        if (mobCaptureData == null) {
            log.error("Unable to get Mob Capture data from Mob Farm Block Entity {}", (Object)mobFarmBlockEntity);
            return null;
        }
        EntityType<?> entityType = mobCaptureData.entityType();
        if (entityType == null) {
            log.error("Unable to get entity type from Mob Capture data {}", (Object)mobCaptureData);
            return null;
        }
        Entity entity = entityType.create(mobFarmBlockEntity.getLevel(), EntitySpawnReason.EVENT);
        if (entity == null) {
            log.error("Unable to create entity for entity type {}", entityType);
            return null;
        }
        entity.setYHeadRot(mobFarmBlockEntity.getLevel().random.nextFloat() * 60.0f);
        entity.setYBodyRot(mobFarmBlockEntity.getLevel().random.nextFloat() * 10.0f);
        entity.xRotO = entity.getXRot();
        entity.yRotO = entity.getYRot();
        entity.tick();
        entity.load(mobCaptureData.data());
        if (entity instanceof AbstractFish) {
            AbstractFish fishEntity = (AbstractFish)entity;
            fishEntity.setNoGravity(true);
            fishEntity.setSwimming(true);
        }
        if (entity instanceof Sheep) {
            Sheep sheepEntity = (Sheep)entity;
            sheepEntity.setSheared(false);
            if (mobCaptureData.hasColor()) {
                sheepEntity.setColor(mobCaptureData.color().getDyeColor());
            }
        }
        if (entity instanceof PathfinderMob) {
            PathfinderMob newPathfinderMob = (PathfinderMob)entity;
            newPathfinderMob.setNoAi(true);
            newPathfinderMob.setSilent(true);
            newPathfinderMob.noPhysics = true;
        }
        entity.noPhysics = true;
        entity.setPos((double)mobFarmBlockEntity.getBlockPos().getX() + 0.5, (double)mobFarmBlockEntity.getBlockPos().getY() + 0.05, (double)mobFarmBlockEntity.getBlockPos().getZ() + 0.5);
        return entity;
    }
}

