/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.mobfarm;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public enum MobFarmType implements StringRepresentable
{
    UNKNOWN,
    ANIMAL_PLAINS_FARM,
    BEE_HIVE_FARM,
    CREATIVE_MOB_FARM,
    DESERT_FARM,
    IRON_GOLEM_FARM,
    LUCKY_DROP_FARM,
    JUNGLE_FARM,
    MONSTER_PLAINS_CAVE_FARM,
    NETHER_FORTRESS_FARM,
    OCEAN_FARM,
    SWAMP_FARM;

    public static final Codec<MobFarmType> CODEC;
    private static final MobFarmType[] VALUES;
    public static final StreamCodec<ByteBuf, MobFarmType> STREAM_CODEC;
    private static final Map<String, MobFarmType> BY_NAME;
    private final String name = this.name().toLowerCase(Locale.ROOT);

    public String getId() {
        return this.name;
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = Codec.STRING.xmap(MobFarmType::valueOf, Enum::name);
        VALUES = MobFarmType.values();
        STREAM_CODEC = ByteBufCodecs.idMapper(index -> VALUES[index], Enum::ordinal);
        BY_NAME = Arrays.stream(VALUES).collect(Collectors.toMap(MobFarmType::getId, Function.identity()));
    }
}

