/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.inventory;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardIngredientItem;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CraftingHandler {
    private CraftingHandler() {
    }

    public static void handleCraftingMenu(CraftingMenu craftingMenu, CraftingContainer craftingContainer) {
        for (int i = 0; i < craftingContainer.getContainerSize(); ++i) {
            ItemStack ingredientItemStack;
            MobCaptureData mobCaptureData;
            ItemStack itemStack = craftingContainer.getItem(i);
            if (itemStack.isEmpty() || !(itemStack.getItem() instanceof MobCaptureCardItem) || (mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack)) == null || mobCaptureData.entityType() != EntityType.FROG) continue;
            String frogVariant = mobCaptureData.variant();
            Optional ingredientItem = null;
            switch (frogVariant) {
                case "cold": {
                    ingredientItem = BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"mob_capture_card_ingredient_frog_cold"));
                    break;
                }
                case "temperate": {
                    ingredientItem = BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"mob_capture_card_ingredient_frog_temperate"));
                    break;
                }
                case "warm": {
                    ingredientItem = BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"mob_capture_card_ingredient_frog_warm"));
                }
            }
            if (ingredientItem == null || !ingredientItem.isPresent() || (ingredientItemStack = MobCaptureCardIngredientItem.saveOriginalItemStack(itemStack, new ItemStack((ItemLike)((Holder.Reference)ingredientItem.get()).value()))).isEmpty()) continue;
            craftingContainer.setItem(i, ingredientItemStack);
            craftingMenu.slotsChanged((Container)craftingContainer);
        }
    }

    public static void handlePlayerInventory(ServerPlayer serverPlayer) {
        NonNullList inventory = serverPlayer.getInventory().items;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack originalItemStack;
            Optional orginalItem;
            ItemStack itemStack = (ItemStack)inventory.get(i);
            if (itemStack.isEmpty() || !(itemStack.getItem() instanceof MobCaptureCardIngredientItem) || !(orginalItem = BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"mob_capture_card"))).isPresent() || (originalItemStack = MobCaptureCardIngredientItem.restoreOriginalItemStack(itemStack, new ItemStack((ItemLike)((Holder.Reference)orginalItem.get()).value()))).isEmpty()) continue;
            inventory.set(i, originalItemStack);
            serverPlayer.getInventory().setChanged();
        }
    }
}

