/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import de.markusbordihn.easymobfarm.config.MobFarmConfig;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmData;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmTierLevel;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class MobFarmBlockItem
extends BlockItem {
    public static final String ID = "mob_farm_block_item";
    private final String farmName;
    private final MobFarmType mobFarmType;

    public MobFarmBlockItem(MobFarmType mobFarmType, Block block) {
        this(mobFarmType, block, new Item.Properties().useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)mobFarmType.getId()))));
    }

    public MobFarmBlockItem(MobFarmType mobFarmType, Block block, Item.Properties properties) {
        super(block, properties);
        this.mobFarmType = mobFarmType;
        this.farmName = mobFarmType.getId();
    }

    public static void updateCustomModelData(ItemStack itemStack) {
        int tierLevel = MobFarmBlockItem.getTierLevel(itemStack).getTierLevel();
        if (tierLevel > 0) {
            itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(tierLevel));
        }
    }

    public static MobFarmTierLevel getTierLevel(ItemStack itemStack) {
        MobFarmData mobFarmData = (MobFarmData)itemStack.getOrDefault(de.markusbordihn.easymobfarm.component.DataComponents.MOB_FARM_DATA, (Object)MobFarmData.EMPTY);
        return mobFarmData.tierLevel();
    }

    public String getFarmName() {
        return this.farmName;
    }

    public MobFarmType getMobFarmType() {
        return this.mobFarmType;
    }

    public Component getName(ItemStack itemStack) {
        MobFarmData mobFarmData = (MobFarmData)itemStack.getOrDefault(de.markusbordihn.easymobfarm.component.DataComponents.MOB_FARM_DATA, (Object)MobFarmData.EMPTY);
        int tierLevel = mobFarmData.tierLevel().getTierLevel();
        return TextComponent.getTranslatedBlockText(this.farmName, tierLevel);
    }

    public void onCraftedBy(ItemStack stack, Level level, Player player) {
        super.onCraftedBy(stack, level, player);
        MobFarmBlockItem.updateCustomModelData(stack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        MutableComponent processingSpeedText;
        MutableComponent tierLevelText;
        super.appendHoverText(itemStack, tooltipContext, tooltip, flag);
        MutableComponent farmDescription = TextComponent.getTranslatedText(this.farmName);
        List lines = Minecraft.getInstance().font.getSplitter().splitLines(farmDescription.getString(), 200, Style.EMPTY);
        for (FormattedText line : lines) {
            tooltip.add((Component)TextComponent.getText(line.getString()).withStyle(ChatFormatting.GRAY));
        }
        MobFarmData mobFarmData = (MobFarmData)itemStack.getOrDefault(de.markusbordihn.easymobfarm.component.DataComponents.MOB_FARM_DATA, (Object)MobFarmData.EMPTY);
        int tierLevel = mobFarmData.tierLevel().getTierLevel();
        switch (tierLevel) {
            case 0: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level", tierLevel, ChatFormatting.WHITE);
                break;
            }
            case 1: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level", tierLevel, ChatFormatting.GREEN);
                break;
            }
            case 2: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level", tierLevel, ChatFormatting.YELLOW);
                break;
            }
            case 3: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level", tierLevel, ChatFormatting.RED);
                break;
            }
            default: {
                MutableComponent mutableComponent = tierLevelText = null;
            }
        }
        if (tierLevelText != null) {
            tooltip.add((Component)tierLevelText);
        }
        switch (tierLevel) {
            case 0: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level_processing_speed", 20 + MobFarmConfig.tier0progressionUpgradeSpeed, ChatFormatting.WHITE);
                break;
            }
            case 1: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level_processing_speed", 20 + MobFarmConfig.tier1progressionUpgradeSpeed, ChatFormatting.GREEN);
                break;
            }
            case 2: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level_processing_speed", 20 + MobFarmConfig.tier2progressionUpgradeSpeed, ChatFormatting.YELLOW);
                break;
            }
            case 3: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level_processing_speed", 20 + MobFarmConfig.tier3progressionUpgradeSpeed, ChatFormatting.RED);
                break;
            }
            default: {
                MutableComponent mutableComponent = processingSpeedText = null;
            }
        }
        if (processingSpeedText != null) {
            tooltip.add((Component)processingSpeedText);
        }
    }
}

