/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item.mobcapturecard;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.item.mobcapturecard.BlankMobCaptureCardItem;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreativeBlankMobCaptureCardItem
extends BlankMobCaptureCardItem {
    public static final String ID = "creative_blank_mob_capture_card";
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    public CreativeBlankMobCaptureCardItem() {
        super(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)ID))));
    }

    public CreativeBlankMobCaptureCardItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        if (livingEntity == null || livingEntity instanceof Player || livingEntity.isDeadOrDying()) {
            return InteractionResult.FAIL;
        }
        Level level = livingEntity.level();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack mobCaptureCardItemStack = MobCaptureManager.getMobCaptureCardItem(livingEntity);
        if (mobCaptureCardItemStack == null || mobCaptureCardItemStack.isEmpty()) {
            log.error("Failed to capture entity {}", (Object)livingEntity);
            return InteractionResult.FAIL;
        }
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(mobCaptureCardItemStack);
        if (mobCaptureData == null || mobCaptureData.entityType() == null) {
            log.error("Failed to get mob capture data for entity {}", (Object)livingEntity);
            return InteractionResult.FAIL;
        }
        if (player.getAbilities().instabuild) {
            ItemStack mobCaptureCardItemStackCopy = mobCaptureCardItemStack.copy();
            if (!player.addItem(mobCaptureCardItemStack)) {
                log.error("Failed to add mob capture card {} to player {}", (Object)mobCaptureCardItemStack, (Object)player);
                return InteractionResult.FAIL;
            }
            log.info("Added mob capture card {} to players inventory {}", (Object)mobCaptureCardItemStackCopy, (Object)player);
        } else {
            player.setItemInHand(hand, mobCaptureCardItemStack);
            log.info("Set mob capture card {} to players hand {}", (Object)player.getItemInHand(hand), (Object)player);
        }
        livingEntity.remove(Entity.RemovalReason.KILLED);
        return InteractionResult.CONSUME;
    }
}

