/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.server;

import de.markusbordihn.easymobfarm.inventory.CraftingHandler;
import de.markusbordihn.easymobfarm.server.ServerEvents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class ServerEventHandler {
    private static final int PLAYER_INVENTORY_TICKS = 20;
    private static int playerInventoryTicker = 0;

    private ServerEventHandler() {
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        ServerEvents.handleServerStartedEvent(event.getServer());
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        ServerEvents.handleServerStartingEvent(event.getServer());
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
            if (abstractContainerMenu instanceof CraftingMenu) {
                CraftingMenu craftingMenu = (CraftingMenu)abstractContainerMenu;
                CraftingHandler.handleCraftingMenu(craftingMenu, craftingMenu.craftSlots);
            }
            if (playerInventoryTicker++ > 20) {
                CraftingHandler.handlePlayerInventory(serverPlayer);
                playerInventoryTicker = 0;
            }
        }
    }
}

