/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.experience;

import java.lang.reflect.Method;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ExperienceManagerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    default public int getExperienceReward(LivingEntity livingEntity, ServerLevel serverLevel) {
        return this.getExperienceReward(livingEntity, serverLevel, null);
    }

    default public boolean shouldDropExperience(LivingEntity livingEntity) {
        try {
            return livingEntity.shouldDropExperience();
        }
        catch (Exception e) {
            log.error("{} Failed to check if entity should drop experience for {}", (Object)"[Experience Manager]", (Object)livingEntity.getClass().getSimpleName(), (Object)e);
            return false;
        }
    }

    default public int getExperienceReward(LivingEntity livingEntity, ServerLevel serverLevel, String methodName) {
        try {
            Method getBaseExperienceRewardMethod = LivingEntity.class.getDeclaredMethod("getBaseExperienceReward", ServerLevel.class);
            getBaseExperienceRewardMethod.setAccessible(true);
            return (Integer)getBaseExperienceRewardMethod.invoke((Object)livingEntity, serverLevel);
        }
        catch (NoSuchMethodException e) {
            if (methodName != null && !methodName.isEmpty()) {
                try {
                    Method getBaseExperienceRewardMethod = LivingEntity.class.getDeclaredMethod(methodName, ServerLevel.class);
                    getBaseExperienceRewardMethod.setAccessible(true);
                    return (Integer)getBaseExperienceRewardMethod.invoke((Object)livingEntity, serverLevel);
                }
                catch (Exception ex) {
                    log.error("{} Failed to get experience reward for {} with method {}", (Object)"[Experience Manager]", (Object)livingEntity.getClass().getSimpleName(), (Object)methodName, (Object)ex);
                }
            } else {
                log.error("{} Failed to get experience reward for {}", (Object)"[Experience Manager]", (Object)livingEntity.getClass().getSimpleName(), (Object)e);
            }
        }
        catch (Exception e) {
            log.error("{} Failed to get experience reward for {}", (Object)"[Experience Manager]", (Object)livingEntity.getClass().getSimpleName(), (Object)e);
            return 0;
        }
        log.error("{} Failed to get experience reward for {}", (Object)"[Experience Manager]", (Object)livingEntity.getClass().getSimpleName());
        return 0;
    }
}

