/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.renderer.blockentity;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.client.renderer.blockentity.MobFarmRenderState;
import de.markusbordihn.easymobfarm.client.renderer.manager.EntityScalingManager;
import de.markusbordihn.easymobfarm.client.renderer.manager.RendererManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import net.minecraft.class_10017;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1425;
import net.minecraft.class_1432;
import net.minecraft.class_1477;
import net.minecraft.class_1510;
import net.minecraft.class_1577;
import net.minecraft.class_1593;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_4466;
import net.minecraft.class_4587;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionfc;

public class MobFarmBlockEntityRenderer
implements class_827<MobFarmBlockEntity, MobFarmRenderState> {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private final class_898 entityRenderer;

    public MobFarmBlockEntityRenderer(class_5614.class_5615 context) {
        this.entityRenderer = context.comp_4538();
    }

    public MobFarmRenderState createRenderState() {
        return new MobFarmRenderState();
    }

    public void extractRenderState(MobFarmBlockEntity blockEntity, MobFarmRenderState renderState, float partialTicks, class_243 cameraPos, class_11683.class_11792 crumblingOverlay) {
        super.method_74331((class_2586)blockEntity, (class_11954)renderState, partialTicks, cameraPos, crumblingOverlay);
        if (!blockEntity.hasCapturedMob() || blockEntity.method_10997() == null) {
            RendererManager.removeEntity(blockEntity);
            renderState.entityRenderState = null;
            return;
        }
        class_1297 entity = RendererManager.getOrCreateEntity(blockEntity);
        if (entity == null) {
            renderState.entityRenderState = null;
            return;
        }
        try {
            class_897 renderer = this.entityRenderer.method_3953(entity);
            class_10017 entityRenderState = renderer.method_62425(entity, partialTicks);
            entity.field_6012 = (int)blockEntity.method_10997().method_8510();
            MobCaptureCardDefinition mobCaptureCardDefinition = MobCaptureCardDefinitionManager.get(entity.method_5864());
            if (mobCaptureCardDefinition != null && mobCaptureCardDefinition.requiresAnimationTick() && entity.field_6012 % 2 == 0 || entity.field_6012 % 200 == 0) {
                entity.method_5773();
            }
            renderer.method_62354(entity, entityRenderState, partialTicks);
            entityRenderState.field_61820 = renderState.field_62676;
            renderState.entityRenderState = entityRenderState;
            renderState.facing = (class_2350)blockEntity.method_11010().method_11654(MobFarmBlock.FACING);
            renderState.isLuckyDropFarm = blockEntity.getFarmType() == MobFarmType.LUCKY_DROP_FARM;
            renderState.entityScaling = EntityScalingManager.getEntityScale(entity);
            if (renderState.isLuckyDropFarm) {
                renderState.entityScaling *= 0.75f;
            }
            renderState.entityType = this.determineEntityType(entity);
            renderState.rotationDegrees = switch (renderState.facing) {
                case class_2350.field_11043 -> 180.0f;
                case class_2350.field_11035 -> 0.0f;
                case class_2350.field_11039 -> -90.0f;
                case class_2350.field_11034 -> 90.0f;
                default -> 0.0f;
            };
        }
        catch (Exception exception) {
            log.error("Failed to extract render state for entity {} at block entity {}: {}", (Object)entity.method_5864(), (Object)blockEntity.method_11016(), (Object)exception.getMessage());
            renderState.entityRenderState = null;
        }
    }

    public void submit(MobFarmRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        if (renderState.entityRenderState == null) {
            return;
        }
        poseStack.method_22903();
        if (renderState.isLuckyDropFarm) {
            poseStack.method_22904(0.5, 0.19, 0.5);
        } else {
            poseStack.method_22904(0.5, 0.08, 0.5);
        }
        poseStack.method_22905(renderState.entityScaling, renderState.entityScaling, renderState.entityScaling);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(renderState.rotationDegrees));
        this.applyEntitySpecificTransformations(renderState, poseStack);
        this.entityRenderer.method_72976(renderState.entityRenderState, cameraRenderState, 0.0, 0.0, 0.0, poseStack, submitNodeCollector);
        poseStack.method_22909();
    }

    private MobFarmRenderState.EntityType determineEntityType(class_1297 entity) {
        class_1432 flyingAnimal;
        if (entity instanceof class_1425) {
            return MobFarmRenderState.EntityType.SCHOOLING_FISH;
        }
        if (entity instanceof class_4466) {
            return MobFarmRenderState.EntityType.BEE;
        }
        if (entity instanceof class_1477) {
            return MobFarmRenderState.EntityType.SQUID;
        }
        if (entity instanceof class_1593) {
            return MobFarmRenderState.EntityType.PHANTOM;
        }
        if (entity instanceof class_1510) {
            return MobFarmRenderState.EntityType.ENDER_DRAGON;
        }
        if (entity instanceof class_1432 && (flyingAnimal = (class_1432)entity).method_6581() || entity instanceof class_1577) {
            return MobFarmRenderState.EntityType.FLYING_ANIMAL;
        }
        return MobFarmRenderState.EntityType.GENERIC;
    }

    private void applyEntitySpecificTransformations(MobFarmRenderState renderState, class_4587 poseStack) {
        switch (renderState.entityType) {
            case SCHOOLING_FISH: {
                poseStack.method_22904(-0.1, 0.5, 0.1);
                poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(2.0f));
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(15.0f));
                poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(-90.0f));
                break;
            }
            case BEE: 
            case PHANTOM: {
                poseStack.method_22904(0.0, 0.5, 0.0);
                break;
            }
            case SQUID: {
                poseStack.method_22904(0.0, 1.3, 0.0);
                break;
            }
            case FLYING_ANIMAL: {
                poseStack.method_22904(0.0, 0.3 / (double)renderState.entityScaling, 0.0);
                break;
            }
            case ENDER_DRAGON: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(0.0f));
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
                poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(0.0f));
                break;
            }
        }
    }
}

