/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.component.DataComponents;
import de.markusbordihn.easymobfarm.config.MobFarmConfig;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmData;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmTierLevel;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_7924;

public class MobFarmBlockItem
extends class_1747 {
    public static final String ID = "mob_farm_block_item";
    private final String farmName;
    private final MobFarmType mobFarmType;

    public MobFarmBlockItem(MobFarmType mobFarmType, class_2248 block) {
        this(mobFarmType, block, new class_1792.class_1793().method_63685().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"easy_mob_farm", (String)mobFarmType.getId()))));
    }

    public MobFarmBlockItem(MobFarmType mobFarmType, class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
        this.mobFarmType = mobFarmType;
        this.farmName = mobFarmType.getId();
    }

    public static MobFarmTierLevel getTierLevel(class_1799 itemStack) {
        MobFarmData mobFarmData = (MobFarmData)itemStack.method_58695(DataComponents.MOB_FARM_DATA, (Object)MobFarmData.EMPTY);
        return mobFarmData.tierLevel();
    }

    public String getFarmName() {
        return this.farmName;
    }

    public MobFarmType getMobFarmType() {
        return this.mobFarmType;
    }

    public class_2561 method_7864(class_1799 itemStack) {
        MobFarmData mobFarmData = (MobFarmData)itemStack.method_58695(DataComponents.MOB_FARM_DATA, (Object)MobFarmData.EMPTY);
        int tierLevel = mobFarmData.tierLevel().getTierLevel();
        return TextComponent.getTranslatedBlockText(this.farmName, tierLevel);
    }

    public void method_67187(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_10712 tooltipDisplay, Consumer<class_2561> tooltipConsumer, class_1836 tooltipFlag) {
        class_5250 processingSpeedText;
        class_5250 tierLevelText;
        super.method_67187(itemStack, tooltipContext, tooltipDisplay, tooltipConsumer, tooltipFlag);
        class_5250 farmDescription = TextComponent.getTranslatedText(this.farmName);
        if (RenderSystem.isOnRenderThread()) {
            List lines = class_310.method_1551().field_1772.method_27527().method_27495((class_5348)farmDescription, 200, class_2583.field_24360);
            for (class_5348 line : lines) {
                tooltipConsumer.accept((class_2561)class_2561.method_43470((String)line.getString()).method_27692(class_124.field_1080));
            }
        } else {
            tooltipConsumer.accept((class_2561)farmDescription.method_27661().method_27692(class_124.field_1080));
        }
        MobFarmData mobFarmData = (MobFarmData)itemStack.method_58695(DataComponents.MOB_FARM_DATA, (Object)MobFarmData.EMPTY);
        int tierLevel = mobFarmData.tierLevel().getTierLevel();
        switch (tierLevel) {
            case 0: {
                class_5250 class_52502 = TextComponent.getTranslatedText("tier_level", tierLevel, class_124.field_1068);
                break;
            }
            case 1: {
                class_5250 class_52502 = TextComponent.getTranslatedText("tier_level", tierLevel, class_124.field_1060);
                break;
            }
            case 2: {
                class_5250 class_52502 = TextComponent.getTranslatedText("tier_level", tierLevel, class_124.field_1054);
                break;
            }
            case 3: {
                class_5250 class_52502 = TextComponent.getTranslatedText("tier_level", tierLevel, class_124.field_1061);
                break;
            }
            default: {
                class_5250 class_52502 = tierLevelText = null;
            }
        }
        if (tierLevelText != null) {
            tooltipConsumer.accept((class_2561)tierLevelText);
        }
        switch (tierLevel) {
            case 0: {
                class_5250 class_52503 = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), class_124.field_1068);
                break;
            }
            case 1: {
                class_5250 class_52503 = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), class_124.field_1060);
                break;
            }
            case 2: {
                class_5250 class_52503 = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), class_124.field_1054);
                break;
            }
            case 3: {
                class_5250 class_52503 = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), class_124.field_1061);
                break;
            }
            default: {
                class_5250 class_52503 = processingSpeedText = null;
            }
        }
        if (processingSpeedText != null) {
            tooltipConsumer.accept((class_2561)processingSpeedText);
        }
        if (MobFarmType.LUCKY_DROP_FARM.getId().equals(this.farmName)) {
            tooltipConsumer.accept((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.lucky_drop_percentage", new Object[]{MobFarmConfig.luckyDropFarmLuckPercentage}));
            if (MobFarmConfig.luckyDropFarmLuckPercentage < 100) {
                tooltipConsumer.accept((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.lucky_drop_warn").method_27692(class_124.field_1061));
            }
        }
    }
}

