/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.loot;

import de.markusbordihn.easymobfarm.compat.CompatConstants;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobVariantData;
import de.markusbordihn.easymobfarm.data.enhancement.FrogCatalystType;
import de.markusbordihn.easymobfarm.experience.ExperienceManager;
import de.markusbordihn.easymobfarm.item.upgrade.EnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.EggCollectorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.ExperienceEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.FrogCatalystEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.HoneyExtractorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.HoneyHarvesterFrameEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.KnifeEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.LootEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.LuckEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.MilkExtractorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.PollenTrapEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.SheepEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.SwordEnhancementItem;
import de.markusbordihn.easymobfarm.server.player.FakePlayer;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_10730;
import net.minecraft.class_11352;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1472;
import net.minecraft.class_1528;
import net.minecraft.class_1589;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4466;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7102;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_8942;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Random random = new Random();
    private static final Map<String, class_2960> FROG_CATALYST_RESOURCES = Map.ofEntries(Map.entry("cold", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_COLD)), Map.entry("temperate", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_TEMPERATE)), Map.entry("warm", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_WARM)), Map.entry("white", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_WHITE)), Map.entry("orange", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_ORANGE)), Map.entry("magenta", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_MAGENTA)), Map.entry("light_blue", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_LIGHT_BLUE)), Map.entry("yellow", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_YELLOW)), Map.entry("lime", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_LIME)), Map.entry("pink", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_PINK)), Map.entry("gray", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_GRAY)), Map.entry("light_gray", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_LIGHT_GRAY)), Map.entry("cyan", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_CYAN)), Map.entry("purple", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_PURPLE)), Map.entry("blue", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_BLUE)), Map.entry("brown", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_BROWN)), Map.entry("green", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_GREEN)), Map.entry("red", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_RED)), Map.entry("black", class_2960.method_60655((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_BLACK)));
    private static final EnumMap<FrogCatalystType, class_2960> FROGLIGHT_MAP = new EnumMap(FrogCatalystType.class);
    private static FakePlayer fakePlayer;

    private LootManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static class_2371<class_1799> getEntityLoot(MobCaptureData mobCaptureData, List<EnhancementItem> enhancements, class_1937 level) {
        class_1299<?> entityType = mobCaptureData.entityType();
        if (entityType == null) {
            log.error("Unable to get entity type from Mob Capture data: {}", (Object)mobCaptureData);
            return class_2371.method_10211();
        }
        class_1297 entity = entityType.method_5883(level, class_3730.field_16467);
        if (entity == null) {
            log.error("Unable to create entity {}!", entityType);
            return class_2371.method_10211();
        }
        try {
            entity.method_5651(class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)level.method_30349(), (class_2487)mobCaptureData.data()));
            if (entity instanceof class_1472) {
                class_1472 sheepEntity = (class_1472)entity;
                sheepEntity.method_6635(false);
                if (mobCaptureData.hasColor()) {
                    sheepEntity.method_6631(mobCaptureData.color().getDyeColor());
                }
            }
            class_2371<class_1799> class_23712 = LootManager.getEntityLoot(entity, enhancements, level);
            return class_23712;
        }
        finally {
            entity.method_31472();
        }
    }

    public static class_2371<class_1799> getEntityLoot(class_1297 entity, List<EnhancementItem> enhancements, class_1937 level) {
        class_1309 livingEntity;
        class_2371 drops;
        block15: {
            block14: {
                drops = class_2371.method_10211();
                if (!(entity instanceof class_1309)) break block14;
                livingEntity = (class_1309)entity;
                if (level instanceof class_3218) break block15;
            }
            return drops;
        }
        class_3218 serverLevel = (class_3218)level;
        FakePlayer fakePlayer = LootManager.getFakePlayer(serverLevel, entity.method_24515());
        class_8567.class_8568 lootContextBuilder = LootManager.createLootContextBuilder(serverLevel, livingEntity);
        float additionalLuck = 0.0f;
        int additionalRolls = 0;
        for (EnhancementItem enhancement : enhancements) {
            if (enhancement instanceof SwordEnhancementItem) {
                LootManager.setSwordEnhancementParameters(lootContextBuilder, fakePlayer, serverLevel);
                additionalLuck += 0.5f;
            }
            if (enhancement instanceof KnifeEnhancementItem) {
                LootManager.setKnifeEnhancementParameters(lootContextBuilder, fakePlayer, serverLevel);
                additionalLuck += 0.25f;
            }
            if (enhancement instanceof LootEnhancementItem) {
                ++additionalRolls;
            }
            if (!(enhancement instanceof LuckEnhancementItem)) continue;
            additionalLuck += 1.0f;
        }
        if (additionalLuck > 0.0f) {
            lootContextBuilder.method_51871(additionalLuck);
        }
        class_5321<class_52> lootTableLocation = LootManager.getLootTableLocation(livingEntity, enhancements);
        class_8567 lootParams = lootContextBuilder.method_51875(class_173.field_1173);
        if (lootTableLocation != null) {
            class_52 lootTable = serverLevel.method_8503().method_58576().method_58295(lootTableLocation);
            for (int i = 0; i <= additionalRolls; ++i) {
                lootTable.method_51878(lootParams).stream().filter(itemStack -> !itemStack.method_7960()).forEach(arg_0 -> drops.add(arg_0));
                LootManager.handleSpecialEntityDrops(livingEntity, (class_2371<class_1799>)drops);
            }
        }
        if (drops.isEmpty()) {
            class_5321<class_52> customLootTableLocation = LootManager.getCustomLootTableLocation(livingEntity, enhancements);
            class_52 customLootTable = serverLevel.method_8503().method_58576().method_58295(customLootTableLocation);
            if (customLootTable != class_52.field_948) {
                log.debug("No loot drops for {} trying custom loot table {}!", (Object)livingEntity, customLootTableLocation);
                for (int i = 0; i <= additionalRolls; ++i) {
                    customLootTable.method_51878(lootParams).stream().filter(itemStack -> !itemStack.method_7960()).forEach(arg_0 -> drops.add(arg_0));
                }
            } else {
                log.debug("No loot drops for {} and no custom loot table {}!", (Object)livingEntity, customLootTableLocation);
            }
        }
        LootManager.handlePostEnhancements(enhancements, livingEntity, serverLevel, fakePlayer, (class_2371<class_1799>)drops);
        LootManager.handleKnifeEnhancementLoot(enhancements, livingEntity, serverLevel, lootParams, (class_2371<class_1799>)drops);
        return drops;
    }

    public static class_2371<class_1799> getLuckyLoot(MobCaptureData mobCaptureData, class_2338 blockPos, class_1937 Level2) {
        class_2371 drops = class_2371.method_10211();
        if (!(Level2 instanceof class_3218)) {
            return drops;
        }
        class_3218 serverLevel = (class_3218)Level2;
        class_5321 lootTableLocation = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"minecraft", (String)(switch (mobCaptureData.rarity()) {
            default -> throw new MatchException(null, null);
            case class_1814.field_8906 -> "chests/simple_dungeon";
            case class_1814.field_8907 -> "chests/village/village_toolsmith";
            case class_1814.field_8903 -> "chests/stronghold_library";
            case class_1814.field_8904 -> "chests/end_city_treasure";
        })));
        FakePlayer fakePlayer = LootManager.getFakePlayer(serverLevel, blockPos);
        class_52 lootTable = serverLevel.method_8503().method_58576().method_58295(lootTableLocation);
        class_8567.class_8568 lootContextBuilder = LootManager.createLootChestContextBuilder(serverLevel, (class_1309)fakePlayer);
        lootContextBuilder.method_51871(switch (mobCaptureData.rarity()) {
            default -> throw new MatchException(null, null);
            case class_1814.field_8906 -> 0.0f;
            case class_1814.field_8907 -> 0.5f;
            case class_1814.field_8903 -> 1.0f;
            case class_1814.field_8904 -> 1.5f;
        });
        class_8567 lootContext = lootContextBuilder.method_51875(class_173.field_1179);
        lootTable.method_51878(lootContext).stream().filter(itemStack -> !itemStack.method_7960()).forEach(arg_0 -> drops.add(arg_0));
        return drops;
    }

    private static void handleSpecialEntityDrops(class_1309 livingEntity, class_2371<class_1799> drops) {
        if (livingEntity instanceof class_1528) {
            if (random.nextInt(2) == 0) {
                drops.add((Object)new class_1799((class_1935)class_1802.field_8137));
            }
            if (random.nextInt(2) == 0) {
                drops.add((Object)new class_1799((class_1935)class_1802.field_17515));
            }
        }
    }

    private static class_8567.class_8568 createLootContextBuilder(class_3218 serverLevel, class_1309 livingEntity) {
        return new class_8567.class_8568(serverLevel).method_51874(class_181.field_1231, (Object)serverLevel.method_48963().method_48830()).method_51874(class_181.field_24424, (Object)livingEntity.method_73189()).method_51874(class_181.field_1226, (Object)livingEntity);
    }

    private static class_8567.class_8568 createLootChestContextBuilder(class_3218 serverLevel, class_1309 livingEntity) {
        return new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)livingEntity.method_73189()).method_51874(class_181.field_1226, (Object)livingEntity);
    }

    private static class_5321<class_52> getLootTableLocation(class_1309 livingEntity, List<EnhancementItem> enhancements) {
        Optional<class_5321> lootTableLocation = livingEntity.method_5864().method_16351();
        for (EnhancementItem enhancement : enhancements) {
            if (!(enhancement instanceof SheepEnhancementItem) || !(livingEntity instanceof class_1472)) continue;
            class_1472 sheep = (class_1472)livingEntity;
            class_1767 color = sheep.method_6633();
            lootTableLocation = Optional.of(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"minecraft", (String)("entities/sheep/" + color.method_7792()))));
        }
        return lootTableLocation.orElse(null);
    }

    private static class_5321<class_52> getCustomLootTableLocation(class_1309 livingEntity, List<EnhancementItem> enhancements) {
        class_2960 entityTypeResourceLocation = class_7923.field_41177.method_10221((Object)livingEntity.method_5864());
        return class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"easy_mob_farm", (String)("entities/" + entityTypeResourceLocation.method_12836() + "/" + entityTypeResourceLocation.method_12832())));
    }

    private static void setSwordEnhancementParameters(class_8567.class_8568 lootParamsBuilder, FakePlayer fakePlayer, class_3218 serverLevel) {
        class_1799 swordItem = new class_1799((class_1935)class_1802.field_8371);
        fakePlayer.method_6122(class_1268.field_5808, swordItem);
        lootParamsBuilder.method_51874(class_181.field_1231, (Object)serverLevel.method_48963().method_48802((class_1657)fakePlayer)).method_51874(class_181.field_1233, (Object)fakePlayer).method_51874(class_181.field_1230, (Object)fakePlayer).method_51874(class_181.field_1227, (Object)fakePlayer);
    }

    private static void setKnifeEnhancementParameters(class_8567.class_8568 lootParamsBuilder, FakePlayer fakePlayer, class_3218 serverLevel) {
        class_1799 knifeItem = LootManager.getKnifeTool();
        if (!knifeItem.method_7960()) {
            fakePlayer.method_6122(class_1268.field_5808, knifeItem);
        }
        lootParamsBuilder.method_51874(class_181.field_1231, (Object)serverLevel.method_48963().method_48802((class_1657)fakePlayer)).method_51874(class_181.field_1233, (Object)fakePlayer).method_51874(class_181.field_1230, (Object)fakePlayer).method_51874(class_181.field_1227, (Object)fakePlayer);
    }

    private static class_1799 getKnifeTool() {
        Optional farmersDelightKnife;
        if (CompatConstants.MOD_FARMERS_DELIGHT_LOADED && (farmersDelightKnife = class_7923.field_41178.method_10223(class_2960.method_60655((String)"farmersdelight", (String)"iron_knife"))).isPresent() && ((class_6880.class_6883)farmersDelightKnife.get()).comp_349() != class_1802.field_8162) {
            return new class_1799((class_1935)((class_6880.class_6883)farmersDelightKnife.get()).comp_349());
        }
        return class_1799.field_8037;
    }

    private static void handlePostEnhancements(List<EnhancementItem> enhancements, class_1309 livingEntity, class_3218 serverLevel, FakePlayer fakePlayer, class_2371<class_1799> drops) {
        for (EnhancementItem enhancement : enhancements) {
            class_2960 frogCatalystResourceLocation;
            ExperienceEnhancementItem experienceEnhancementItem;
            if (enhancement instanceof ExperienceEnhancementItem && random.nextInt((experienceEnhancementItem = (ExperienceEnhancementItem)enhancement).experienceDropChance()) == 0 && ExperienceManager.shouldDropExperience(livingEntity)) {
                int experience = ExperienceManager.getExperienceReward(livingEntity, serverLevel);
                if (experience >= experienceEnhancementItem.minExperienceForDrop()) {
                    drops.add((Object)new class_1799((class_1935)class_1802.field_8287));
                } else {
                    log.debug("Experience drop of {} is below minimum threshold of {} for {}", (Object)experience, (Object)experienceEnhancementItem.minExperienceForDrop(), (Object)livingEntity);
                }
            }
            if (livingEntity instanceof class_4466) {
                if (enhancement instanceof HoneyHarvesterFrameEnhancementItem && random.nextInt(4) == 0) {
                    drops.add((Object)new class_1799((class_1935)class_1802.field_20414));
                    continue;
                }
                if (enhancement instanceof HoneyExtractorEnhancementItem && random.nextInt(10) == 0) {
                    drops.add((Object)new class_1799((class_1935)class_1802.field_20417));
                    continue;
                }
                if (!(enhancement instanceof PollenTrapEnhancementItem) || random.nextInt(5) != 0) continue;
                if (random.nextFloat() < 0.3f) {
                    drops.add((Object)LootManager.getRandomFlower());
                    continue;
                }
                drops.add((Object)LootManager.getRandomDye());
                continue;
            }
            if (livingEntity instanceof class_10730) {
                if (!(enhancement instanceof MilkExtractorEnhancementItem) || random.nextInt(2) != 0) continue;
                Optional milkBottle = CompatConstants.MOD_FARMERS_DELIGHT_LOADED ? class_7923.field_41178.method_10223(class_2960.method_60655((String)"farmersdelight", (String)"milk_bottle")) : class_7923.field_41178.method_10223(class_2960.method_60655((String)"easy_mob_farm", (String)"milk_bottle"));
                milkBottle.ifPresent(itemReference -> drops.add((Object)new class_1799((class_6880)itemReference)));
                continue;
            }
            if (livingEntity instanceof class_1428) {
                if (!(enhancement instanceof EggCollectorEnhancementItem) || random.nextInt(2) != 0) continue;
                drops.add((Object)new class_1799((class_1935)class_1802.field_8803));
                continue;
            }
            if (livingEntity instanceof class_7102) {
                if (random.nextInt(40) != 0) continue;
                String frogVariant = MobVariantData.getVariant(livingEntity);
                class_2960 frogCatalystResourceLocation2 = FROG_CATALYST_RESOURCES.get(frogVariant);
                if (frogCatalystResourceLocation2 != null) {
                    Object object;
                    Optional frogCatalystItem = class_7923.field_41178.method_10223(frogCatalystResourceLocation2);
                    if (frogCatalystItem.isPresent() && (object = ((class_6880.class_6883)frogCatalystItem.get()).comp_349()) instanceof FrogCatalystEnhancementItem) {
                        FrogCatalystEnhancementItem frogCatalystEnhancementItem = (FrogCatalystEnhancementItem)((Object)object);
                        drops.add((Object)new class_1799((class_1935)frogCatalystEnhancementItem));
                        continue;
                    }
                    log.warn("Frog Catalyst item {} is not an instance of FrogCatalystEnhancementItem!", (Object)frogCatalystItem);
                    continue;
                }
                log.warn("No Frog Catalyst resource found for variant {}!", (Object)frogVariant);
                continue;
            }
            if (!(livingEntity instanceof class_1589)) continue;
            if (random.nextInt(8) == 0) {
                drops.add((Object)new class_1799((class_1935)class_1802.field_8135));
            }
            if (!(enhancement instanceof FrogCatalystEnhancementItem)) continue;
            FrogCatalystEnhancementItem frogCatalystEnhancementItem = (FrogCatalystEnhancementItem)enhancement;
            if (random.nextInt(2) != 0) continue;
            FrogCatalystType frogCatalystType = frogCatalystEnhancementItem.getFrogCatalystType();
            switch (frogCatalystType) {
                case COLD: {
                    drops.add((Object)new class_1799((class_1935)class_1802.field_37540));
                    break;
                }
                case TEMPERATE: {
                    drops.add((Object)new class_1799((class_1935)class_1802.field_37539));
                    break;
                }
                case WARM: {
                    drops.add((Object)new class_1799((class_1935)class_1802.field_37541));
                    break;
                }
                default: {
                    if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) break;
                    log.error("Unknown Frog Catalyst type {}", (Object)frogCatalystType);
                }
            }
            if (!CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED || (frogCatalystResourceLocation = FROGLIGHT_MAP.get((Object)frogCatalystType)) == null) continue;
            Optional frogCatalystItem = class_7923.field_41178.method_10223(frogCatalystResourceLocation);
            if (frogCatalystItem.isPresent() && ((class_6880.class_6883)frogCatalystItem.get()).comp_349() != class_1802.field_8162) {
                drops.add((Object)new class_1799((class_1935)((class_6880.class_6883)frogCatalystItem.get()).comp_349()));
                continue;
            }
            log.warn("Swampier Swamps: Frog Catalyst item {} is not available!", (Object)frogCatalystType);
        }
    }

    private static void handleKnifeEnhancementLoot(List<EnhancementItem> enhancements, class_1309 livingEntity, class_3218 serverLevel, class_8567 lootParams, class_2371<class_1799> drops) {
        boolean hasKnifeEnhancement = false;
        for (EnhancementItem enhancement : enhancements) {
            if (!(enhancement instanceof KnifeEnhancementItem)) continue;
            hasKnifeEnhancement = true;
            break;
        }
        if (!hasKnifeEnhancement) {
            return;
        }
        class_2960 entityTypeResourceLocation = class_7923.field_41177.method_10221((Object)livingEntity.method_5864());
        class_5321 knifeLootTableLocation = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"easy_mob_farm", (String)("enhancement/knife/" + entityTypeResourceLocation.method_12836() + "/" + entityTypeResourceLocation.method_12832())));
        class_52 knifeLootTable = serverLevel.method_8503().method_58576().method_58295(knifeLootTableLocation);
        if (knifeLootTable != class_52.field_948) {
            knifeLootTable.method_51878(lootParams).stream().filter(itemStack -> !itemStack.method_7960()).forEach(arg_0 -> drops.add(arg_0));
        }
    }

    private static FakePlayer getFakePlayer(class_3218 level, class_2338 blockPos) {
        if (FakePlayer.isInvalidFakePlayer(fakePlayer)) {
            fakePlayer = new FakePlayer(level, blockPos);
            return fakePlayer;
        }
        return fakePlayer.updatePosition(level, blockPos);
    }

    private static class_1799 getRandomFlower() {
        List<class_1792> flowers = List.of(class_1802.field_8491, class_1802.field_8880, class_1802.field_17499, class_1802.field_17500, class_1802.field_17501, class_1802.field_17502, class_1802.field_17509, class_1802.field_17510, class_1802.field_17511, class_1802.field_17512, class_1802.field_17513, class_1802.field_17514);
        return new class_1799((class_1935)flowers.get(new Random().nextInt(flowers.size())));
    }

    private static class_1799 getRandomDye() {
        List<class_1792> dyes = List.of(class_1802.field_8192, class_1802.field_8264, class_1802.field_8345, class_1802.field_8492, class_1802.field_8330, class_1802.field_8446, class_1802.field_8226);
        return new class_1799((class_1935)dyes.get(new Random().nextInt(dyes.size())));
    }

    static {
        if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) {
            FROGLIGHT_MAP.put(FrogCatalystType.WHITE, class_2960.method_60655((String)"swampier_swamps", (String)"white_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.ORANGE, class_2960.method_60655((String)"swampier_swamps", (String)"orange_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.MAGENTA, class_2960.method_60655((String)"swampier_swamps", (String)"magenta_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.LIGHT_BLUE, class_2960.method_60655((String)"swampier_swamps", (String)"light_blue_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.YELLOW, class_2960.method_60655((String)"swampier_swamps", (String)"yellow_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.LIME, class_2960.method_60655((String)"swampier_swamps", (String)"lime_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.PINK, class_2960.method_60655((String)"swampier_swamps", (String)"pink_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.GRAY, class_2960.method_60655((String)"swampier_swamps", (String)"gray_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.LIGHT_GRAY, class_2960.method_60655((String)"swampier_swamps", (String)"light_gray_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.CYAN, class_2960.method_60655((String)"swampier_swamps", (String)"cyan_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.PURPLE, class_2960.method_60655((String)"minecraft", (String)"pearlescent_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.BLUE, class_2960.method_60655((String)"swampier_swamps", (String)"blue_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.BROWN, class_2960.method_60655((String)"swampier_swamps", (String)"brown_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.GREEN, class_2960.method_60655((String)"swampier_swamps", (String)"green_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.RED, class_2960.method_60655((String)"swampier_swamps", (String)"red_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.BLACK, class_2960.method_60655((String)"swampier_swamps", (String)"black_froglight"));
        }
    }
}

