/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.config;

import de.markusbordihn.easymobfarm.config.Config;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class MobFarmBonusConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "mob_farm_bonus.cfg";
    public static final String CONFIG_FILE_HEADER = " Mob Farm Bonus Configuration\n\n This configuration file allows you to define the bonus drops for the Mob Farms.\n\nThe format is as follows:\n- <mob_farm_name>::<tier_level>::<entity_type> = <item_name>::<amount>::<chance 1 of x>\n\nExample:\n- bee_hive_farm::0::minecraft:bee = minecraft:honeycomb::1::20\n- bee_hive_farm::1::minecraft:bee = minecraft:honeycomb::1::15\n- bee_hive_farm::2::minecraft:bee = minecraft:honeycomb::1::10\n- bee_hive_farm::3::minecraft:bee = minecraft:honeycomb::1::5\n\nTo disable a bonus drop for a default definition, set the amount to 0.\n\n";
    public static final String LOG_PREFIX = "[MobFarmBonusConfig]";
    private static final Random random = new Random();
    private static final HashMap<String, HashMap<Integer, class_1799>> mobFarmBonusMap = new HashMap();
    private static final HashMap<String, HashMap<Integer, class_1799>> defaultMobFarmBonusMap = new HashMap();

    public static void registerConfig() {
        MobFarmBonusConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        MobFarmBonusConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = MobFarmBonusConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = MobFarmBonusConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        defaultMobFarmBonusMap.forEach((mobFarmName, bonusMap) -> {
            if (!properties.containsKey(mobFarmName)) {
                bonusMap.forEach((chance, itemStack) -> {
                    String itemName = class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString();
                    String value = itemName + "::" + itemStack.method_7947() + "::" + chance;
                    properties.setProperty((String)mobFarmName, value);
                });
            }
        });
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String[] keyParts = MobFarmBonusConfig.parseKey((String)key);
            if (keyParts == null) {
                return;
            }
            String mobFarmName = keyParts[0];
            int tierLevel = Integer.parseInt(keyParts[1]);
            String entityType = keyParts[2];
            String[] valueParts = MobFarmBonusConfig.parseValue((String)value);
            if (valueParts == null || valueParts[0].isEmpty()) {
                return;
            }
            String itemName = valueParts[0];
            int amount = Integer.parseInt(valueParts[1]);
            int chance = Integer.parseInt(valueParts[2]);
            MobFarmBonusConfig.addBonusDropEntry(mobFarmName, tierLevel, entityType, chance, itemName, amount);
        }));
        MobFarmBonusConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static String getMobFarmKey(String mobFarmName, int tierLevel, String entityType) {
        return mobFarmName + "::" + tierLevel + "::" + entityType;
    }

    public static void addBonusDropEntry(String mobFarmName, int tierLevel, String entityType, int chance, String itemName, int amount) {
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)itemName));
        if (item == class_1802.field_8162) {
            log.error("{} Invalid item name {} in config file {}", (Object)LOG_PREFIX, (Object)itemName, (Object)CONFIG_FILE_NAME);
            return;
        }
        try {
            MobFarmType mobFarmType = MobFarmType.valueOf(mobFarmName.toUpperCase(Locale.ROOT));
            MobFarmBonusConfig.addBonusDropEntry(mobFarmType, tierLevel, entityType, chance, new class_1799((class_1935)item, amount));
        }
        catch (IllegalArgumentException e) {
            log.error("{} Invalid mob farm name {} in config file {}", (Object)LOG_PREFIX, (Object)mobFarmName, (Object)CONFIG_FILE_NAME);
        }
    }

    public static void addBonusDropEntry(MobFarmType mobFarmType, int tierLevel, String entityType, int chance, class_1799 itemStack) {
        String mobFarmKey = MobFarmBonusConfig.getMobFarmKey(mobFarmType.getId(), tierLevel, entityType);
        if (itemStack.method_7960()) {
            log.error("{} Invalid item stack {} in config file {}", (Object)LOG_PREFIX, (Object)itemStack, (Object)CONFIG_FILE_NAME);
            return;
        }
        if (class_7923.field_41177.method_17966(class_2960.method_12829((String)entityType)).isEmpty()) {
            log.error("{} Invalid entity type {} in config file {}", (Object)LOG_PREFIX, (Object)entityType, (Object)CONFIG_FILE_NAME);
            return;
        }
        log.info("{} Add {} with a chance of 1 of {} for {}.", (Object)LOG_PREFIX, (Object)mobFarmKey, (Object)chance, (Object)itemStack);
        mobFarmBonusMap.computeIfAbsent(mobFarmKey, k -> new HashMap()).put(chance, itemStack);
    }

    public static class_1799 getBonusDropEntry(MobFarmType mobFarmType, int tierLevel, class_1299<?> entityType) {
        return MobFarmBonusConfig.getBonusDropEntry(mobFarmType.getId(), tierLevel, String.valueOf(class_7923.field_41177.method_10221(entityType)));
    }

    public static class_1799 getBonusDropEntry(String mobFarmName, int tierLevel, String entityType) {
        if (!MobFarmBonusConfig.hasBonusDrop(mobFarmName, tierLevel, entityType)) {
            return class_1799.field_8037;
        }
        return mobFarmBonusMap.get(MobFarmBonusConfig.getMobFarmKey(mobFarmName, tierLevel, entityType)).entrySet().stream().map(Map.Entry::getValue).findFirst().orElse(class_1799.field_8037);
    }

    public static class_1799 getBonusDrop(MobFarmType mobFarmType, int tierLevel, class_1299<?> entityType) {
        return MobFarmBonusConfig.getBonusDrop(mobFarmType.getId(), tierLevel, String.valueOf(class_7923.field_41177.method_10221(entityType)));
    }

    public static class_1799 getBonusDrop(String mobFarmName, int tierLevel, String entityType) {
        if (!MobFarmBonusConfig.hasBonusDrop(mobFarmName, tierLevel, entityType)) {
            return class_1799.field_8037;
        }
        return mobFarmBonusMap.get(MobFarmBonusConfig.getMobFarmKey(mobFarmName, tierLevel, entityType)).entrySet().stream().filter(entry -> random.nextInt((Integer)entry.getKey()) == 0).map(Map.Entry::getValue).findFirst().orElse(class_1799.field_8037);
    }

    public static boolean hasBonusDrop(String mobFarmName, int tierLevel, class_1299<?> entityType) {
        return MobFarmBonusConfig.hasBonusDrop(mobFarmName, tierLevel, String.valueOf(class_7923.field_41177.method_10221(entityType)));
    }

    public static boolean hasBonusDrop(String mobFarmName, int tierLevel, String entityType) {
        return mobFarmBonusMap.containsKey(MobFarmBonusConfig.getMobFarmKey(mobFarmName, tierLevel, entityType));
    }

    private static String[] parseKey(String key) {
        String[] keyParts = key.split("::");
        if (keyParts.length != 3) {
            log.error("Invalid key format in config file: {}", (Object)key);
            return null;
        }
        return keyParts;
    }

    private static String[] parseValue(String value) {
        String[] valueParts = value.split("::");
        if (valueParts.length != 3) {
            log.error("Invalid value format in config file: {}", (Object)value);
            return null;
        }
        return valueParts;
    }

    static {
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::0::minecraft:cow", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_8745, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::1::minecraft:cow", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_8745, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::2::minecraft:cow", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_8745, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::3::minecraft:cow", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_8745, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::0::minecraft:sheep", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_19044, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::1::minecraft:sheep", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_19044, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::2::minecraft:sheep", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_19044, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::3::minecraft:sheep", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_19044, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::0::minecraft:chicken", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_8803, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::1::minecraft:chicken", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_8803, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::2::minecraft:chicken", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_8803, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::3::minecraft:chicken", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_8803, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.BEE_HIVE_FARM.getId() + "::0::minecraft:bee", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_20414, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.BEE_HIVE_FARM.getId() + "::1::minecraft:bee", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_20414, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.BEE_HIVE_FARM.getId() + "::2::minecraft:bee", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_20414, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.BEE_HIVE_FARM.getId() + "::3::minecraft:bee", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_20414, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::0::minecraft:husk", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_8858, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::1::minecraft:husk", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_8858, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::2::minecraft:husk", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_8858, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::3::minecraft:husk", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_8858, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::0::minecraft:rabbit", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_8245, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::1::minecraft:rabbit", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_8245, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::2::minecraft:rabbit", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_8245, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::3::minecraft:rabbit", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_8245, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.IRON_GOLEM_FARM.getId() + "::0::minecraft:iron_golem", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_8620, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.IRON_GOLEM_FARM.getId() + "::1::minecraft:iron_golem", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_8620, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.IRON_GOLEM_FARM.getId() + "::2::minecraft:iron_golem", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_8620, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.IRON_GOLEM_FARM.getId() + "::3::minecraft:iron_golem", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_8620, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::0::minecraft:parrot", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_8153, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::1::minecraft:parrot", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_8153, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::2::minecraft:parrot", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_8153, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::3::minecraft:parrot", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_8153, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::0::minecraft:panda", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_8648, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::1::minecraft:panda", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_8648, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::2::minecraft:panda", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_8648, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::3::minecraft:panda", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_8648, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.MONSTER_PLAINS_CAVE_FARM.getId() + "::0::minecraft:zombie", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_8511, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.MONSTER_PLAINS_CAVE_FARM.getId() + "::1::minecraft:zombie", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_8511, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.MONSTER_PLAINS_CAVE_FARM.getId() + "::2::minecraft:zombie", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_8511, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.MONSTER_PLAINS_CAVE_FARM.getId() + "::3::minecraft:zombie", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_8511, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::0::minecraft:blaze", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_8894, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::1::minecraft:blaze", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_8894, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::2::minecraft:blaze", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_8894, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::3::minecraft:blaze", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_8894, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::0::minecraft:magma_cube", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_8135, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::1::minecraft:magma_cube", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_8135, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::2::minecraft:magma_cube", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_8135, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::3::minecraft:magma_cube", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_8135, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::0::minecraft:cod", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_8429, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::1::minecraft:cod", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_8429, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::2::minecraft:cod", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_8429, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::3::minecraft:cod", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_8429, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::0::minecraft:squid", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_8794, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::1::minecraft:squid", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_8794, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::2::minecraft:squid", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_8794, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::3::minecraft:squid", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_8794, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::0::minecraft:frog", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_8777, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::1::minecraft:frog", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_8777, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::2::minecraft:frog", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_8777, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::3::minecraft:frog", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_8777, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::0::minecraft:slime", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_8777, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::1::minecraft:slime", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_8777, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::2::minecraft:slime", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_8777, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::3::minecraft:slime", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_8777, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::0::minecraft:witch", new HashMap<Integer, class_1799>(Map.of(20, new class_1799((class_1935)class_1802.field_8725, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::1::minecraft:witch", new HashMap<Integer, class_1799>(Map.of(15, new class_1799((class_1935)class_1802.field_8725, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::2::minecraft:witch", new HashMap<Integer, class_1799>(Map.of(10, new class_1799((class_1935)class_1802.field_8725, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::3::minecraft:witch", new HashMap<Integer, class_1799>(Map.of(5, new class_1799((class_1935)class_1802.field_8725, 1))));
    }
}

