/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import de.markusbordihn.easymobfarm.component.DataComponents;
import de.markusbordihn.easymobfarm.config.MobFarmConfig;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmData;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmTierLevel;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9280;
import net.minecraft.class_9334;

public class MobFarmBlockItem
extends class_1747 {
    private final String farmName;
    private final MobFarmType mobFarmType;

    public MobFarmBlockItem(MobFarmType mobFarmType, class_2248 block) {
        this(mobFarmType, block, new class_1792.class_1793());
    }

    public MobFarmBlockItem(MobFarmType mobFarmType, class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
        this.mobFarmType = mobFarmType;
        this.farmName = mobFarmType.getId();
    }

    public static void updateCustomModelData(class_1799 itemStack) {
        int tierLevel = MobFarmBlockItem.getTierLevel(itemStack).getTierLevel();
        if (tierLevel > 0) {
            itemStack.method_57379(class_9334.field_49637, (Object)new class_9280(tierLevel));
        }
    }

    public static MobFarmTierLevel getTierLevel(class_1799 itemStack) {
        MobFarmData mobFarmData = (MobFarmData)itemStack.method_57825(DataComponents.MOB_FARM_DATA, (Object)MobFarmData.EMPTY);
        return mobFarmData.tierLevel();
    }

    public String getFarmName() {
        return this.farmName;
    }

    public MobFarmType getMobFarmType() {
        return this.mobFarmType;
    }

    public class_2561 method_7864(class_1799 itemStack) {
        MobFarmData mobFarmData = (MobFarmData)itemStack.method_57825(DataComponents.MOB_FARM_DATA, (Object)MobFarmData.EMPTY);
        int tierLevel = mobFarmData.tierLevel().getTierLevel();
        return TextComponent.getTranslatedBlockText(this.farmName, tierLevel);
    }

    public void method_54465(class_1799 stack, class_1937 level, class_1657 player) {
        super.method_54465(stack, level, player);
        MobFarmBlockItem.updateCustomModelData(stack);
    }

    public void method_7851(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 flag) {
        class_5250 processingSpeedText;
        class_5250 tierLevelText;
        super.method_7851(itemStack, tooltipContext, tooltip, flag);
        class_5250 farmDescription = TextComponent.getTranslatedText(this.farmName);
        List lines = class_310.method_1551().field_1772.method_27527().method_27498(farmDescription.getString(), 200, class_2583.field_24360);
        for (class_5348 line : lines) {
            tooltip.add((class_2561)TextComponent.getText(line.getString()).method_27692(class_124.field_1080));
        }
        MobFarmData mobFarmData = (MobFarmData)itemStack.method_57825(DataComponents.MOB_FARM_DATA, (Object)MobFarmData.EMPTY);
        int tierLevel = mobFarmData.tierLevel().getTierLevel();
        switch (tierLevel) {
            case 0: {
                class_5250 class_52502 = TextComponent.getTranslatedText("tier_level", tierLevel, class_124.field_1068);
                break;
            }
            case 1: {
                class_5250 class_52502 = TextComponent.getTranslatedText("tier_level", tierLevel, class_124.field_1060);
                break;
            }
            case 2: {
                class_5250 class_52502 = TextComponent.getTranslatedText("tier_level", tierLevel, class_124.field_1054);
                break;
            }
            case 3: {
                class_5250 class_52502 = TextComponent.getTranslatedText("tier_level", tierLevel, class_124.field_1061);
                break;
            }
            default: {
                class_5250 class_52502 = tierLevelText = null;
            }
        }
        if (tierLevelText != null) {
            tooltip.add((class_2561)tierLevelText);
        }
        switch (tierLevel) {
            case 0: {
                class_5250 class_52503 = TextComponent.getTranslatedText("tier_level_processing_speed", 20 + MobFarmConfig.tier0progressionUpgradeSpeed, class_124.field_1068);
                break;
            }
            case 1: {
                class_5250 class_52503 = TextComponent.getTranslatedText("tier_level_processing_speed", 20 + MobFarmConfig.tier1progressionUpgradeSpeed, class_124.field_1060);
                break;
            }
            case 2: {
                class_5250 class_52503 = TextComponent.getTranslatedText("tier_level_processing_speed", 20 + MobFarmConfig.tier2progressionUpgradeSpeed, class_124.field_1054);
                break;
            }
            case 3: {
                class_5250 class_52503 = TextComponent.getTranslatedText("tier_level_processing_speed", 20 + MobFarmConfig.tier3progressionUpgradeSpeed, class_124.field_1061);
                break;
            }
            default: {
                class_5250 class_52503 = processingSpeedText = null;
            }
        }
        if (processingSpeedText != null) {
            tooltip.add((class_2561)processingSpeedText);
        }
    }
}

