/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import de.markusbordihn.easymobfarm.config.MobCatcherConfig;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_2596;
import net.minecraft.class_2788;
import net.minecraft.class_3222;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModRecipeManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[Recipe Manager]";
    private static final String MOB_CAPTURE_PREFIX = "mob_catcher/";

    private ModRecipeManager() {
    }

    public static void register(MinecraftServer minecraftServer) {
        log.info("{} Mod Recipe Manager ...", (Object)"Register Easy Mob Farm");
        ArrayList recipes = new ArrayList(minecraftServer.method_3772().method_8126());
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.ENDURING_CAPTURE_NET_ENABLED, "enduring_capture_net");
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.IRONBOUND_CONTAINMENT_CAGE_ENABLED, "ironbound_containment_cage");
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.MYSTIC_BINDING_CRYSTAL_ENABLED, "mystic_binding_crystal");
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.VOID_BINDING_CHAIN_ENABLED, "void_binding_chain");
        if (minecraftServer.method_3772().method_8126().size() != recipes.size()) {
            log.info("Updating recipes with adjusted recipes ...");
            minecraftServer.method_3772().method_20702(recipes);
            for (class_3222 player : minecraftServer.method_3760().method_14571()) {
                log.info("{} Sync recipe to player {} ...", (Object)LOG_PREFIX, (Object)player.method_5477().getString());
                player.field_13987.method_14364((class_2596)new class_2788(minecraftServer.method_3772().method_8126()));
            }
            minecraftServer.method_3772().method_8126().forEach(recipeHolder -> log.debug("{} Loaded recipe: {}", (Object)LOG_PREFIX, (Object)recipeHolder.comp_1932()));
        }
    }

    private static boolean removeRecipeIfDisabled(Collection<class_8786<?>> recipes, boolean isEnabled, String itemId) {
        if (isEnabled) {
            return false;
        }
        String recipePath = MOB_CAPTURE_PREFIX + itemId;
        boolean removed = recipes.removeIf(recipeHolder -> recipeHolder.comp_1932().method_12836().equals("easy_mob_farm") && recipeHolder.comp_1932().method_12832().equals(recipePath));
        if (removed) {
            log.info("{} Removed {} recipe ...", (Object)LOG_PREFIX, (Object)recipePath);
        } else {
            log.error("{} Failed to deactivate recipe {} !", (Object)LOG_PREFIX, (Object)recipePath);
        }
        return removed;
    }
}

