/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobCaptureCardDefinitionManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[Mob Capture Card Definition Manager]";
    private static final Map<class_2960, MobCaptureCardDefinition> DEFINITIONS = new ConcurrentHashMap<class_2960, MobCaptureCardDefinition>();
    private static final Map<class_1299<?>, MobCaptureCardDefinition> ENTITY_TYPE_DEFINITIONS = new ConcurrentHashMap();

    private MobCaptureCardDefinitionManager() {
    }

    public static void setDefinitions(Map<class_2960, MobCaptureCardDefinition> definitions) {
        log.debug("{} Set {} definitions with {}", (Object)LOG_PREFIX, (Object)definitions.size(), definitions.keySet());
        DEFINITIONS.clear();
        ENTITY_TYPE_DEFINITIONS.clear();
        for (Map.Entry<class_2960, MobCaptureCardDefinition> entry : definitions.entrySet()) {
            MobCaptureCardDefinitionManager.addDefinition(entry.getKey(), entry.getValue());
        }
    }

    public static void addDefinition(class_2960 entity, MobCaptureCardDefinition definition) {
        Optional entityType = class_7923.field_41177.method_17966(definition.entity());
        if (entityType.isEmpty()) {
            log.warn("{} Skipping {} definition {}. Entity type {} not found.", (Object)LOG_PREFIX, (Object)entity, (Object)definition, (Object)definition.entity());
            log.warn("This is expected for custom and mod entities which are not loaded.");
            return;
        }
        log.debug("{} Add {} definition: {}", (Object)LOG_PREFIX, (Object)entity, (Object)definition);
        MobCaptureCardDefinition mobCaptureCardDefinition = definition.withEntityType((class_1299)entityType.get());
        DEFINITIONS.put(entity, mobCaptureCardDefinition);
        ENTITY_TYPE_DEFINITIONS.put((class_1299)entityType.get(), mobCaptureCardDefinition);
    }

    public static MobCaptureCardDefinition get(class_2960 entity) {
        return DEFINITIONS.get(entity);
    }

    public static MobCaptureCardDefinition get(class_1299<?> entityType) {
        return ENTITY_TYPE_DEFINITIONS.get(entityType);
    }

    public static boolean has(class_2960 entity) {
        return DEFINITIONS.containsKey(entity);
    }

    public static Set<class_2960> getDefinedEntities() {
        return DEFINITIONS.keySet();
    }

    public static Map<class_2960, MobCaptureCardDefinition> getAll() {
        return Collections.unmodifiableMap(DEFINITIONS);
    }

    public static void clear() {
        log.debug("{} Clear {} definitions ...", (Object)LOG_PREFIX, (Object)DEFINITIONS.size());
        DEFINITIONS.clear();
    }
}

