/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import java.util.Set;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import net.minecraft.class_8942;

public class MobEntityData {
    public static final String DATA_TAG = "Data";
    protected static final String HEALTH_TAG = "Health";
    protected static final Set<String> SAFE_TO_REMOVE_BASE_TAGS = Set.of("Air", "Dead", "DeathTime", "FallDistance", "FallFlying", "Fire", "HurtByTimestamp", "HurtTime", "InWaterTime", "Motion", "OnGround", "PortalCooldown", "Pos", "Rotation");
    protected static final Set<String> UNSAFE_TO_REMOVE_BASE_TAGS = Set.of("UUID", "Attributes");
    protected static final Set<String> SAFE_TO_REMOVE_MOB_CAPTURE_CARD_TAGS = Set.of("AbsorptionAmount", "ActiveEffects", "AngerTime", "Brain", "CanBreakDoors", "CanPickUpLoot", "CanUpdate", "CurativeItems", "DrownedConversionTime", "Health", "Invulnerable", "LeftHanded", "PersistenceRequired", "TimeInOverworld");

    private MobEntityData() {
    }

    public static class_2487 getMobEntityData(class_1299<?> entityType) {
        return new class_2487();
    }

    public static class_2487 getMobEntityData(class_1309 livingEntity) {
        class_11362 valueOutput = class_11362.method_71459((class_8942)class_8942.field_60348, (class_7225.class_7874)livingEntity.method_73183().method_30349());
        livingEntity.method_5647((class_11372)valueOutput);
        class_2487 compoundTag = valueOutput.method_71475();
        if (livingEntity.method_29504()) {
            compoundTag.method_10548(HEALTH_TAG, livingEntity.method_6063());
        }
        compoundTag = MobEntityData.removeSafeToRemoveBaseTags(compoundTag);
        if (!livingEntity.method_16914()) {
            compoundTag = MobEntityData.removeUnsafeToRemoveBaseTags(compoundTag);
        }
        return compoundTag;
    }

    public static class_2487 getMobEntityData(class_2487 compoundTag) {
        if (compoundTag == null) {
            return new class_2487();
        }
        if (compoundTag.method_10545(DATA_TAG) && compoundTag.method_10562(DATA_TAG).isPresent()) {
            compoundTag = (class_2487)compoundTag.method_10562(DATA_TAG).get();
        }
        return MobEntityData.removeSafeToRemoveBaseTags(compoundTag);
    }

    private static class_2487 removeSafeToRemoveBaseTags(class_2487 compoundTag) {
        class_2487 cleanedCompoundTag = new class_2487();
        for (String key : compoundTag.method_10541()) {
            if (SAFE_TO_REMOVE_BASE_TAGS.contains(key)) continue;
            cleanedCompoundTag.method_10566(key, compoundTag.method_10580(key));
        }
        return cleanedCompoundTag;
    }

    private static class_2487 removeUnsafeToRemoveBaseTags(class_2487 compoundTag) {
        class_2487 cleanedCompoundTag = new class_2487();
        for (String key : compoundTag.method_10541()) {
            if (UNSAFE_TO_REMOVE_BASE_TAGS.contains(key)) continue;
            cleanedCompoundTag.method_10566(key, compoundTag.method_10580(key));
        }
        return cleanedCompoundTag;
    }

    public static class_2487 removeSafeToRemoveMobCaptureCardTags(class_2487 compoundTag) {
        class_2487 cleanedCompoundTag = new class_2487();
        for (String key : compoundTag.method_10541()) {
            if (SAFE_TO_REMOVE_MOB_CAPTURE_CARD_TAGS.contains(key)) continue;
            if (key.equals("Inventory")) {
                if (compoundTag.method_10580(key) == null || !compoundTag.method_10554(key).isPresent()) continue;
                cleanedCompoundTag.method_10566(key, compoundTag.method_10580(key));
                continue;
            }
            cleanedCompoundTag.method_10566(key, compoundTag.method_10580(key));
        }
        return cleanedCompoundTag;
    }
}

