/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import de.markusbordihn.easymobfarm.item.mobcatcher.MobCatcherItem;
import java.util.Locale;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;

public class MobCaptureDataSupport {
    public static final String CREATE_BLAZE_BURNER = "create:blaze_burner";
    public static final String MOB_CATCHER_DIAMOND = "mob_catcher:diamond_mob_catcher";
    public static final String MOB_CATCHER_NETHERITE = "mob_catcher:netherite_mob_catcher";
    public static final String MOB_CAPTURING_TOOL = "mobcapturingtool:mob_capturing_tool";
    public static final String SUPPLEMENTARIES_CAGE = "supplementaries:cage";
    public static final String SUPPLEMENTARIES_JAR = "supplementaries:jar";
    public static final String PRODUCTIVE_BEES_BEE_CAGE = "productivebees:bee_cage";
    public static final String PRODUCTIVE_BEES_BEE_JAR = "productivebees:bee_jar";
    private static final String MOD_DATA_TAG = "mob_data";
    private static final String ID_TAG = "id";
    private static final String CAPTURED_ENTITY_TAG = "CapturedEntity";
    private static final String ENTITY_TYPE_TAG = "EntityType";
    private static final String BLOCK_ENTITY_TAG = "BlockEntityTag";
    private static final String MOB_HOLDER_TAG = "MobHolder";
    private static final String ENTITY_DATA_TAG = "EntityData";
    private static final String ENTITY_TAG = "Entity";
    private static final String ENTITY__TAG = "Entity".toLowerCase(Locale.ROOT);

    public static boolean isSupported(ItemStack itemStack) {
        if (!MobCaptureDataSupport.isValidItemStack(itemStack)) {
            return false;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof MobCaptureCardItem || item instanceof SpawnEggItem || item instanceof MobCatcherItem) {
            return true;
        }
        String itemRegistryName = MobCaptureDataSupport.getItemRegistryName(item);
        if (itemRegistryName.isEmpty()) {
            return false;
        }
        return CREATE_BLAZE_BURNER.equals(itemRegistryName) || MOB_CATCHER_DIAMOND.equals(itemRegistryName) || MOB_CATCHER_NETHERITE.equals(itemRegistryName) || MOB_CAPTURING_TOOL.equals(itemRegistryName) || SUPPLEMENTARIES_CAGE.equals(itemRegistryName) || SUPPLEMENTARIES_JAR.equals(itemRegistryName) || PRODUCTIVE_BEES_BEE_CAGE.equals(itemRegistryName) || PRODUCTIVE_BEES_BEE_JAR.equals(itemRegistryName);
    }

    public static EntityType<?> getEntityType(ItemStack itemStack) {
        if (!MobCaptureDataSupport.isValidItemStack(itemStack)) {
            return null;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem spawnEggItem = (SpawnEggItem)item;
            return spawnEggItem.m_43228_(itemStack.m_41784_());
        }
        String itemRegistryName = MobCaptureDataSupport.getItemRegistryName(item);
        if (CREATE_BLAZE_BURNER.equals(itemRegistryName)) {
            return EntityType.f_20551_;
        }
        CompoundTag compoundTag = itemStack.m_41777_().m_41784_();
        if ((MOB_CATCHER_DIAMOND.equals(itemRegistryName) || MOB_CATCHER_NETHERITE.equals(itemRegistryName)) && compoundTag.m_128441_(MOD_DATA_TAG) && compoundTag.m_128469_(MOD_DATA_TAG).m_128441_(ID_TAG)) {
            return MobCaptureDataSupport.getEntityType(compoundTag.m_128469_(MOD_DATA_TAG).m_128461_(ID_TAG));
        }
        if (MOB_CAPTURING_TOOL.equals(itemRegistryName) && compoundTag.m_128441_(CAPTURED_ENTITY_TAG) && compoundTag.m_128469_(CAPTURED_ENTITY_TAG).m_128441_(ENTITY_TYPE_TAG)) {
            return MobCaptureDataSupport.getEntityType(compoundTag.m_128469_(CAPTURED_ENTITY_TAG).m_128461_(ENTITY_TYPE_TAG));
        }
        if ((SUPPLEMENTARIES_CAGE.equals(itemRegistryName) || SUPPLEMENTARIES_JAR.equals(itemRegistryName)) && compoundTag.m_128441_(BLOCK_ENTITY_TAG) && compoundTag.m_128469_(BLOCK_ENTITY_TAG).m_128441_(MOB_HOLDER_TAG) && compoundTag.m_128469_(BLOCK_ENTITY_TAG).m_128469_(MOB_HOLDER_TAG).m_128441_(ENTITY_DATA_TAG)) {
            return MobCaptureDataSupport.getEntityType(compoundTag.m_128469_(BLOCK_ENTITY_TAG).m_128469_(MOB_HOLDER_TAG).m_128469_(ENTITY_DATA_TAG).m_128461_(ID_TAG));
        }
        if ((PRODUCTIVE_BEES_BEE_CAGE.equals(itemRegistryName) || PRODUCTIVE_BEES_BEE_JAR.equals(itemRegistryName)) && compoundTag.m_128441_(ENTITY__TAG)) {
            return MobCaptureDataSupport.getEntityType(compoundTag.m_128461_(ENTITY__TAG));
        }
        return null;
    }

    public static EntityType<?> getEntityType(String entityName) {
        if (entityName == null || entityName.isEmpty()) {
            return null;
        }
        return (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(entityName));
    }

    public static String getEntityTypeName(ItemStack itemStack) {
        EntityType<?> entityType = MobCaptureDataSupport.getEntityType(itemStack);
        if (entityType != null) {
            return BuiltInRegistries.f_256780_.m_7981_(entityType).toString();
        }
        return null;
    }

    public static String getItemRegistryName(Item item) {
        if (item == null) {
            return null;
        }
        return BuiltInRegistries.f_257033_.m_7981_((Object)item).toString();
    }

    private static boolean isValidItemStack(ItemStack itemStack) {
        return itemStack != null && !itemStack.m_41619_() && itemStack.m_41613_() == 1;
    }
}

