/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.DyeColor;

public class MobColorData {
    public static final String COLOR_TAG = "Color";
    private static final Map<VillagerType, DyeColor> VILLAGER_COLOR_MAP = new HashMap<VillagerType, DyeColor>();

    private MobColorData() {
    }

    public static DyeColor getColor(EntityType<?> entityType) {
        return null;
    }

    public static DyeColor getColor(LivingEntity livingEntity) {
        if (livingEntity instanceof Sheep) {
            Sheep sheep = (Sheep)livingEntity;
            return sheep.m_29874_();
        }
        if (livingEntity instanceof Villager) {
            Villager villager = (Villager)livingEntity;
            return VILLAGER_COLOR_MAP.get(villager.m_7141_().m_35560_());
        }
        return null;
    }

    public static DyeColor getColor(CompoundTag compoundTag) {
        if (compoundTag == null || !compoundTag.m_128441_(COLOR_TAG)) {
            return null;
        }
        return MobColorData.getColor(compoundTag.m_128461_(COLOR_TAG));
    }

    public static DyeColor getColor(String color) {
        return DyeColor.m_41057_((String)color, null);
    }

    static {
        VILLAGER_COLOR_MAP.put(VillagerType.f_35821_, DyeColor.LIGHT_GRAY);
        VILLAGER_COLOR_MAP.put(VillagerType.f_35819_, DyeColor.YELLOW);
        VILLAGER_COLOR_MAP.put(VillagerType.f_35822_, DyeColor.ORANGE);
        VILLAGER_COLOR_MAP.put(VillagerType.f_35825_, DyeColor.BROWN);
        VILLAGER_COLOR_MAP.put(VillagerType.f_35823_, DyeColor.WHITE);
        VILLAGER_COLOR_MAP.put(VillagerType.f_35820_, DyeColor.GREEN);
        VILLAGER_COLOR_MAP.put(VillagerType.f_35824_, DyeColor.PURPLE);
    }
}

