/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.Villager;

public class MobVariantData {
    public static final String VARIANT_TAG = "Variant";
    public static final String LARGE_VARIANT = "large";
    public static final String MEDIUM_VARIANT = "medium";
    public static final String SMALL_VARIANT = "small";
    public static final String TINY_VARIANT = "tiny";
    private static final Map<FrogVariant, String> FROG_VARIANT_MAP = new HashMap<FrogVariant, String>();

    private MobVariantData() {
    }

    public static String getVariant(EntityType<?> entityType) {
        return null;
    }

    public static String getVariant(LivingEntity livingEntity) {
        if (livingEntity instanceof Cat) {
            Cat cat = (Cat)livingEntity;
            return BuiltInRegistries.f_256754_.m_7981_((Object)cat.m_28554_()).toString().replace("minecraft:", "");
        }
        if (livingEntity instanceof Villager) {
            Villager villager = (Villager)livingEntity;
            return villager.m_7141_().m_35571_().f_35600_();
        }
        if (livingEntity instanceof MagmaCube) {
            MagmaCube magmaCube = (MagmaCube)livingEntity;
            return MobVariantData.getSizeVariant(magmaCube.m_33632_());
        }
        if (livingEntity instanceof Slime) {
            Slime slime = (Slime)livingEntity;
            return MobVariantData.getSizeVariant(slime.m_33632_());
        }
        if (livingEntity instanceof Frog) {
            Frog frog = (Frog)livingEntity;
            return FROG_VARIANT_MAP.get(frog.m_28554_());
        }
        return null;
    }

    public static String getVariant(CompoundTag compoundTag) {
        if (compoundTag == null) {
            return null;
        }
        if (compoundTag.m_128441_(VARIANT_TAG)) {
            return compoundTag.m_128461_(VARIANT_TAG);
        }
        if (compoundTag.m_128441_(VARIANT_TAG.toLowerCase(Locale.ROOT))) {
            return compoundTag.m_128461_(VARIANT_TAG.toLowerCase(Locale.ROOT));
        }
        return null;
    }

    public static FrogVariant getFrogVariant(String variant) {
        for (Map.Entry<FrogVariant, String> entry : FROG_VARIANT_MAP.entrySet()) {
            if (!entry.getValue().equals(variant)) continue;
            return entry.getKey();
        }
        return FrogVariant.f_218185_;
    }

    public static String getSizeVariant(float size) {
        if (size <= 1.0f) {
            return TINY_VARIANT;
        }
        if (size <= 2.0f) {
            return SMALL_VARIANT;
        }
        if (size < 4.0f) {
            return MEDIUM_VARIANT;
        }
        if (size >= 4.0f) {
            return LARGE_VARIANT;
        }
        return "";
    }

    static {
        FROG_VARIANT_MAP.put(FrogVariant.f_218187_, "cold");
        FROG_VARIANT_MAP.put(FrogVariant.f_218186_, "warm");
        FROG_VARIANT_MAP.put(FrogVariant.f_218185_, "temperate");
    }
}

