/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.loot;

import de.markusbordihn.easymobfarm.compat.CompatConstants;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.experience.ExperienceManager;
import de.markusbordihn.easymobfarm.item.upgrade.EnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.EggCollectorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.ExperienceEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.FrogCatalystEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.HoneyExtractorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.HoneyHarvesterFrameEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.LootEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.LuckEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.MilkExtractorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.PollenTrapEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.SheepEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.SwordEnhancementItem;
import de.markusbordihn.easymobfarm.server.player.FakePlayer;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Random random = new Random();
    private static FakePlayer fakePlayer;

    private LootManager() {
    }

    public static NonNullList<ItemStack> getEntityLoot(MobCaptureData mobCaptureData, List<EnhancementItem> enhancements, Level level) {
        EntityType<?> entityType = mobCaptureData.entityType();
        if (entityType == null) {
            log.error("Unable to get entity type from Mob Capture data: {}", (Object)mobCaptureData);
            return NonNullList.m_122779_();
        }
        Entity entity = entityType.m_20615_(level);
        if (entity == null) {
            log.error("Unable to create entity {}!", entityType);
            return NonNullList.m_122779_();
        }
        entity.m_20258_(mobCaptureData.data());
        if (entity instanceof Sheep) {
            Sheep sheepEntity = (Sheep)entity;
            sheepEntity.m_29878_(false);
            if (mobCaptureData.hasColor()) {
                sheepEntity.m_29855_(mobCaptureData.color());
            }
        }
        NonNullList<ItemStack> drops = LootManager.getEntityLoot(entity, enhancements, level);
        entity.m_146870_();
        return drops;
    }

    public static NonNullList<ItemStack> getEntityLoot(Entity entity, List<EnhancementItem> enhancements, Level level) {
        LivingEntity livingEntity;
        NonNullList drops;
        block9: {
            block8: {
                drops = NonNullList.m_122779_();
                if (!(entity instanceof LivingEntity)) break block8;
                livingEntity = (LivingEntity)entity;
                if (level instanceof ServerLevel) break block9;
            }
            return drops;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        FakePlayer fakePlayer = LootManager.getFakePlayer(serverLevel, entity.m_20183_());
        LootParams.Builder lootContextBuilder = LootManager.createLootContextBuilder(serverLevel, livingEntity);
        ResourceLocation lootTableLocation = LootManager.getLootTableLocation(livingEntity, enhancements);
        float additionalLuck = 0.0f;
        int additionalRolls = 0;
        for (EnhancementItem enhancement : enhancements) {
            if (enhancement instanceof SwordEnhancementItem) {
                LootManager.setSwordEnhancementParameters(lootContextBuilder, fakePlayer, serverLevel);
                additionalLuck += 0.5f;
            }
            if (enhancement instanceof LootEnhancementItem) {
                ++additionalRolls;
            }
            if (!(enhancement instanceof LuckEnhancementItem)) continue;
            additionalLuck += 1.0f;
        }
        if (additionalLuck > 0.0f) {
            lootContextBuilder.m_287239_(additionalLuck);
        }
        LootParams lootContext = lootContextBuilder.m_287235_(LootContextParamSets.f_81415_);
        LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(lootTableLocation);
        for (int i = 0; i <= additionalRolls; ++i) {
            lootTable.m_287195_(lootContext).stream().filter(itemStack -> !itemStack.m_41619_()).forEach(arg_0 -> drops.add(arg_0));
            LootManager.handleSpecialEntityDrops(livingEntity, (NonNullList<ItemStack>)drops);
        }
        LootManager.handlePostEnhancements(enhancements, livingEntity, fakePlayer, (NonNullList<ItemStack>)drops);
        return drops;
    }

    public static NonNullList<ItemStack> getLuckyLoot(MobCaptureData mobCaptureData, BlockPos blockPos, Level Level2) {
        NonNullList drops = NonNullList.m_122779_();
        if (!(Level2 instanceof ServerLevel)) {
            return drops;
        }
        ServerLevel serverLevel = (ServerLevel)Level2;
        ResourceLocation lootTableLocation = new ResourceLocation("minecraft", switch (mobCaptureData.rarity()) {
            default -> throw new IncompatibleClassChangeError();
            case Rarity.COMMON -> "chests/simple_dungeon";
            case Rarity.UNCOMMON -> "chests/village/village_toolsmith";
            case Rarity.RARE -> "chests/stronghold_library";
            case Rarity.EPIC -> "chests/end_city_treasure";
        });
        FakePlayer fakePlayer = LootManager.getFakePlayer(serverLevel, blockPos);
        LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(lootTableLocation);
        LootParams.Builder lootContextBuilder = LootManager.createLootChestContextBuilder(serverLevel, (LivingEntity)fakePlayer);
        lootContextBuilder.m_287239_(switch (mobCaptureData.rarity()) {
            default -> throw new IncompatibleClassChangeError();
            case Rarity.COMMON -> 0.0f;
            case Rarity.UNCOMMON -> 0.5f;
            case Rarity.RARE -> 1.0f;
            case Rarity.EPIC -> 1.5f;
        });
        LootParams lootContext = lootContextBuilder.m_287235_(LootContextParamSets.f_81411_);
        lootTable.m_287195_(lootContext).stream().filter(itemStack -> !itemStack.m_41619_()).forEach(arg_0 -> drops.add(arg_0));
        return drops;
    }

    private static void handleSpecialEntityDrops(LivingEntity livingEntity, NonNullList<ItemStack> drops) {
        if (livingEntity instanceof WitherBoss) {
            if (random.nextInt(2) == 0) {
                drops.add((Object)new ItemStack((ItemLike)Items.f_42686_));
            }
            if (random.nextInt(2) == 0) {
                drops.add((Object)new ItemStack((ItemLike)Items.f_41951_));
            }
        }
    }

    private static LootParams.Builder createLootContextBuilder(ServerLevel serverLevel, LivingEntity livingEntity) {
        return new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81457_, (Object)serverLevel.m_269111_().m_269264_()).m_287286_(LootContextParams.f_81460_, (Object)livingEntity.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)livingEntity);
    }

    private static LootParams.Builder createLootChestContextBuilder(ServerLevel serverLevel, LivingEntity livingEntity) {
        return new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)livingEntity.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)livingEntity);
    }

    private static ResourceLocation getLootTableLocation(LivingEntity livingEntity, List<EnhancementItem> enhancements) {
        ResourceLocation lootTableLocation = livingEntity.m_6095_().m_20677_();
        for (EnhancementItem enhancement : enhancements) {
            if (!(enhancement instanceof SheepEnhancementItem) || !(livingEntity instanceof Sheep)) continue;
            Sheep sheep = (Sheep)livingEntity;
            DyeColor color = sheep.m_29874_();
            lootTableLocation = new ResourceLocation("minecraft", "entities/sheep/" + color.m_41065_());
        }
        return lootTableLocation;
    }

    private static void setSwordEnhancementParameters(LootParams.Builder lootParamsBuilder, FakePlayer fakePlayer, ServerLevel serverLevel) {
        lootParamsBuilder.m_287286_(LootContextParams.f_81457_, (Object)serverLevel.m_269111_().m_269075_((Player)fakePlayer)).m_287286_(LootContextParams.f_81456_, (Object)fakePlayer).m_287286_(LootContextParams.f_81458_, (Object)fakePlayer).m_287286_(LootContextParams.f_81459_, (Object)fakePlayer);
    }

    private static void handlePostEnhancements(List<EnhancementItem> enhancements, LivingEntity livingEntity, FakePlayer fakePlayer, NonNullList<ItemStack> drops) {
        block5: for (EnhancementItem enhancement : enhancements) {
            ExperienceEnhancementItem experienceEnhancementItem;
            if (enhancement instanceof ExperienceEnhancementItem && random.nextInt((experienceEnhancementItem = (ExperienceEnhancementItem)enhancement).experienceDropChance()) == 0 && ExperienceManager.shouldDropExperience(livingEntity)) {
                int experience = ExperienceManager.getExperienceReward(livingEntity);
                if (experience >= experienceEnhancementItem.minExperienceForDrop()) {
                    drops.add((Object)new ItemStack((ItemLike)Items.f_42612_));
                } else {
                    log.debug("Experience drop of {} is below minimum threshold of {} for {}", (Object)experience, (Object)experienceEnhancementItem.minExperienceForDrop(), (Object)livingEntity);
                }
            }
            if (livingEntity instanceof Bee) {
                if (enhancement instanceof HoneyHarvesterFrameEnhancementItem && random.nextInt(4) == 0) {
                    drops.add((Object)new ItemStack((ItemLike)Items.f_42784_));
                } else if (enhancement instanceof HoneyExtractorEnhancementItem && random.nextInt(10) == 0) {
                    drops.add((Object)new ItemStack((ItemLike)Items.f_42787_));
                } else if (enhancement instanceof PollenTrapEnhancementItem && random.nextInt(5) == 0) {
                    if (random.nextFloat() < 0.3f) {
                        drops.add((Object)LootManager.getRandomFlower());
                    } else {
                        drops.add((Object)LootManager.getRandomDye());
                    }
                }
            }
            if (livingEntity instanceof Cow && enhancement instanceof MilkExtractorEnhancementItem && random.nextInt(2) == 0) {
                Item milkBottle = CompatConstants.MOD_FARMERS_DELIGHT_LOADED ? (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("farmersdelight:milk_bottle")) : (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("easy_mob_farm:milk_bottle"));
                drops.add((Object)new ItemStack((ItemLike)milkBottle));
            }
            if (livingEntity instanceof Chicken && enhancement instanceof EggCollectorEnhancementItem && random.nextInt(2) == 0) {
                drops.add((Object)new ItemStack((ItemLike)Items.f_42521_));
            }
            if (!(livingEntity instanceof MagmaCube)) continue;
            if (random.nextInt(8) == 0) {
                drops.add((Object)new ItemStack((ItemLike)Items.f_42542_));
            }
            if (!(enhancement instanceof FrogCatalystEnhancementItem)) continue;
            FrogCatalystEnhancementItem frogCatalystEnhancementItem = (FrogCatalystEnhancementItem)enhancement;
            if (random.nextInt(2) != 0) continue;
            switch (frogCatalystEnhancementItem.getFrogCatalystType()) {
                case COLD: {
                    drops.add((Object)new ItemStack((ItemLike)Items.f_220221_));
                    continue block5;
                }
                case TEMPERATE: {
                    drops.add((Object)new ItemStack((ItemLike)Items.f_220220_));
                    continue block5;
                }
                case WARM: {
                    drops.add((Object)new ItemStack((ItemLike)Items.f_220222_));
                    continue block5;
                }
            }
            log.warn("Unknown Frog Catalyst type {}", (Object)frogCatalystEnhancementItem.getFrogCatalystType());
        }
    }

    private static FakePlayer getFakePlayer(ServerLevel level, BlockPos blockPos) {
        if (FakePlayer.isInvalidFakePlayer(fakePlayer)) {
            fakePlayer = new FakePlayer(level, blockPos);
            return fakePlayer;
        }
        return fakePlayer.updatePosition(level, blockPos);
    }

    private static ItemStack getRandomFlower() {
        List<Item> flowers = List.of(Items.f_41939_, Items.f_41940_, Items.f_41941_, Items.f_41942_, Items.f_41943_, Items.f_41944_, Items.f_41945_, Items.f_41946_, Items.f_41947_, Items.f_41948_, Items.f_41949_, Items.f_41950_);
        return new ItemStack((ItemLike)flowers.get(new Random().nextInt(flowers.size())));
    }

    private static ItemStack getRandomDye() {
        List<Item> dyes = List.of(Items.f_42539_, Items.f_42497_, Items.f_42494_, Items.f_42536_, Items.f_42489_, Items.f_42535_, Items.f_42498_);
        return new ItemStack((ItemLike)dyes.get(new Random().nextInt(dyes.size())));
    }
}

