/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.client.renderer.blockentity.MobFarmRenderState;
import de.markusbordihn.easymobfarm.client.renderer.manager.EntityScalingManager;
import de.markusbordihn.easymobfarm.client.renderer.manager.RendererManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionfc;

public class MobFarmBlockEntityRenderer
implements BlockEntityRenderer<MobFarmBlockEntity, MobFarmRenderState> {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private final EntityRenderDispatcher entityRenderer;

    public MobFarmBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.entityRenderer();
    }

    public MobFarmRenderState createRenderState() {
        return new MobFarmRenderState();
    }

    public void extractRenderState(MobFarmBlockEntity blockEntity, MobFarmRenderState renderState, float partialTicks, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTicks, cameraPos, crumblingOverlay);
        if (!blockEntity.hasCapturedMob() || blockEntity.getLevel() == null) {
            RendererManager.removeEntity(blockEntity);
            renderState.entityRenderState = null;
            return;
        }
        Entity entity = RendererManager.getOrCreateEntity(blockEntity);
        if (entity == null) {
            renderState.entityRenderState = null;
            return;
        }
        try {
            EntityRenderer renderer = this.entityRenderer.getRenderer(entity);
            EntityRenderState entityRenderState = renderer.createRenderState(entity, partialTicks);
            entity.tickCount = (int)blockEntity.getLevel().getGameTime();
            MobCaptureCardDefinition mobCaptureCardDefinition = MobCaptureCardDefinitionManager.get(entity.getType());
            if (mobCaptureCardDefinition != null && mobCaptureCardDefinition.requiresAnimationTick() && entity.tickCount % 2 == 0 || entity.tickCount % 200 == 0) {
                entity.tick();
            }
            renderer.extractRenderState(entity, entityRenderState, partialTicks);
            entityRenderState.lightCoords = renderState.lightCoords;
            renderState.entityRenderState = entityRenderState;
            renderState.facing = (Direction)blockEntity.getBlockState().getValue(MobFarmBlock.FACING);
            renderState.isLuckyDropFarm = blockEntity.getFarmType() == MobFarmType.LUCKY_DROP_FARM;
            renderState.entityScaling = EntityScalingManager.getEntityScale(entity);
            if (renderState.isLuckyDropFarm) {
                renderState.entityScaling *= 0.75f;
            }
            renderState.entityType = this.determineEntityType(entity);
            renderState.rotationDegrees = switch (renderState.facing) {
                case Direction.NORTH -> 180.0f;
                case Direction.SOUTH -> 0.0f;
                case Direction.WEST -> -90.0f;
                case Direction.EAST -> 90.0f;
                default -> 0.0f;
            };
        }
        catch (Exception exception) {
            log.error("Failed to extract render state for entity {} at block entity {}: {}", (Object)entity.getType(), (Object)blockEntity.getBlockPos(), (Object)exception.getMessage());
            renderState.entityRenderState = null;
        }
    }

    public void submit(MobFarmRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.entityRenderState == null) {
            return;
        }
        poseStack.pushPose();
        if (renderState.isLuckyDropFarm) {
            poseStack.translate(0.5, 0.19, 0.5);
        } else {
            poseStack.translate(0.5, 0.08, 0.5);
        }
        poseStack.scale(renderState.entityScaling, renderState.entityScaling, renderState.entityScaling);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.rotationDegrees));
        this.applyEntitySpecificTransformations(renderState, poseStack);
        this.entityRenderer.submit(renderState.entityRenderState, cameraRenderState, 0.0, 0.0, 0.0, poseStack, submitNodeCollector);
        poseStack.popPose();
    }

    private MobFarmRenderState.EntityType determineEntityType(Entity entity) {
        FlyingAnimal flyingAnimal;
        if (entity instanceof AbstractSchoolingFish) {
            return MobFarmRenderState.EntityType.SCHOOLING_FISH;
        }
        if (entity instanceof Bee) {
            return MobFarmRenderState.EntityType.BEE;
        }
        if (entity instanceof Squid) {
            return MobFarmRenderState.EntityType.SQUID;
        }
        if (entity instanceof Phantom) {
            return MobFarmRenderState.EntityType.PHANTOM;
        }
        if (entity instanceof EnderDragon) {
            return MobFarmRenderState.EntityType.ENDER_DRAGON;
        }
        if (entity instanceof FlyingAnimal && (flyingAnimal = (FlyingAnimal)entity).isFlying() || entity instanceof Guardian) {
            return MobFarmRenderState.EntityType.FLYING_ANIMAL;
        }
        return MobFarmRenderState.EntityType.GENERIC;
    }

    private void applyEntitySpecificTransformations(MobFarmRenderState renderState, PoseStack poseStack) {
        switch (renderState.entityType) {
            case SCHOOLING_FISH: {
                poseStack.translate(-0.1, 0.5, 0.1);
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(2.0f));
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(15.0f));
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-90.0f));
                break;
            }
            case BEE: 
            case PHANTOM: {
                poseStack.translate(0.0, 0.5, 0.0);
                break;
            }
            case SQUID: {
                poseStack.translate(0.0, 1.3, 0.0);
                break;
            }
            case FLYING_ANIMAL: {
                poseStack.translate(0.0, 0.3 / (double)renderState.entityScaling, 0.0);
                break;
            }
            case ENDER_DRAGON: {
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(0.0f));
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(0.0f));
                break;
            }
        }
    }
}

