/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item.mobcatcher;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.capture.MobCaptureManagerClient;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.item.MobFarmItem;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobCatcherItem
extends MobFarmItem {
    public static final String ID = "mob_catcher";
    public static final String MOB_CAPTURE_DATA_TAG = "MobCaptureData";
    public static final String TOOLTIP_PREFIX = "tooltip.easy_mob_farm.mob_catcher.";
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final float REQUIRED_HEALTH_PERCENTAGE_TO_CAPTURE = 0.25f;
    private static final float MAX_ENTITY_HEIGHT_TO_CAPTURE = 2.0f;
    private static final float MAX_ENTITY_WIDTH_TO_CAPTURE = 1.5f;
    private static final int ITEM_DAMAGE_ON_USE = 1;
    private static final Set<String> allowList = Set.of();
    private static final Set<String> denyList = Set.of();

    public MobCatcherItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean hasMobCaptureData(ItemStack itemStack) {
        return itemStack != null && itemStack.has(de.markusbordihn.easymobfarm.component.DataComponents.MOB_CAPTURE_DATA) && !((MobCaptureData)itemStack.getOrDefault(de.markusbordihn.easymobfarm.component.DataComponents.MOB_CAPTURE_DATA, (Object)MobCaptureData.EMPTY)).isEmpty();
    }

    public float getRequiredHealthPercentageToCapture() {
        return 0.25f;
    }

    public float getMaxEntityHeightToCapture() {
        return 2.0f;
    }

    public float getMaxEntityWidthToCapture() {
        return 1.5f;
    }

    public int getItemDamageOnUse() {
        return 1;
    }

    public Set<String> getAllowList() {
        return allowList;
    }

    public Set<String> getDenyList() {
        return denyList;
    }

    public boolean isFoil(ItemStack itemStack) {
        return MobCatcherItem.hasMobCaptureData(itemStack);
    }

    public InteractionResult useOn(UseOnContext context) {
        MobFarmBlockEntity mobFarmBlockEntity;
        BlockEntity blockEntity;
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        ItemStack itemStack = context.getItemInHand();
        if (!MobCatcherItem.hasMobCaptureData(itemStack)) {
            return InteractionResult.FAIL;
        }
        if (level.getBlockState(blockPos).getBlock() instanceof MobFarmBlock && (blockEntity = level.getBlockEntity(blockPos)) instanceof MobFarmBlockEntity && !(mobFarmBlockEntity = (MobFarmBlockEntity)blockEntity).hasCapturedMob()) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MobCaptureData mobCaptureData = (MobCaptureData)itemStack.get(de.markusbordihn.easymobfarm.component.DataComponents.MOB_CAPTURE_DATA);
            if (MobCaptureManager.releaseMob(mobCaptureData, blockPos, serverLevel)) {
                itemStack.remove(de.markusbordihn.easymobfarm.component.DataComponents.MOB_CAPTURE_DATA);
                itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(List.of(Float.valueOf(0.0f)), List.of(), List.of(), List.of()));
                return InteractionResult.SUCCESS;
            }
        }
        return level.isClientSide ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        float healthPercentage;
        if (livingEntity == null || livingEntity instanceof Player || livingEntity.isDeadOrDying()) {
            return InteractionResult.FAIL;
        }
        if (MobCatcherItem.hasMobCaptureData(itemStack)) {
            return InteractionResult.FAIL;
        }
        if (this.getItemDamageOnUse() > 0) {
            itemStack.hurtAndBreak(this.getItemDamageOnUse(), (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
        }
        String entityName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)livingEntity.getType()).toString();
        if (!this.getAllowList().isEmpty()) {
            if (!this.getAllowList().contains(entityName)) {
                log.debug("Mob {} is not on the allow list for {}.", (Object)entityName, (Object)this);
                player.displayClientMessage((Component)TextComponent.getTranslatedText("mob_is_not_on_allow_list", livingEntity.getDisplayName().getString()), true);
                return InteractionResult.FAIL;
            }
        } else {
            EntityDimensions dimensions;
            if (!this.getDenyList().isEmpty() && this.getDenyList().contains(entityName)) {
                log.debug("Mob {} is on the deny list for {}.", (Object)entityName, (Object)this);
                player.displayClientMessage((Component)TextComponent.getTranslatedText("mob_is_on_deny_list", livingEntity.getDisplayName().getString()), true);
                return InteractionResult.FAIL;
            }
            if ((this.getMaxEntityHeightToCapture() > 0.0f || this.getMaxEntityWidthToCapture() > 0.0f) && ((dimensions = livingEntity.getDimensions(livingEntity.getPose())).height() > this.getMaxEntityHeightToCapture() || dimensions.width() > this.getMaxEntityWidthToCapture())) {
                log.debug("Mob {} with {}x{} size is too large to be captured by {}.", (Object)entityName, (Object)Float.valueOf(dimensions.width()), (Object)Float.valueOf(dimensions.height()), (Object)this);
                player.displayClientMessage((Component)TextComponent.getTranslatedText("too_large_to_capture", livingEntity.getDisplayName().getString()), true);
                return InteractionResult.FAIL;
            }
        }
        if (this.getRequiredHealthPercentageToCapture() > 0.0f && (healthPercentage = livingEntity.getHealth() / livingEntity.getMaxHealth()) > this.getRequiredHealthPercentageToCapture()) {
            log.debug("Mob {} with {} health is too strong to be captured by {}.", (Object)entityName, (Object)Float.valueOf(healthPercentage), (Object)this);
            player.displayClientMessage((Component)TextComponent.getTranslatedText("too_strong_to_capture", livingEntity.getDisplayName().getString()), true);
            return InteractionResult.FAIL;
        }
        Level level = livingEntity.level();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        MobCaptureData mobCaptureData = new MobCaptureData(livingEntity);
        itemStack.set(de.markusbordihn.easymobfarm.component.DataComponents.MOB_CAPTURE_DATA, (Object)mobCaptureData);
        itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(List.of(Float.valueOf(1.0f)), List.of(), List.of(), List.of()));
        player.setItemInHand(hand, itemStack);
        livingEntity.discard();
        player.displayClientMessage((Component)TextComponent.getTranslatedText("captured_mob", mobCaptureData.name(), mobCaptureData.type()), true);
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        if (MobCatcherItem.hasMobCaptureData(itemStack)) {
            MobCaptureData mobCaptureData = MobCaptureManagerClient.getMobCaptureData(itemStack);
            this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.release_hint", mobCaptureData.name()).withStyle(ChatFormatting.DARK_RED));
            this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.name", mobCaptureData.name()));
            if (flag.isAdvanced()) {
                this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.type", mobCaptureData.type()));
            }
            if (mobCaptureData.variant() != null) {
                this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.variant", mobCaptureData.variant()));
            }
            if (mobCaptureData.color() != null) {
                this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.color", mobCaptureData.color().getName()));
            }
        } else {
            this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.capture_hint").withStyle(ChatFormatting.DARK_GREEN));
            this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.max_size", this.getMaxEntityWidthToCapture() + "x" + this.getMaxEntityHeightToCapture()));
            this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.min_health", this.getRequiredHealthPercentageToCapture() * 100.0f + "%"));
        }
        this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.usage_left", "(" + (itemStack.getMaxDamage() - itemStack.getDamageValue()) + "/" + itemStack.getMaxDamage() + ")").withStyle(ChatFormatting.GRAY));
    }
}

