/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block.entity;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.config.MobFarmBonusConfig;
import de.markusbordihn.easymobfarm.config.MobFarmConfig;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureDataSupport;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmContainerData;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmSlot;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmSlots;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import de.markusbordihn.easymobfarm.experience.ExperienceManager;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import de.markusbordihn.easymobfarm.item.upgrade.EnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.FilterItem;
import de.markusbordihn.easymobfarm.item.upgrade.SlotUpgradeItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.SpeedEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.filter.NoFlowersFilterItem;
import de.markusbordihn.easymobfarm.item.upgrade.filter.NoMeatFilterItem;
import de.markusbordihn.easymobfarm.loot.LootManager;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import de.markusbordihn.easymobfarm.tags.ModItemTags;
import de.markusbordihn.easymobfarm.utils.UUIDUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    public static final String ID = "mob_farm_entity";
    public static final int DEFAULT_PROCESSING_TICKS = 20;
    public static final int DEFAULT_RECHECK_TICKS = 200;
    public static final String TIER_LEVEL_TAG = "TierLevel";
    public static final String FARM_TYPE_TAG = "FarmType";
    public static final String OWNER_TAG = "Owner";
    public static final String CAPTURED_MOB_EXPERIENCE_TAG = "CapturedMobExperience";
    protected static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final int[] RESULT_SLOTS = MobFarmSlots.RESULT_SLOTS.stream().mapToInt(MobFarmSlot::index).toArray();
    private static final Random random = new Random();
    private final ContainerData data;
    private final int processingDelay;
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)52, (Object)ItemStack.EMPTY);
    private MobFarmType mobFarmType;
    private int farmTierLevel;
    private UUID owner;
    private int numberOfOutputSlots = 6;
    private int farmProgress = 0;
    private int farmProgressionSpeed = 20;
    private int farmStatus = 0;
    private int capturedMobExperience = -1;
    private HolderLookup.Provider provider;

    public MobFarmBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        this(blockEntityType, blockPos, blockState, MobFarmBlock.getTierLevel(blockState), MobFarmBlock.getFarmType(blockState));
    }

    public MobFarmBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState, int farmTierLevel, MobFarmType mobFarmType) {
        super(blockEntityType, blockPos, blockState);
        this.data = new MobFarmContainerData(this);
        this.setFarmTierLevel(farmTierLevel);
        this.mobFarmType = mobFarmType;
        this.processingDelay = Math.min(Math.max(Math.abs(blockPos.getX() * 31 + blockPos.getZ() * 17) % 20 + new Random().nextInt(5), 0), 19);
        this.setChanged();
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, MobFarmBlockEntity blockEntity) {
        if (((Boolean)blockState.getValue((Property)MobFarmBlock.POWERED)).booleanValue()) {
            if (blockEntity.farmStatus != 401) {
                blockEntity.farmStatus = 401;
            }
            return;
        }
        if (!blockEntity.hasCapturedMob() || blockEntity.farmStatus == 401) {
            if (blockEntity.farmStatus != 0) {
                blockEntity.farmStatus = 0;
            }
            return;
        }
        if (blockEntity.farmStatus == 400) {
            if (level.getGameTime() % 200L == 0L && blockEntity.canProcessingResults()) {
                log.debug("Mob farm block entity at {} is no longer full and can process results again", (Object)blockEntity.getBlockPos());
                blockEntity.farmStatus = 0;
            } else {
                return;
            }
        }
        if (level.getGameTime() % 20L != (long)blockEntity.processingDelay) {
            return;
        }
        if (blockEntity.farmProgress < MobFarmConfig.farmProgressingTime) {
            if (blockEntity.farmProgress % 200 == 0) {
                log.debug("Mob farm block entity at {} with farm progress {} / {}", (Object)blockPos, (Object)blockEntity.farmProgress, (Object)MobFarmConfig.farmProgressingTime);
            }
            int farmProgressionSpeed = MobFarmBlockEntity.getEffectiveFarmProgressionSpeed(blockEntity);
            blockEntity.farmProgress = Math.min(blockEntity.farmProgress + farmProgressionSpeed, MobFarmConfig.farmProgressingTime);
            blockEntity.farmStatus = 200;
            return;
        }
        if (MobFarmConfig.processingRequiresOwnerToBeOnline && blockEntity.hasOwner() && level.getPlayerByUUID(blockEntity.getOwner()) == null) {
            return;
        }
        if (blockEntity.canProcessingResults()) {
            blockEntity.processingResults();
        } else {
            log.warn("Mob farm block entity at {} is full and can't process results", (Object)blockEntity.getBlockPos());
            blockEntity.farmStatus = 400;
        }
        blockEntity.farmProgress = 0;
    }

    private static int getEffectiveFarmProgressionSpeed(MobFarmBlockEntity blockEntity) {
        return blockEntity.getFarmProgressionSpeed() + blockEntity.getFarmProgressionSpeedBonus();
    }

    public static float getProcessingSpeed(int tierLevel) {
        return MobFarmBlockEntity.getProcessingSpeed(tierLevel, 0);
    }

    public static float getProcessingSpeed(int tierLevel, int bonusSpeed) {
        int processingTicks = 20 + (switch (tierLevel) {
            case 0 -> MobFarmConfig.tier0progressionUpgradeSpeed;
            case 1 -> MobFarmConfig.tier1progressionUpgradeSpeed;
            case 2 -> MobFarmConfig.tier2progressionUpgradeSpeed;
            case 3 -> MobFarmConfig.tier3progressionUpgradeSpeed;
            default -> 0;
        }) + bonusSpeed;
        return (float)Math.round((float)MobFarmConfig.farmProgressingTime / (float)processingTicks * 10.0f) / 10.0f;
    }

    public int getFarmProgressionSpeed() {
        return this.farmProgressionSpeed;
    }

    public int getFarmProgressionSpeedBonus() {
        int farmProgressionSpeedBonus = 0;
        for (EnhancementItem enhancementItem : this.getEnchantmentItems()) {
            if (!(enhancementItem instanceof SpeedEnhancementItem)) continue;
            SpeedEnhancementItem speedEnhancementItem = (SpeedEnhancementItem)enhancementItem;
            farmProgressionSpeedBonus += speedEnhancementItem.getUpgradeSpeed();
        }
        return farmProgressionSpeedBonus;
    }

    public List<EnhancementItem> getEnchantmentItems() {
        ArrayList<EnhancementItem> enchantmentItems = new ArrayList<EnhancementItem>();
        for (MobFarmSlot upgradeSlot : MobFarmSlots.ENHANCEMENT_ITEM_SLOTS) {
            Item item;
            ItemStack itemStack = this.getItem(upgradeSlot.index());
            if (itemStack.isEmpty() || !((item = itemStack.getItem()) instanceof EnhancementItem)) continue;
            EnhancementItem enhancementItem = (EnhancementItem)item;
            enchantmentItems.add(enhancementItem);
        }
        return enchantmentItems;
    }

    public Set<FilterItem> getFilterItems() {
        HashSet<FilterItem> filterItems = new HashSet<FilterItem>();
        for (MobFarmSlot filterSlot : MobFarmSlots.FILTER_ITEM_SLOTS) {
            Item item;
            ItemStack itemStack = this.getItem(filterSlot.index());
            if (itemStack.isEmpty() || !((item = itemStack.getItem()) instanceof FilterItem)) continue;
            FilterItem filterItem = (FilterItem)item;
            filterItems.add(filterItem);
        }
        return filterItems;
    }

    public Set<SlotUpgradeItem> getSlotUpgradeItems() {
        HashSet<SlotUpgradeItem> slotUpgradeItems = new HashSet<SlotUpgradeItem>();
        for (MobFarmSlot upgradeSlot : MobFarmSlots.SLOT_UPGRADE_ITEM_SLOTS) {
            Item item;
            ItemStack itemStack = this.getItem(upgradeSlot.index());
            if (itemStack.isEmpty() || !((item = itemStack.getItem()) instanceof SlotUpgradeItem)) continue;
            SlotUpgradeItem slotUpgradeItem = (SlotUpgradeItem)item;
            slotUpgradeItems.add(slotUpgradeItem);
        }
        return slotUpgradeItems;
    }

    public void updateNumberOfOutputSlots() {
        int slots = 6;
        for (SlotUpgradeItem upgrade : this.getSlotUpgradeItems()) {
            slots += upgrade.numberOfUpgradeSlots();
        }
        if (this.numberOfOutputSlots != (slots = Math.min(Math.max(6, slots), 27))) {
            this.numberOfOutputSlots = slots;
        }
    }

    public boolean canProcessingResults() {
        int startSlotIndex;
        this.updateNumberOfOutputSlots();
        for (int slotIndex = startSlotIndex = MobFarmSlots.RESULT_SLOTS.get(0).index(); slotIndex < startSlotIndex + this.numberOfOutputSlots; ++slotIndex) {
            if (!this.getItem(slotIndex).isEmpty() && this.getItem(slotIndex).getCount() >= this.getItem(slotIndex).getMaxStackSize()) continue;
            return true;
        }
        return false;
    }

    private boolean processingLuckyDrops(MobCaptureData mobCaptureData, NonNullList<ItemStack> lootDrops) {
        NonNullList<ItemStack> luckyDrop;
        if (this.getFarmType() != MobFarmType.LUCKY_DROP_FARM) {
            return false;
        }
        int luckRoll = random.nextInt(100);
        if (luckRoll > MobFarmConfig.luckyDropFarmLuckPercentage) {
            log.debug("Bad lucky drop for {} (tier: {}) block entity at {} with captured mob {}", (Object)this.getFarmType(), (Object)this.getFarmTierLevel(), (Object)this.getBlockPos(), mobCaptureData.entityType());
            this.spawnEntity(mobCaptureData.entityType(), this.level, this.getBlockPos().above());
            this.removeItem(MobFarmSlot.CAPTURED_MOB.index(), 1);
            this.farmStatus = 0;
            return true;
        }
        log.debug("Lucky drop for {} (tier: {}) block entity at {} with captured mob {}", (Object)this.getFarmType(), (Object)this.getFarmTierLevel(), (Object)this.getBlockPos(), mobCaptureData.entityType());
        if (random.nextInt(2) == 0 && !(luckyDrop = LootManager.getLuckyLoot(mobCaptureData, this.getBlockPos(), this.level)).isEmpty()) {
            log.debug("Adding lucky loot drop {} for {} (tier: {}) block entity at {} with captured mob {}", luckyDrop, (Object)this.getFarmType(), (Object)this.getFarmTierLevel(), (Object)this.getBlockPos(), mobCaptureData.entityType());
            lootDrops.addAll(luckyDrop);
        }
        return false;
    }

    public void processingResults() {
        MobCaptureData mobCaptureData = this.getMobCaptureData();
        if (mobCaptureData == null) {
            return;
        }
        EntityType<?> entityType = mobCaptureData.entityType();
        if (entityType == null) {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                log.debug("Dropping invalid captured mob item {} for mob farm block entity at {}", (Object)this.getItem(MobFarmSlot.CAPTURED_MOB), (Object)this.getBlockPos());
                Containers.dropItemStack((Level)serverLevel, (double)((double)this.getBlockPos().getX() + 0.5), (double)((double)this.getBlockPos().getY() + 0.5), (double)((double)this.getBlockPos().getZ() + 0.5), (ItemStack)this.takeItem(MobFarmSlot.CAPTURED_MOB.index()));
            } else {
                log.error("Invalid entity type {} for mob farm block entity at {} with captured mob {}", entityType, (Object)this.getBlockPos(), (Object)mobCaptureData);
            }
            return;
        }
        this.farmStatus = 102;
        NonNullList<ItemStack> lootDrops = LootManager.getEntityLoot(mobCaptureData, this.getEnchantmentItems(), this.level);
        if (this.processingLuckyDrops(mobCaptureData, lootDrops)) {
            return;
        }
        ItemStack bonusLootDrop = MobFarmBonusConfig.getBonusDrop(this.getFarmType(), this.getFarmTierLevel(), entityType);
        if (!bonusLootDrop.isEmpty()) {
            log.debug("Adding bonus loot drop {} for {} (tier: {}) block entity at {} with captured mob {}", (Object)bonusLootDrop, (Object)this.getFarmType(), (Object)this.getFarmTierLevel(), (Object)this.getBlockPos(), entityType);
            lootDrops.add((Object)bonusLootDrop.copy());
        }
        this.handleLootDrops(lootDrops);
        this.farmStatus = 0;
    }

    private void handleLootDrops(NonNullList<ItemStack> lootDrops) {
        if (lootDrops == null || lootDrops.isEmpty()) {
            return;
        }
        log.debug("Processing loot drops for mob farm block entity at {} with {} loot drops", (Object)this.getBlockPos(), lootDrops);
        for (ItemStack lootDrop : lootDrops) {
            if (lootDrop.isEmpty()) continue;
            for (FilterItem filterItem : this.getFilterItems()) {
                if (filterItem instanceof NoMeatFilterItem && lootDrop.is(ModItemTags.MEAT)) {
                    lootDrop.setCount(0);
                }
                if (!(filterItem instanceof NoFlowersFilterItem) || !lootDrop.is(ModItemTags.FLOWERS)) continue;
                lootDrop.setCount(0);
            }
            for (MobFarmSlot filterSlot : MobFarmSlots.FILTER_ITEM_SLOTS) {
                ItemStack filterItem = this.getItem(filterSlot.index());
                if (filterItem.isEmpty() || !filterItem.is(lootDrop.getItem())) continue;
                log.debug("Filter slot {} matches loot drop {}", (Object)filterSlot, (Object)lootDrop);
                lootDrop.setCount(0);
                break;
            }
            this.storeItemInOutputSlot(lootDrop);
        }
    }

    private void storeItemInOutputSlot(ItemStack itemStack) {
        int startSlotIndex;
        for (int slotIndex = startSlotIndex = MobFarmSlots.RESULT_SLOTS.get(0).index(); slotIndex < startSlotIndex + this.numberOfOutputSlots; ++slotIndex) {
            ItemStack outputSlot = this.getItem(slotIndex);
            if (outputSlot.isEmpty()) {
                this.setItemInSlot(slotIndex, itemStack);
                break;
            }
            if (!this.canGrowOutputSlot(outputSlot, itemStack)) continue;
            this.growOutputSlot(outputSlot, itemStack);
            if (itemStack.isEmpty()) break;
        }
    }

    private void setItemInSlot(int slotIndex, ItemStack itemStack) {
        this.setItem(slotIndex, itemStack);
    }

    private boolean canGrowOutputSlot(ItemStack outputSlot, ItemStack itemStack) {
        return outputSlot.is(itemStack.getItem()) && outputSlot.getCount() < outputSlot.getMaxStackSize();
    }

    private void growOutputSlot(ItemStack outputSlot, ItemStack itemStack) {
        int amountToGrow = Math.min(itemStack.getCount(), outputSlot.getMaxStackSize() - outputSlot.getCount());
        outputSlot.grow(amountToGrow);
        itemStack.shrink(amountToGrow);
    }

    public MobCaptureData getMobCaptureData() {
        return MobCaptureManager.getMobCaptureData(this.getItem(MobFarmSlot.CAPTURED_MOB), this.level);
    }

    public boolean hasCapturedMob() {
        return !this.getItem(MobFarmSlot.CAPTURED_MOB).isEmpty();
    }

    public ItemStack takeItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = this.getItem(index);
        this.setItem(index, ItemStack.EMPTY);
        return itemStack;
    }

    public void giveMobCaptureItem(Player player, InteractionHand hand) {
        ItemStack capturedMob = this.getCapturedMob();
        if (capturedMob.isEmpty()) {
            return;
        }
        this.givePlayerItem(MobFarmSlot.CAPTURED_MOB.index(), player.level(), player, hand, player.blockPosition());
    }

    public void givePlayerItem(int index, Level level, Player player, InteractionHand hand, BlockPos blockPos) {
        ItemStack itemStack = this.takeItem(index);
        if (itemStack.isEmpty() || itemStack.isDamageableItem() && itemStack.getDamageValue() >= itemStack.getMaxDamage()) {
            return;
        }
        ItemStack handItemStack = player.getItemInHand(hand);
        if (handItemStack.isEmpty()) {
            player.setItemInHand(hand, itemStack);
        } else if (!player.getInventory().add(itemStack) && level != null) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, itemStack));
        }
        this.syncChanges();
    }

    private boolean isInvalidHandItem(ItemStack handItemStack) {
        return handItemStack.isEmpty() || handItemStack.isDamageableItem() && handItemStack.getDamageValue() >= handItemStack.getMaxDamage();
    }

    public boolean takeMobCaptureItem(Player player, InteractionHand hand) {
        ItemStack handItemStack = player.getItemInHand(hand);
        if (this.isInvalidHandItem(handItemStack)) {
            return false;
        }
        if ((MobCaptureDataSupport.isSupported(handItemStack) || handItemStack.getItem() instanceof MobCaptureCardItem) && this.getItem(MobFarmSlot.CAPTURED_MOB).isEmpty()) {
            return this.takePlayerItem(MobFarmSlot.CAPTURED_MOB.index(), player, hand);
        }
        return false;
    }

    public boolean takeEnhancementItem(Player player, InteractionHand hand) {
        ItemStack handItemStack = player.getItemInHand(hand);
        if (this.isInvalidHandItem(handItemStack)) {
            return false;
        }
        Item handItem = handItemStack.getItem();
        if (handItem instanceof EnhancementItem) {
            for (MobFarmSlot upgradeSlot : MobFarmSlots.ENHANCEMENT_ITEM_SLOTS) {
                ItemStack itemStack = this.getItem(upgradeSlot.index());
                if (!itemStack.isEmpty()) continue;
                return this.takePlayerItem(upgradeSlot.index(), player, hand);
            }
        }
        return false;
    }

    public boolean takeSlotUpgradeItem(Player player, InteractionHand hand) {
        ItemStack handItemStack = player.getItemInHand(hand);
        if (this.isInvalidHandItem(handItemStack)) {
            return false;
        }
        Item handItem = handItemStack.getItem();
        if (handItem instanceof SlotUpgradeItem) {
            for (MobFarmSlot upgradeSlot : MobFarmSlots.SLOT_UPGRADE_ITEM_SLOTS) {
                ItemStack itemStack = this.getItem(upgradeSlot.index());
                if (!itemStack.isEmpty()) continue;
                return this.takePlayerItem(upgradeSlot.index(), player, hand);
            }
        }
        return false;
    }

    public boolean takeFilterItem(Player player, InteractionHand hand) {
        ItemStack handItemStack = player.getItemInHand(hand);
        if (this.isInvalidHandItem(handItemStack)) {
            return false;
        }
        Item handItem = handItemStack.getItem();
        if (handItem instanceof FilterItem) {
            for (MobFarmSlot filterSlot : MobFarmSlots.FILTER_ITEM_SLOTS) {
                ItemStack itemStack = this.getItem(filterSlot.index());
                if (itemStack.is(handItemStack.getItem())) {
                    return false;
                }
                if (!itemStack.isEmpty()) continue;
                return this.takePlayerItem(filterSlot.index(), player, hand);
            }
        }
        return false;
    }

    public boolean takePlayerItem(int index, Player player, InteractionHand hand) {
        ItemStack handItemStack = player.getItemInHand(hand);
        if (handItemStack.isEmpty() || handItemStack.isDamageableItem() && handItemStack.getDamageValue() >= handItemStack.getMaxDamage()) {
            return false;
        }
        ItemStack itemStack = handItemStack.copy();
        itemStack.setCount(1);
        this.setItem(index, itemStack);
        if (!player.isCreative()) {
            handItemStack.shrink(1);
        }
        this.syncChanges();
        return true;
    }

    public int getNumberOfOutputSlots() {
        return this.numberOfOutputSlots;
    }

    public void setNumberOfOutputSlots(int numberOfOutputSlots) {
        this.numberOfOutputSlots = numberOfOutputSlots;
    }

    public int getFarmProgress() {
        return this.farmProgress;
    }

    public void setFarmProgress(int farmProgress) {
        this.farmProgress = farmProgress;
    }

    public int getFarmStatus() {
        return this.farmStatus;
    }

    public void setFarmStatus(int farmStatus) {
        this.farmStatus = farmStatus;
    }

    public int getFarmTierLevel() {
        return this.farmTierLevel;
    }

    public void setFarmTierLevel(int farmTierLevel) {
        if (this.data.get(6) == farmTierLevel) {
            return;
        }
        this.farmProgressionSpeed = 20;
        this.farmProgressionSpeed += MobFarmConfig.getFarmTierProgressionUpgradeSpeed(farmTierLevel);
        log.debug("Set mob farm tier level to {}", (Object)farmTierLevel);
        this.farmTierLevel = farmTierLevel;
    }

    public MobFarmType getFarmType() {
        return this.mobFarmType;
    }

    public ItemStack getCapturedMob() {
        return this.getItem(MobFarmSlot.CAPTURED_MOB);
    }

    public int getCapturedMobExperience() {
        return this.capturedMobExperience;
    }

    public ItemStack getItem(MobFarmSlot mobFarmSlot) {
        return (ItemStack)this.items.get(mobFarmSlot.index());
    }

    public void syncChanges() {
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(Player player) {
        log.debug("Set owner for mob farm block entity to {}", (Object)player);
        this.owner = player.getUUID();
        this.setChanged();
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.equals(new UUID(0L, 0L));
    }

    public ContainerData getContainerData() {
        return this.data;
    }

    public void dropInventoryContents() {
        if (this.level.isClientSide || this.items.isEmpty()) {
            return;
        }
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)stack);
        }
    }

    private void spawnEntity(EntityType<?> entityType, Level level, BlockPos position) {
        if (entityType == null || level == null || position == null) {
            return;
        }
        Entity entity = entityType.create(level, EntitySpawnReason.EVENT);
        if (entity != null) {
            log.debug("Spawn entity {} at position {} for mob farm block entity at {}", (Object)entity, (Object)position, (Object)this.getBlockPos());
            entity.setPos((double)position.getX() + 0.5, (double)(position.getY() + 1), (double)position.getZ() + 0.5);
            level.addFreshEntity(entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setsMobCaptureItem(ItemStack itemStack) {
        Level level;
        LivingEntity livingEntity;
        log.debug("Sets mob capture item {} in mob farm block entity at {}", (Object)itemStack, (Object)this.getBlockPos());
        MobCaptureData mobCaptureData = this.getMobCaptureData();
        EntityType<?> entityType = mobCaptureData != null ? mobCaptureData.entityType() : null;
        LivingEntity livingEntity2 = livingEntity = entityType != null ? (LivingEntity)entityType.create(this.level, EntitySpawnReason.EVENT) : null;
        if (livingEntity != null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            try {
                this.capturedMobExperience = ExperienceManager.getExperienceReward(livingEntity, serverLevel);
            }
            finally {
                livingEntity.discard();
            }
        } else {
            this.capturedMobExperience = 0;
        }
    }

    private void removedMobCaptureItem(ItemStack itemStack) {
        log.debug("Removed mob capture item {} from mob farm block entity at {}", (Object)itemStack, (Object)this.getBlockPos());
        this.capturedMobExperience = -1;
    }

    protected Component getDefaultName() {
        return TextComponent.getTranslatedTextRaw("container.easy_mob_farm.mob_farm");
    }

    protected AbstractContainerMenu createMenu(int windowId, Inventory inventory) {
        return null;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack itemStack = ContainerHelper.removeItem(this.items, (int)index, (int)count);
        if (index == MobFarmSlot.CAPTURED_MOB.index() && !itemStack.isEmpty()) {
            this.removedMobCaptureItem(itemStack);
            this.syncChanges();
        }
        return itemStack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack itemStack = ContainerHelper.takeItem(this.items, (int)index);
        if (index == MobFarmSlot.CAPTURED_MOB.index() && !itemStack.isEmpty()) {
            this.removedMobCaptureItem(itemStack);
        }
        return itemStack;
    }

    public void setItem(int index, ItemStack itemStack) {
        this.items.set(index, (Object)itemStack);
        if (itemStack.getCount() > this.getMaxStackSize()) {
            itemStack.setCount(this.getMaxStackSize());
        }
        if (index == MobFarmSlot.CAPTURED_MOB.index() && !itemStack.isEmpty()) {
            this.setsMobCaptureItem(itemStack.copy());
        }
        this.syncChanges();
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        if (this.provider != null) {
            CompoundTag tag = new CompoundTag();
            this.saveAdditional(tag, this.provider);
        }
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean stillValid(Player player) {
        return player.isAlive();
    }

    public void clearContent() {
        this.items.clear();
    }

    public int[] getSlotsForFace(Direction direction) {
        if (direction == Direction.DOWN || direction == Direction.NORTH || direction == Direction.EAST || direction == Direction.SOUTH || direction == Direction.WEST) {
            return RESULT_SLOTS;
        }
        if (direction == Direction.UP) {
            return new int[0];
        }
        return new int[0];
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack itemStack, Direction direction) {
        return direction == Direction.UP;
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack itemStack, Direction direction) {
        if (direction == Direction.UP) {
            return false;
        }
        for (int resultSlot : RESULT_SLOTS) {
            if (slot != resultSlot) continue;
            return true;
        }
        return false;
    }

    public void preRemoveSideEffects(BlockPos blockPos, BlockState blockState) {
        BlockEntity blockEntity = this.level.getBlockEntity(blockPos);
        if (blockEntity instanceof MobFarmBlockEntity) {
            MobFarmBlockEntity mobFarmBlockEntity = (MobFarmBlockEntity)blockEntity;
            mobFarmBlockEntity.dropInventoryContents();
        }
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
        if (compoundTag.contains(TIER_LEVEL_TAG) && compoundTag.getInt(TIER_LEVEL_TAG).isPresent()) {
            this.setFarmTierLevel((Integer)compoundTag.getInt(TIER_LEVEL_TAG).get());
        }
        if (compoundTag.contains(FARM_TYPE_TAG) && compoundTag.getString(FARM_TYPE_TAG).isPresent()) {
            this.mobFarmType = MobFarmType.valueOf((String)compoundTag.getString(FARM_TYPE_TAG).get());
        }
        if (compoundTag.contains(CAPTURED_MOB_EXPERIENCE_TAG) && compoundTag.getInt(CAPTURED_MOB_EXPERIENCE_TAG).isPresent() && compoundTag.getInt(CAPTURED_MOB_EXPERIENCE_TAG).orElse(-1) >= 0) {
            this.capturedMobExperience = (Integer)compoundTag.getInt(CAPTURED_MOB_EXPERIENCE_TAG).get();
        }
        if (compoundTag.contains(OWNER_TAG)) {
            this.owner = UUIDUtils.readUUID(compoundTag, OWNER_TAG);
        }
        this.provider = provider;
    }

    public void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
        compoundTag.putInt(TIER_LEVEL_TAG, this.farmTierLevel);
        compoundTag.putString(FARM_TYPE_TAG, this.mobFarmType.name());
        if (this.capturedMobExperience >= 0) {
            compoundTag.putInt(CAPTURED_MOB_EXPERIENCE_TAG, this.capturedMobExperience);
        }
        if (this.owner != null) {
            UUIDUtils.writeUUID(compoundTag, OWNER_TAG, this.owner);
        }
    }
}

