/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.DyeColor;

public enum MobColor implements StringRepresentable
{
    NONE(0, null),
    BLACK(1, DyeColor.BLACK),
    BLUE(2, DyeColor.BLUE),
    BROWN(3, DyeColor.BROWN),
    CYAN(4, DyeColor.CYAN),
    GRAY(5, DyeColor.GRAY),
    GREEN(6, DyeColor.GREEN),
    LIGHT_BLUE(7, DyeColor.LIGHT_BLUE),
    LIGHT_GRAY(8, DyeColor.LIGHT_GRAY),
    LIME(9, DyeColor.LIME),
    MAGENTA(10, DyeColor.MAGENTA),
    ORANGE(11, DyeColor.ORANGE),
    PINK(12, DyeColor.PINK),
    PURPLE(13, DyeColor.PURPLE),
    RED(14, DyeColor.RED),
    WHITE(15, DyeColor.WHITE),
    YELLOW(16, DyeColor.YELLOW);

    public static final StringRepresentable.EnumCodec<MobColor> CODEC;
    private static final IntFunction<MobColor> BY_ID;
    public static final StreamCodec<ByteBuf, MobColor> STREAM_CODEC;
    private final int id;
    private final String name;
    private final DyeColor dyeColor;

    private MobColor(int id, DyeColor dyeColor) {
        this.id = id;
        this.name = this.name().toLowerCase(Locale.ROOT);
        this.dyeColor = dyeColor;
    }

    public static MobColor byName(String colorName) {
        if (colorName == null || colorName.isEmpty()) {
            return NONE;
        }
        try {
            return MobColor.valueOf(colorName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return NONE;
        }
    }

    public static MobColor byDyeColor(DyeColor dyeColor) {
        if (dyeColor == null) {
            return NONE;
        }
        return switch (dyeColor) {
            default -> throw new MatchException(null, null);
            case DyeColor.BLACK -> BLACK;
            case DyeColor.BLUE -> BLUE;
            case DyeColor.BROWN -> BROWN;
            case DyeColor.CYAN -> CYAN;
            case DyeColor.GRAY -> GRAY;
            case DyeColor.GREEN -> GREEN;
            case DyeColor.LIGHT_BLUE -> LIGHT_BLUE;
            case DyeColor.LIGHT_GRAY -> LIGHT_GRAY;
            case DyeColor.LIME -> LIME;
            case DyeColor.MAGENTA -> MAGENTA;
            case DyeColor.ORANGE -> ORANGE;
            case DyeColor.PINK -> PINK;
            case DyeColor.PURPLE -> PURPLE;
            case DyeColor.RED -> RED;
            case DyeColor.WHITE -> WHITE;
            case DyeColor.YELLOW -> YELLOW;
        };
    }

    public static MobColor byVillagerType(ResourceKey<VillagerType> villagerType) {
        if (villagerType == null) {
            return NONE;
        }
        if (villagerType == VillagerType.PLAINS) {
            return LIGHT_GRAY;
        }
        if (villagerType == VillagerType.DESERT) {
            return YELLOW;
        }
        if (villagerType == VillagerType.SAVANNA) {
            return ORANGE;
        }
        if (villagerType == VillagerType.TAIGA) {
            return BROWN;
        }
        if (villagerType == VillagerType.SNOW) {
            return WHITE;
        }
        if (villagerType == VillagerType.JUNGLE) {
            return GREEN;
        }
        if (villagerType == VillagerType.SWAMP) {
            return PURPLE;
        }
        return NONE;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public String getSerializedName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(MobColor::values);
        BY_ID = ByIdMap.continuous(MobColor::getId, (Object[])MobColor.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, MobColor::getId);
    }
}

