/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class MobEntityData {
    public static final String DATA_TAG = "Data";
    protected static final String HEALTH_TAG = "Health";
    protected static final Set<String> SAFE_TO_REMOVE_BASE_TAGS = Set.of("Air", "Dead", "DeathTime", "FallDistance", "FallFlying", "Fire", "HurtByTimestamp", "HurtTime", "InWaterTime", "Motion", "OnGround", "PortalCooldown", "Pos", "Rotation");
    protected static final Set<String> UNSAFE_TO_REMOVE_BASE_TAGS = Set.of("UUID", "Attributes");
    protected static final Set<String> SAFE_TO_REMOVE_MOB_CAPTURE_CARD_TAGS = Set.of("AbsorptionAmount", "ActiveEffects", "AngerTime", "Brain", "CanBreakDoors", "CanPickUpLoot", "CanUpdate", "CurativeItems", "DrownedConversionTime", "Health", "Invulnerable", "LeftHanded", "PersistenceRequired", "TimeInOverworld");

    private MobEntityData() {
    }

    public static CompoundTag getMobEntityData(EntityType<?> entityType) {
        return new CompoundTag();
    }

    public static CompoundTag getMobEntityData(LivingEntity livingEntity) {
        CompoundTag compoundTag = new CompoundTag();
        livingEntity.saveWithoutId(compoundTag);
        if (livingEntity.isDeadOrDying()) {
            compoundTag.putFloat(HEALTH_TAG, livingEntity.getMaxHealth());
        }
        compoundTag = MobEntityData.removeSafeToRemoveBaseTags(compoundTag);
        if (!livingEntity.hasCustomName()) {
            compoundTag = MobEntityData.removeUnsafeToRemoveBaseTags(compoundTag);
        }
        return compoundTag;
    }

    public static CompoundTag getMobEntityData(CompoundTag compoundTag) {
        if (compoundTag == null) {
            return new CompoundTag();
        }
        if (compoundTag.contains(DATA_TAG) && compoundTag.getCompound(DATA_TAG).isPresent()) {
            compoundTag = (CompoundTag)compoundTag.getCompound(DATA_TAG).get();
        }
        return MobEntityData.removeSafeToRemoveBaseTags(compoundTag);
    }

    private static CompoundTag removeSafeToRemoveBaseTags(CompoundTag compoundTag) {
        CompoundTag cleanedCompoundTag = new CompoundTag();
        for (String key : compoundTag.keySet()) {
            if (SAFE_TO_REMOVE_BASE_TAGS.contains(key)) continue;
            cleanedCompoundTag.put(key, compoundTag.get(key));
        }
        return cleanedCompoundTag;
    }

    private static CompoundTag removeUnsafeToRemoveBaseTags(CompoundTag compoundTag) {
        CompoundTag cleanedCompoundTag = new CompoundTag();
        for (String key : compoundTag.keySet()) {
            if (UNSAFE_TO_REMOVE_BASE_TAGS.contains(key)) continue;
            cleanedCompoundTag.put(key, compoundTag.get(key));
        }
        return cleanedCompoundTag;
    }

    public static CompoundTag removeSafeToRemoveMobCaptureCardTags(CompoundTag compoundTag) {
        CompoundTag cleanedCompoundTag = new CompoundTag();
        for (String key : compoundTag.keySet()) {
            if (SAFE_TO_REMOVE_MOB_CAPTURE_CARD_TAGS.contains(key)) continue;
            if (key.equals("Inventory")) {
                if (compoundTag.get(key) == null || !compoundTag.getList(key).isPresent()) continue;
                cleanedCompoundTag.put(key, compoundTag.get(key));
                continue;
            }
            cleanedCompoundTag.put(key, compoundTag.get(key));
        }
        return cleanedCompoundTag;
    }
}

