/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Rarity;

public record MobCaptureCardDefinition(ResourceLocation entity, EntityType<?> entityType, ResourceLocation model, Rarity rarity, float scale, boolean requiresKilledByPlayer, boolean requiresAnimationTick, Map<String, Variant> variants, Map<String, Color> colors) {
    public MobCaptureCardDefinition(ResourceLocation entity, ResourceLocation model, Rarity rarity, float scale, boolean requiresKilledByPlayer, boolean requiresAnimationTick, Map<String, Variant> variants, Map<String, Color> colors) {
        this(entity, MobCaptureCardDefinition.getEntityType(entity), MobCaptureCardDefinition.getModelResourceLocation(model, rarity != null ? rarity : Rarity.COMMON), rarity != null ? rarity : Rarity.COMMON, scale >= 0.0f ? scale : 1.0f, requiresKilledByPlayer, requiresAnimationTick, variants, colors);
    }

    public static MobCaptureCardDefinition decode(FriendlyByteBuf buffer) {
        ResourceLocation entity = buffer.readResourceLocation();
        ResourceLocation model = buffer.readResourceLocation();
        Rarity rarity = (Rarity)buffer.readEnum(Rarity.class);
        float scale = buffer.readFloat();
        boolean requiresKilledByPlayer = buffer.readBoolean();
        boolean requiresAnimationTick = buffer.readBoolean();
        Map colors = buffer.readMap(FriendlyByteBuf::readUtf, buf -> new Color(buf.readResourceLocation()));
        Map variants = buffer.readMap(FriendlyByteBuf::readUtf, buf -> {
            ResourceLocation variantModel = buf.readResourceLocation();
            Map variantColors = buf.readMap(FriendlyByteBuf::readUtf, b -> new Color(b.readResourceLocation()));
            return new Variant(variantModel, variantColors);
        });
        return new MobCaptureCardDefinition(entity, model, rarity, scale, requiresKilledByPlayer, requiresAnimationTick, variants, colors);
    }

    public static EntityType<?> getEntityType(ResourceLocation resourceLocation) {
        return EntityType.byString((String)resourceLocation.toString()).orElse(null);
    }

    public static ResourceLocation getModelResourceLocation(ResourceLocation resourceLocation, Rarity rarity) {
        if (resourceLocation != null) {
            return resourceLocation;
        }
        switch (rarity) {
            case UNCOMMON: {
                return ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"item/mob_capture_card/default_uncommon");
            }
            case RARE: {
                return ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"item/mob_capture_card/default_rare");
            }
            case EPIC: {
                return ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"item/mob_capture_card/default_epic");
            }
        }
        return ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"item/mob_capture_card/default");
    }

    public MobCaptureCardDefinition withEntityType(EntityType<?> entityType) {
        return new MobCaptureCardDefinition(this.entity, entityType, this.model, this.rarity, this.scale, this.requiresKilledByPlayer, this.requiresAnimationTick, this.variants, this.colors);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.entity);
        buffer.writeResourceLocation(this.model);
        buffer.writeEnum((Enum)this.rarity);
        buffer.writeFloat(this.scale);
        buffer.writeBoolean(this.requiresKilledByPlayer);
        buffer.writeBoolean(this.requiresAnimationTick);
        buffer.writeMap(this.colors, FriendlyByteBuf::writeUtf, (buf, color) -> buf.writeResourceLocation(color.model()));
        buffer.writeMap(this.variants, FriendlyByteBuf::writeUtf, (buf, variant) -> {
            buf.writeResourceLocation(variant.model());
            buf.writeMap(variant.colors(), FriendlyByteBuf::writeUtf, (b, color) -> b.writeResourceLocation(color.model()));
        });
    }

    public record Variant(ResourceLocation model, Map<String, Color> colors) {
    }

    public record Color(ResourceLocation model) {
    }
}

