/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.capture;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobEntityData;
import de.markusbordihn.easymobfarm.data.capture.MobVariantData;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobCaptureManager {
    public static final String MOB_CAPTURE_DATA_TAG = "MobCaptureData";
    public static final String COLOR_TAG = "Color";
    public static final String VARIANT_TAG = "variant";
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[MobCaptureManager]";

    private MobCaptureManager() {
    }

    public static class_1799 getMobCaptureCardItem(class_1299<?> entityType, class_1937 level) {
        if (entityType == null || level == null) {
            return null;
        }
        class_1297 entity = entityType.method_5883(level);
        if (entity == null) {
            log.error("{} Unable to create entity {}!", (Object)LOG_PREFIX, entityType);
            return null;
        }
        if (!(entity instanceof class_1309)) {
            log.error("{} Entity {} is not a living entity!", (Object)LOG_PREFIX, entityType);
            entity.method_31472();
            return null;
        }
        class_1309 livingEntity = (class_1309)entity;
        class_1799 itemStack = MobCaptureManager.getMobCaptureCardItem(livingEntity);
        log.debug("{} Captured mob {} with data:{}.", (Object)LOG_PREFIX, entityType, (Object)itemStack);
        entity.method_31472();
        return itemStack;
    }

    public static class_1799 getMobCaptureCardItem(class_1309 livingEntity) {
        if (livingEntity == null || livingEntity instanceof class_1657 || livingEntity.method_37908().field_9236) {
            return null;
        }
        MobCaptureCardItem mobCaptureCardItem = MobCaptureCardItem.getMobCaptureCardItem();
        if (mobCaptureCardItem == null) {
            log.error("{} Unable to find mob capture card item!", (Object)LOG_PREFIX);
            return null;
        }
        MobCaptureData mobCaptureData = new MobCaptureData(livingEntity);
        if (mobCaptureData.entityType() == null || mobCaptureData.data() == null) {
            log.debug("{} Unable to get mob capture data from living entity {}.", (Object)LOG_PREFIX, (Object)livingEntity);
            return null;
        }
        mobCaptureData = mobCaptureData.withData(MobEntityData.removeSafeToRemoveMobCaptureCardTags(mobCaptureData.data()));
        class_1799 itemStack = new class_1799((class_1935)mobCaptureCardItem);
        MobCaptureManager.writeMobCaptureData(itemStack, mobCaptureData);
        log.debug("{} Captured mob {} with data:{}", (Object)LOG_PREFIX, mobCaptureData.entityType(), (Object)mobCaptureData.data());
        return itemStack;
    }

    public static boolean releaseMob(MobCaptureData mobCaptureData, class_2338 blockPos, class_3218 serverLevel) {
        if (mobCaptureData == null || mobCaptureData.entityType() == null) {
            return false;
        }
        class_1299<?> entityType = mobCaptureData.entityType();
        if (entityType == null) {
            return false;
        }
        class_1297 entity = entityType.method_5883((class_1937)serverLevel);
        if (entity == null) {
            log.error("{} Unable to create entity {}!", (Object)LOG_PREFIX, entityType);
            return false;
        }
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            livingEntity.method_5749(mobCaptureData.data());
        }
        class_2680 blockState = serverLevel.method_8320(blockPos);
        class_2338 finalBlockPos = null;
        if (blockState.method_27852(class_2246.field_10479) || blockState.method_27852(class_2246.field_10376)) {
            finalBlockPos = blockPos;
        } else {
            class_2680 blockStateBlockAbove = serverLevel.method_8320(blockPos.method_10084());
            if (blockStateBlockAbove.method_26215() || blockStateBlockAbove.method_27852(class_2246.field_10382)) {
                finalBlockPos = blockPos.method_10084();
            }
        }
        if (finalBlockPos != null) {
            entity.method_5808((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 1.0, (double)blockPos.method_10260() + 0.5, 0.0f, 0.0f);
            serverLevel.method_8649(entity);
            log.debug("{} Released mob {} with data:{} at block position {}.", (Object)LOG_PREFIX, entityType, (Object)mobCaptureData.data(), (Object)blockPos);
            return true;
        }
        log.warn("{} Unable to release mob {} with data:{} at block position {}.", (Object)LOG_PREFIX, entityType, (Object)mobCaptureData.data(), (Object)blockPos);
        return true;
    }

    public static class_1799 createMobCaptureCard(class_1935 itemLike, MobCaptureData mobCaptureData) {
        if (itemLike == null) {
            return null;
        }
        class_1799 itemStack = new class_1799(itemLike);
        MobCaptureManager.writeMobCaptureData(itemStack, mobCaptureData);
        return itemStack;
    }

    public static class_1799 createMobCaptureCard(class_1935 itemLike, class_1299<?> entityType, String variant, class_1767 dyeColor) {
        if (itemLike == null || entityType == null) {
            return null;
        }
        MobCaptureData mobCaptureData = new MobCaptureData(entityType).withFoil(false);
        class_2487 compoundTag = new class_2487();
        if (variant != null) {
            mobCaptureData = mobCaptureData.withVariant(variant);
            if (entityType == class_1299.field_16281) {
                compoundTag.method_10582(VARIANT_TAG, variant);
            } else if (entityType == class_1299.field_37419) {
                compoundTag.method_10582(VARIANT_TAG, class_7923.field_41164.method_10221((Object)MobVariantData.getFrogVariant(variant)).toString());
            }
        }
        if (dyeColor != null) {
            mobCaptureData = mobCaptureData.withColor(dyeColor);
            compoundTag.method_10569(COLOR_TAG, dyeColor.method_7789());
        }
        return MobCaptureManager.createMobCaptureCard(itemLike, mobCaptureData.withData(compoundTag));
    }

    public static void writeMobCaptureData(class_1799 itemStack, MobCaptureData mobCaptureData) {
        if (itemStack == null || itemStack.method_7960() || mobCaptureData == null) {
            return;
        }
        class_2487 compoundTag = itemStack.method_7948();
        compoundTag.method_10566(MOB_CAPTURE_DATA_TAG, (class_2520)mobCaptureData.createTag());
        itemStack.method_7980(compoundTag);
    }

    public static boolean hasMobCaptureData(class_1799 itemStack) {
        return itemStack != null && !itemStack.method_7960() && itemStack.method_7985() && itemStack.method_7969().method_10545(MOB_CAPTURE_DATA_TAG);
    }

    public static MobCaptureData getMobCaptureData(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7960()) {
            return null;
        }
        class_2487 tag = itemStack.method_7969();
        if (tag != null && tag.method_10545(MOB_CAPTURE_DATA_TAG)) {
            return new MobCaptureData(tag.method_10562(MOB_CAPTURE_DATA_TAG));
        }
        return new MobCaptureData(itemStack, tag);
    }
}

