/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.model;

import de.markusbordihn.easymobfarm.config.MobCaptureCardModelsConfig;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ModelManagerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    public static final Set<String> KNOWN_MISSING_MODELS = new HashSet<String>();
    public static final String LOG_PREFIX = "[Model Manager]";
    public static final class_1091 DEFAULT_MODEL = new class_1091(new class_2960("easy_mob_farm", "mob_capture_card/default"), "inventory");
    public static final class_1091 DEFAULT_UNCOMMON_MODEL = new class_1091(new class_2960("easy_mob_farm", "mob_capture_card/default_uncommon"), "inventory");
    public static final class_1091 DEFAULT_RARE_MODEL = new class_1091(new class_2960("easy_mob_farm", "mob_capture_card/default_rare"), "inventory");
    public static final class_1091 DEFAULT_EPIC_MODEL = new class_1091(new class_2960("easy_mob_farm", "mob_capture_card/default_epic"), "inventory");
    public static final class_1091 DEFAULT_FISH_MODEL = new class_1091(new class_2960("easy_mob_farm", "mob_capture_card/default_fish"), "inventory");

    private static boolean isFish(class_1299<?> entityType) {
        class_2960 entityId = class_1299.method_5890(entityType);
        class_1792 correspondingItem = (class_1792)class_7923.field_41178.method_10223(entityId);
        return correspondingItem != class_1802.field_8162 && correspondingItem.method_40131().method_40220(class_3489.field_15527);
    }

    default public class_1087 getModel(class_1091 modelResourceLocation) {
        if (modelResourceLocation == null) {
            return null;
        }
        class_1087 bakedModel = class_310.method_1551().method_1554().method_4742(modelResourceLocation);
        if (bakedModel == class_310.method_1551().method_1554().method_4744()) {
            if (KNOWN_MISSING_MODELS.add(modelResourceLocation.toString())) {
                log.error("{} Missing model for '{}'", (Object)LOG_PREFIX, (Object)modelResourceLocation);
            }
            return null;
        }
        return bakedModel != class_310.method_1551().method_1554().method_4744() ? bakedModel : null;
    }

    default public class_1087 getModel(String type, String variant, class_1767 color) {
        class_1091 modelResourceLocation = MobCaptureCardModelsConfig.getModelResourceLocation(type, variant, color);
        if (modelResourceLocation == null) {
            if (KNOWN_MISSING_MODELS.add(type)) {
                log.warn("{} Missing custom model for type '{}', variant '{}' with color '{}'", (Object)LOG_PREFIX, (Object)type, (Object)variant, (Object)color);
            }
            return null;
        }
        return this.getModel(modelResourceLocation);
    }

    default public class_1087 getModel(String type) {
        class_1091 modelResourceLocation = MobCaptureCardModelsConfig.getModelResourceLocation(type);
        if (modelResourceLocation == null) {
            if (KNOWN_MISSING_MODELS.add(type)) {
                log.warn("{} Missing custom model for type '{}'", (Object)LOG_PREFIX, (Object)type);
            }
            return null;
        }
        return this.getModel(modelResourceLocation);
    }

    default public class_1087 getModel(class_1814 rarity) {
        if (rarity == null) {
            return null;
        }
        class_1091 modelResourceLocation = switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case class_1814.field_8906 -> DEFAULT_MODEL;
            case class_1814.field_8907 -> DEFAULT_UNCOMMON_MODEL;
            case class_1814.field_8903 -> DEFAULT_RARE_MODEL;
            case class_1814.field_8904 -> DEFAULT_EPIC_MODEL;
        };
        return this.getModel(modelResourceLocation);
    }

    default public class_1087 getModel(class_1299<?> entityType) {
        if (entityType == null || !ModelManagerInterface.isFish(entityType)) {
            return null;
        }
        return this.getModel(DEFAULT_FISH_MODEL);
    }

    default public class_1087 getDefaultModel() {
        return this.getModel(DEFAULT_MODEL);
    }
}

